<?php
header('Content-Type: application/json');
require 'conexion.php';

$localidad = $_GET['localidad'] ?? '';
if (!$localidad) {
  echo json_encode([]);
  exit;
}

$stmt = $conn->prepare("SELECT DISTINCT barrio FROM propiedades WHERE localidad = ? AND barrio <> '' ORDER BY barrio ASC");
$stmt->bind_param("s", $localidad);
$stmt->execute();
$res = $stmt->get_result();

$barrios = [];
while ($row = $res->fetch_assoc()) {
  $barrios[] = $row['barrio'];
}

echo json_encode($barrios);
?>
