<?php
// contacto.php — Página de contacto con la misma navbar inyectada
header('Content-Type: text/html; charset=UTF-8');

// Mensajes por querystring
$enviado = isset($_GET['enviado']) && $_GET['enviado'] == '1';
$error   = isset($_GET['error']) && $_GET['error'] == '1';

// Datos visibles
$whatsapp_link = 'https://wa.me/5492257528166'; // Cambiá el número
$email_publico = 'lagarpropiedades@gmail.com';   // Visible en la tarjeta
$direccion = 'Francisco de las Carreras 291, Mar de Ajó, Buenos Aires';
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Contacto | Lagar Servicios Inmobiliarios</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="robots" content="index,follow">
  <meta name="description" content="Contactanos por consultas, tasaciones o propiedades. Respondemos en menos de 24 horas.">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
  <link rel="icon" href="img/faviconcin.png" type="image/png">

  <style>
    /* Utilidades de la página de contacto */
    :root{
      --soft:#f6f8fb;
      --text:#222;
    }
    body{ color:var(--text); background:#fff; }
    .section-padding{ padding: 60px 0; }
    .bg-soft{ background: var(--soft); }
    .contact-card{ background:#fff; border:1px solid #eef2f7; border-radius:16px; }
    .icon-badge{
      width:48px;height:48px; display:grid; place-items:center;
      border-radius:12px; background:var(--soft);
      font-size:22px;
    }
    .whatsapp-fab{
      position:fixed; right:16px; bottom:16px;
      width:56px; height:56px; border-radius:50%;
      display:grid; place-items:center; background:#25D366;
      color:#fff; text-decoration:none; box-shadow:0 8px 20px rgba(0,0,0,.18); z-index:1050;
    }
    .whatsapp-fab:hover{ filter:brightness(.95); }
    .toast-fixed{ position: fixed; bottom: 88px; right: 16px; z-index: 1051; min-width: 260px; }

    /* Fix overflow horizontal en móvil */
    html, body { max-width: 100%; overflow-x: hidden; }

    /* Hero superior */
    .hero-min{
      background: linear-gradient(135deg, rgba(13,110,253,.08), rgba(13,110,253,.03));
      border-bottom: 1px solid #eef2f7;
    }
  </style>
</head>
<body>

  <!-- ===== NAVBAR INYECTADA (tal cual nos pasaste) ===== -->
  <nav class="navbar navbar-expand-lg navbar-dark navbar-premium sticky-top">
    <div class="container">
      <a class="navbar-brand d-flex align-items-center gap-2" href="#inicio">
        <img src="img/faviconcin3.png" class="brand-img" alt="Logo">
        <span class="brand-text">Lagar Servicios Inmobiliarios</span>
      </a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav" aria-controls="nav" aria-expanded="false" aria-label="Abrir menú">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div id="nav" class="collapse navbar-collapse">
        <ul class="navbar-nav ms-auto">
          <li class="nav-item"><a class="nav-link" href="../#inicio">INICIO</a></li>
          <li class="nav-item"><a class="nav-link" href="https://lagarpropiedades.com/buscador.php?localidad=&operacion=Comprar&tipo=&ambientes=">VENTA</a></li>
          <li class="nav-item"><a class="nav-link" href="https://lagarpropiedades.com/buscador.php?localidad=&operacion=Alquilar&tipo=&ambientes=">ALQUILERES TEMPORARIOS</a></li>
          <li class="nav-item"><a class="nav-link" href="../#tasacion">TASACIÓN</a></li>
          <li class="nav-item"><a class="nav-link" href="../#equipo">EQUIPO LAGAR</a></li>
          <li class="nav-item"><a class="nav-link" href="../#servicios-contables">SERVICIOS CONTABLES</a></li>
          <li class="nav-item"><a class="nav-link" href="contacto.php">CONTACTO</a></li>
        </ul>
      </div>
    </div>
  </nav>
  <style>
    /* ====== Theme (igual a index/propiedad) ====== */
    :root{
      --primary:#8f82ae;
      --primary-600:#7c6ca0;
      --primary-700:#6b5d90;
      --accent:#e74c3c;
      --dark:#1e293b;
      --muted:#64748b;
      --line:#e2e8f0;
      --bg:#f8fafc;
      --radius:14px;
      --shadow:0 6px 18px rgba(2,8,23,.08);
      --shadow-lg:0 14px 32px rgba(2,8,23,.15);
      --grad:linear-gradient(135deg, var(--primary) 0%, #5d89ff 100%);
    }
    body{font-family:'Poppins',system-ui,-apple-system,Segoe UI,Roboto,'Helvetica Neue',Arial,sans-serif;color:var(--dark);background:#fff}
    h1,h2,h3{font-family:'Playfair Display',serif}
    .navbar-premium{background: rgba(17,24,39,.6);backdrop-filter:saturate(140%) blur(8px);border-bottom:1px solid rgba(255,255,255,.08)}
    .brand-img{height:30px}
    .search-wrap{background:var(--grad);color:#fff;padding:2.25rem 0;box-shadow:var(--shadow)}
    .search-wrap .form-label{color:#fff;font-weight:600}
    .search-wrap .form-select{border:1px solid rgba(255,255,255,.4);background:#fff;border-radius:10px}
    .btn-theme{background:var(--primary);border:none;border-radius:12px;padding:.75rem 1.25rem;font-weight:600;box-shadow:var(--shadow)}
    .btn-theme:hover{background:var(--primary-600)}
    .prop-card{border:none;border-radius:16px;overflow:hidden;background:#fff;box-shadow:var(--shadow);transition:.28s;height:100%}
    .prop-card:hover{transform:translateY(-6px);box-shadow:var(--shadow-lg)}
    .prop-img{height:220px;width:100%;object-fit:cover}
    .prop-title{color:#0f172a;font-weight:700}
    .price{color:var(--accent);font-weight:800;font-size:1.1rem}
    .meta{color:var(--muted);font-size:.95rem}
    .badge-feature{background:var(--bg);border:1px solid var(--line);border-radius:999px;padding:.35rem .7rem;font-weight:600;color:var(--muted)}
    .nores{background:var(--bg);border:1px dashed var(--line);border-radius:16px;padding:2.5rem;text-align:center}
  </style>
  <!-- ===== FIN NAVBAR INYECTADA ===== -->

  <!-- ===== Encabezado / Hero ===== -->
  <header class="hero-min py-5">
    <div class="container">
      <div class="row align-items-center g-4">
        <div class="col-lg-7">
          <h1 class="display-6 mb-2">Contacto</h1>
          <p class="lead text-muted mb-0">Contanos qué necesitás y te respondemos en menos de 24 horas.</p>
        </div>
      </div>
    </div>
  </header>

  <!-- ===== Alertas por ?enviado=1 / ?error=1 ===== -->
  <div class="container mt-4">
    <?php if ($enviado): ?>
      <div class="alert alert-success d-flex align-items-center gap-2" role="alert">
        <i class="bi bi-check2-circle fs-5"></i>
        <div>¡Tu mensaje fue enviado correctamente! Gracias por escribirnos.</div>
      </div>
    <?php elseif ($error): ?>
      <div class="alert alert-warning d-flex align-items-center gap-2" role="alert">
        <i class="bi bi-exclamation-triangle fs-5"></i>
        <div>No se pudo enviar el mensaje. Probá nuevamente o escribinos por WhatsApp.</div>
      </div>
    <?php endif; ?>
  </div>

  <!-- ===== Sección Contacto ===== -->
  <section id="contacto" class="section-padding">
    <div class="container">
      <div class="row g-5">
        <!-- Columna: Formulario -->
        <div class="col-lg-7">
          <div class="p-4 p-lg-5 contact-card">
            <h2 class="h4 mb-3">Escribinos</h2>
            <p class="text-muted mb-4">Completá el formulario y te respondemos a la brevedad.</p>

            <form action="formulario_contacto.php" method="post" class="needs-validation" novalidate>
              <!-- Honeypot (NO completar) -->
              <input type="text" name="empresa" class="d-none" tabindex="-1" autocomplete="off">

              <div class="row g-3">
                <div class="col-md-6">
                  <label class="form-label">Nombre y Apellido</label>
                  <input type="text" name="nombre" class="form-control" required>
                  <div class="invalid-feedback">Completá tu nombre.</div>
                </div>
                <div class="col-md-6">
                  <label class="form-label">Localidad</label>
                  <input type="text" name="localidad" class="form-control" placeholder="Ciudad / Barrio">
                </div>
                <div class="col-md-6">
                  <label class="form-label">Teléfono / WhatsApp</label>
                  <input type="tel" name="telefono" class="form-control" placeholder="+54 9 ...">
                </div>
                <div class="col-md-6">
                  <label class="form-label">Email</label>
                  <input type="email" name="email" class="form-control" placeholder="tunombre@email.com">
                </div>
                <div class="col-12">
                  <label class="form-label">Mensaje</label>
                  <textarea name="mensaje" class="form-control" rows="5" required></textarea>
                  <div class="invalid-feedback">Escribí un mensaje.</div>
                </div>
              </div>

              <div class="d-flex align-items-center gap-3 mt-4">
                <button type="submit" class="btn btn-theme">
                  <i class="bi bi-send me-1"></i> Enviar mensaje
                </button>
                <a class="btn btn-outline-success" href="<?php echo htmlspecialchars($whatsapp_link); ?>" target="_blank" rel="noopener">
                  <i class="bi bi-whatsapp me-1"></i> Comunicarse por WhatsApp
                </a>
              </div>
            </form>
          </div>
        </div>

        <!-- Columna: Datos / Mapa -->
        <div class="col-lg-5">
          <div class="p-4 p-lg-5 contact-card mb-4">
            <div class="d-flex align-items-center gap-3 mb-3">
              <div class="icon-badge"><i class="bi bi-envelope"></i></div>
              <div>
                <div class="fw-semibold">Email</div>
                <a href="mailto:<?php echo htmlspecialchars($email_publico); ?>">
                  <?php echo htmlspecialchars($email_publico); ?>
                </a>
              </div>
            </div>

            <div class="d-flex align-items-center gap-3 mb-3">
              <div class="icon-badge"><i class="bi bi-geo-alt"></i></div>
              <div>
                <div class="fw-semibold">Zona</div>
                <div class="text-muted"><?php echo htmlspecialchars($direccion); ?></div>
              </div>
            </div>

            <div class="d-flex align-items-center gap-3">
              <div class="icon-badge"><i class="bi bi-whatsapp"></i></div>
              <div>
                <div class="fw-semibold">WhatsApp</div>
                <a href="<?php echo htmlspecialchars($whatsapp_link); ?>" target="_blank" rel="noopener">
                  Escribir por WhatsApp
                </a>
                <div class="small text-muted">Escribinos ahora</div>
              </div>
            </div>
          </div>

          <div class="ratio ratio-16x9 contact-card">
            <iframe
      src="https://www.google.com/maps?q=Francisco%20de%20las%20Carreras%20291%2C%20Mar%20de%20Aj%C3%B3%2C%20Buenos%20Aires&z=16&output=embed"
      style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"
      title="Mapa: Francisco de las Carreras 291, Mar de Ajó">
    </iframe>

          </div>
        </div>
      </div>
    </div>
  </section>

<style>
    /* FOOTER */
    .site-footer{
      color:#e2e8f0;
      background: linear-gradient(180deg, rgba(15,23,42,.96), rgba(15,23,42,.98)),
                  radial-gradient(1200px 600px at 10% -10%, rgba(143,130,174,.25), transparent 60%);
    }
    .footer-logo{height:32px}
    .footer-title{color:#fff; font-weight:700; letter-spacing:.02em; margin-bottom:.6rem}
    .footer-text{color:#cbd5e1}
    .footer-link{color:#cbd5e1; text-decoration:none}
    .footer-link:hover{color:var(--primary, #8f82ae)}
    .footer-brand{color:#fff}
    .footer-social{color:#cbd5e1; text-decoration:none}
    .footer-social:hover{color:var(--primary, #8f82ae)}
    .footer-cta{background:rgba(255,255,255,.04); border:1px solid rgba(255,255,255,.08); border-radius:14px}
    .footer-sep{border-color:rgba(255,255,255,.12)}
    </style>
    <!-- ===== Footer ===== -->
    <footer class="site-footer mt-5">
      <div class="container py-5">
        <div class="row gy-4">
          <div class="col-md-4">
            <a href="#inicio" class="footer-brand d-flex align-items-center gap-2 mb-3 text-decoration-none">
              <img src="img/faviconcin3.png" alt="Logo" class="footer-logo">
              <span class="fw-bold">Lagar Servicios Inmobiliarios</span>
            </a>
            <p class="footer-text mb-3">Asesoramiento integral en compra, venta y alquiler.</p>
            <div class="d-flex gap-3 fs-5">
              <a class="footer-social bi bi-whatsapp"  href="https://wa.me/5491154571436" target="_blank" aria-label="WhatsApp"></a>
              <a class="footer-social bi bi-instagram" href="https://instagram.com/" target="_blank" aria-label="Instagram"></a>
              <a class="footer-social bi bi-facebook"  href="https://facebook.com/"  target="_blank" aria-label="Facebook"></a>
              <a class="footer-social bi bi-envelope"  href="mailto:lagarpropiedades@gmail.com"    aria-label="Email"></a>
            </div>
          </div>
    
          <div class="col-6 col-md-2">
            <h6 class="footer-title">Explorar</h6>
            <ul class="list-unstyled mb-0">
              <li><a class="footer-link" href="#galeria">Propiedades</a></li>
              <li><a class="footer-link" href="#equipo">Equipo</a></li>
              <li><a class="footer-link" href="#servicios-contables">Servicios Contables</a></li>
              <li><a class="footer-link" href="#tasacion">Tasación</a></li>
              <li><a class="footer-link" href="buscador.php">Buscador</a></li>
            </ul>
          </div>
    
          <div class="col-6 col-md-3">
            <h6 class="footer-title">Contacto</h6>
            <ul class="list-unstyled footer-text mb-0">
              <li class="mb-1"><i class="bi bi-geo-alt me-2"></i>Francisco de las Carreras 291, Mar de Ajó, Buenos Aires</li>
              <li class="mb-1"><i class="bi bi-telephone me-2"></i><a class="footer-link" href="tel:+5491154571436">+54 9 11 5457-1436</a></li>
              <li class="mb-1"><i class="bi bi-envelope me-2"></i><a class="footer-link" href="mailto:lagarpropiedades@gmail.com">lagarpropiedades@gmail.com</a></li>
              <li class="mb-1"><i class="bi bi-clock me-2"></i>Lun a Vie 9–18 h</li>
            </ul>
          </div>
    
          <div class="col-md-3">
            <div class="footer-cta p-3">
              <h6 class="mb-2 fw-bold">¿Querés tasar tu propiedad?</h6>
              <p class="footer-text mb-3">Respondemos rápido y sin costo.</p>
              <a href="#tasacion" class="btn btn-sm btn-theme w-100">Solicitar tasación</a>
            </div>
          </div>
        </div>
    
        <hr class="footer-sep my-4">
    
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-center gap-3 small">
          <div class="text-secondary">
            © <?= date('Y'); ?> Lagar Servicios Inmobiliarios. Todos los derechos reservados.
          </div>
          <div class="d-flex gap-3">
            <a href="#inicio" class="footer-link">Volver arriba ↑</a>
          </div>
        </div>
        <small class="text-white-50">Diseño y desarrollo por <a href="https://netfan.host" class="text-white">NETFAN</a></small>
      </div>
    </footer>


  <!-- WhatsApp flotante + mini toast “Agendar por WhatsApp” -->
  <a class="whatsapp-fab" href="<?php echo htmlspecialchars($whatsapp_link); ?>" target="_blank" aria-label="WhatsApp">
    <i class="bi bi-whatsapp fs-3"></i>
  </a>
  <div class="toast align-items-center text-bg-dark border-0 toast-fixed" role="alert" aria-live="assertive" aria-atomic="true" id="waToast">
    <div class="d-flex">
      <div class="toast-body">
      Comunicarse por WhatsApp
      </div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Validación Bootstrap
    (function () {
      'use strict';
      const forms = document.querySelectorAll('.needs-validation');
      Array.from(forms).forEach(function (form) {
        form.addEventListener('submit', function (event) {
          if (!form.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
          }
          form.classList.add('was-validated');
        }, false);
      });
    })();

    // Toast de ayuda para el FAB
    (function(){
      const fab = document.querySelector('.whatsapp-fab');
      const toastEl = document.getElementById('waToast');
      if (!fab || !toastEl) return;
      const t = new bootstrap.Toast(toastEl, { delay: 2200 });

      let shown = false;
      fab.addEventListener('mouseenter', () => { if(!shown){ t.show(); shown = true; }});
      // En touch, mostrar al hacer scroll un poco
      let scrolled = false;
      window.addEventListener('scroll', () => {
        if(!shown && !scrolled && window.scrollY > 120){
          t.show(); shown = true; scrolled = true;
        }
      });
    })();
  </script>
</body>
</html>
