<?php
/* ==========================================
   enviar.php —   | Form de contacto
   Requiere PHP cURL habilitado
   ========================================== */

// ---------- CONFIG ----------
$para                = 'lagarpropiedades@gmail.com';       // Email de destino
$nombre_envio        = 'Consultas - Sitio Web';      // Remitente visible
$email_reply_default = 'no-responder@netfan.host';      // Reply-To si no hay email válido

$redireccion_exito   = '/index.php?enviado=1';
$redireccion_error   = '/index.php?error=1';
$tiempo_redireccion  = 3; // segundos

date_default_timezone_set('America/Argentina/Cordoba');

// ---------- HELPERS ----------
function clean_line($s){
  // Evita inyección de cabeceras
  return str_replace(["\r","\n","%0a","%0d"], '', trim($s));
}
function esc_html($s){
  return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}
function b64($s){ return base64_encode($s); }
function get_client_ip(){
  foreach (['HTTP_CLIENT_IP','HTTP_X_FORWARDED_FOR','REMOTE_ADDR'] as $k){
    if (!empty($_SERVER[$k])) return $_SERVER[$k];
  }
  return 'desconocida';
}

// ---------- VALIDACIÓN BÁSICA ----------
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: $redireccion_error"); exit;
}

$honeypot  = isset($_POST['empresa']) ? trim($_POST['empresa']) : ''; // honeypot opcional
if ($honeypot !== '') { // Bot detectado
  header("Location: $redireccion_error"); exit;
}

$nombre    = isset($_POST['nombre'])    ? clean_line($_POST['nombre'])    : '';
$localidad = isset($_POST['localidad']) ? clean_line($_POST['localidad']) : '';
$telefono  = isset($_POST['telefono'])  ? clean_line($_POST['telefono'])  : '';
$email     = isset($_POST['email'])     ? clean_line($_POST['email'])     : '';
$mensaje   = isset($_POST['mensaje'])   ? trim($_POST['mensaje'])         : '';

if ($nombre === '' || $mensaje === '') {
  header("Location: $redireccion_error"); exit;
}

// Sanitización extra para cuerpo HTML
$mensaje_html = nl2br(esc_html($mensaje));
$localidad_html = esc_html($localidad);
$telefono_html  = esc_html($telefono);

// Validación de email (opcional)
$email_valido = (filter_var($email, FILTER_VALIDATE_EMAIL)) ? $email : '';

// ---------- ARMADO DE EMAIL ----------
$asunto = "Nueva consulta web";

$ip        = esc_html(get_client_ip());
$ua        = esc_html($_SERVER['HTTP_USER_AGENT'] ?? 'n/d');
$referer   = esc_html($_SERVER['HTTP_REFERER'] ?? 'n/d');
$dominio   = esc_html($_SERVER['HTTP_HOST'] ?? 'n/d');
$fecha     = date('Y-m-d H:i:s');

$html = <<<HTML
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
  body{font-family:Arial,Helvetica,sans-serif;line-height:1.6;color:#222}
  .box{background:#f7f9fc;padding:16px;border-radius:8px;border:1px solid #e5e9f2}
  .tt{color:#111;font-weight:bold}
  .muted{color:#666;font-size:13px}
  h2{margin:0 0 10px 0}
</style>
</head>
<body>
  <h2>Consulta desde el sitio web</h2>
  <div class="box">
    <p><span class="tt">Nombre:</span> {$esc_nombre}</p>
    <p><span class="tt">Localidad:</span> {$localidad_html}</p>
    <p><span class="tt">Teléfono / WhatsApp:</span> {$telefono_html}</p>
    <p><span class="tt">Email:</span> {$esc_email}</p>
    <p><span class="tt">Mensaje:</span><br>{$mensaje_html}</p>
  </div>
  <p class="muted">
    Fecha: {$fecha}<br>
    Dominio: {$dominio}<br>
    IP: {$ip}<br>
    Navegador: {$ua}<br>
    Referer: {$referer}
  </p>
</body>
</html>
HTML;

// Reemplazos seguros para variables escapadas
$html = str_replace(
  ['{$esc_nombre}','{$esc_email}'],
  [esc_html($nombre), esc_html($email_valido ?: '—')],
  $html
);

// ---------- ENVÍO POR API NETFAN ----------
$api_url = 'http://envios.netfan.host/mailer.php';
$post = [
  'html'         => b64($html),
  'asunto'       => b64($asunto),
  'nombre_envio' => b64($nombre_envio),
  'email_reply'  => b64($email_valido ?: $email_reply_default),
  'nombre'       => b64($nombre),
  'para'         => b64($para)
];

$ch = curl_init($api_url);
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST           => true,
  CURLOPT_POSTFIELDS     => http_build_query($post),
  CURLOPT_TIMEOUT        => 12,
  // No setear SSL porque es http; si fuese https, evaluar verificación
]);
$response = curl_exec($ch);
$httpcode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_err = curl_error($ch);
curl_close($ch);

$exito = ($httpcode === 200 && trim((string)$response) === 'OK');

// ---------- FALLBACK MAIL() SI FALLA LA API ----------
if (!$exito) {
  $headers  = "MIME-Version: 1.0\r\n";
  $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
  $headers .= "From: ".clean_line($nombre_envio)." <{$email_reply_default}>\r\n";
  if ($email_valido) {
    $headers .= "Reply-To: {$email_valido}\r\n";
  }
  // @ para evitar warnings si mail() no está configurado en el server
  $exito = @mail($para, clean_line($asunto), $html, $headers);
}

// ---------- RESPUESTA VISUAL + REDIRECCIÓN ----------
header('Content-Type: text/html; charset=utf-8');
$status_ok = $exito;
$destino = $status_ok ? $redireccion_exito : $redireccion_error;
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title><?php echo $status_ok ? 'Mensaje enviado' : 'No se pudo enviar'; ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="refresh" content="<?php echo (int)$tiempo_redireccion; ?>;url=<?php echo esc_html($destino); ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{background:#f5f7fb;min-height:100vh;display:flex;align-items:center;justify-content:center;margin:0}
    .card{max-width:520px;width:92%}
  </style>
</head>
<body>
  <div class="card shadow-sm p-4 text-center">
    <?php if ($status_ok): ?>
      <div class="display-6 mb-2">✅</div>
      <h1 class="h4 mb-2">Mensaje enviado correctamente</h1>
      <p class="text-muted mb-4">Gracias por contactarnos. Te responderemos en menos de 24 horas.</p>
    <?php else: ?>
      <div class="display-6 mb-2">⚠️</div>
      <h1 class="h4 mb-2">No se pudo enviar el mensaje</h1>
      <p class="text-muted mb-4">Intentá nuevamente o escribinos por WhatsApp. (Código HTTP: <?php echo (int)$httpcode; ?><?php echo $curl_err ? ', Error: '.esc_html($curl_err) : ''; ?>)</p>
    <?php endif; ?>

    <div class="d-flex align-items-center justify-content-center gap-3">
      <div class="spinner-border" role="status" aria-hidden="true"></div>
      <div class="text-muted">Redireccionando en <?php echo (int)$tiempo_redireccion; ?> segundos…</div>
    </div>
    <div class="mt-3">
      <a class="btn btn-primary btn-sm" href="<?php echo esc_html($destino); ?>">Ir ahora</a>
    </div>
  </div>
</body>
</html>