<?php
require 'conexion.php';
$gal = $conn->query("SELECT id, titulo, imagen, tipo FROM propiedades ORDER BY id DESC LIMIT 9");

// Captura de filtros
$localidad = $_GET['localidad'] ?? '';
$barrio    = $_GET['barrio']    ?? '';
$operacion = $_GET['operacion'] ?? '';
$tipo      = $_GET['tipo']      ?? '';
$ambientes = $_GET['ambientes'] ?? '';

// Traer localidades
$loc_query = $conn->query("SELECT DISTINCT localidad FROM propiedades WHERE localidad <> '' ORDER BY localidad ASC");
$localidades = $loc_query->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>NETFAN · Tu nuevo hogar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Playfair+Display:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #2563eb;
            --primary-dark: #1d4ed8;
            --primary-light: #93c5fd;
            --dark: #1e293b;
            --light: #f8fafc;
            --gray: #64748b;
            --gray-light: #e2e8f0;
            --gradient: linear-gradient(135deg, var(--primary), var(--primary-dark));
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            --radius: 12px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        body {
            font-family: 'Poppins', sans-serif;
            color: var(--dark);
            line-height: 1.6;
            overflow-x: hidden;
        }

        h1, h2, h3, h4, h5, h6 {
            font-family: 'Playfair Display', serif;
            font-weight: 700;
        }

        /* Hero Section */
        .hero {
            height: 100vh;
            min-height: 800px;
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)), url('img/hero.jpg') center/cover no-repeat fixed;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .hero-content {
            max-width: 800px;
            padding: 0 20px;
            z-index: 2;
            animation: fadeInUp 1s ease-out;
        }

        .hero-title {
            font-size: 4rem;
            line-height: 1.2;
            margin-bottom: 0;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
        }

        .hero-subtitle {
            font-size: 1.5rem;
            margin-bottom: 3rem;
            font-weight: 300;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.3);
        }

        /* Objetivo Section */
        .objetivo-section {
            padding: 100px 0;
            background-color: var(--light);
        }

        .objetivo-img {
            border-radius: var(--radius);
            box-shadow: var(--shadow-lg);
            transition: var(--transition);
            height: 100%;
            object-fit: cover;
        }

        .objetivo-img:hover {
            transform: scale(1.02);
        }

        .objetivo-content {
            padding: 0 50px;
        }

        .section-title {
            font-size: 2.5rem;
            margin-bottom: 1.5rem;
            color: var(--dark);
            position: relative;
            display: inline-block;
        }

        .section-title::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 0;
            width: 60px;
            height: 4px;
            background: var(--primary);
            border-radius: 2px;
        }

        .section-text {
            color: var(--gray);
            margin-bottom: 0;
        }

        /* Beneficios Section */
        .beneficios-section {
            padding: 100px 0;
            background-color: white;
        }

        .beneficio-card {
            background: white;
            border-radius: var(--radius);
            padding: 40px 30px;
            text-align: center;
            box-shadow: var(--shadow);
            transition: var(--transition);
            height: 100%;
            border: 1px solid var(--gray-light);
        }

        .beneficio-card:hover {
            transform: translateY(-10px);
            box-shadow: var(--shadow-lg);
            border-color: var(--primary-light);
        }

        .beneficio-icon {
            font-size: 3.5rem;
            color: var(--primary);
            margin-bottom: 1.5rem;
            transition: var(--transition);
        }

        .beneficio-card:hover .beneficio-icon {
            transform: scale(1.1);
        }

        .beneficio-title {
            font-size: 1.25rem;
            margin-bottom: 1rem;
            color: var(--dark);
        }

        .beneficio-text {
            color: var(--gray);
        }

        /* Galería Section */
        .galeria-section {
            padding: 100px 0;
            background-color: var(--light);
        }

        .filter-buttons {
            margin-bottom: 3rem;
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 10px;
        }

        .filter-btn {
            padding: 10px 25px;
            border: none;
            background: white;
            color: var(--gray);
            font-weight: 500;
            border-radius: 30px;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: var(--shadow);
        }

        .filter-btn.active, .filter-btn:hover {
            background: var(--primary);
            color: white;
        }

        .property-card {
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: var(--transition);
            margin-bottom: 30px;
            background: white;
        }

        .property-card:hover {
            transform: translateY(-10px);
            box-shadow: var(--shadow-lg);
        }

        .property-img-container {
            height: 250px;
            overflow: hidden;
            position: relative;
        }

        .property-img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: var(--transition);
        }

        .property-card:hover .property-img {
            transform: scale(1.1);
        }

        .property-type {
            position: absolute;
            top: 15px;
            right: 15px;
            background: var(--primary);
            color: white;
            padding: 5px 15px;
            border-radius: 30px;
            font-size: 0.8rem;
            font-weight: 500;
        }

        .property-body {
            padding: 20px;
        }

        .property-title {
            font-size: 1.25rem;
            margin-bottom: 0.5rem;
            color: var(--dark);
        }

        .property-link {
            display: inline-block;
            margin-top: 15px;
            color: var(--primary);
            font-weight: 500;
            text-decoration: none;
            transition: var(--transition);
        }

        .property-link:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }

        /* Botones */
        .btn-primary {
            background: var(--primary);
            border: none;
            padding: 12px 30px;
            border-radius: 30px;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: var(--transition);
            box-shadow: var(--shadow);
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-3px);
            box-shadow: var(--shadow-lg);
        }

        .btn-outline-primary {
            border: 2px solid var(--primary);
            color: var(--primary);
            padding: 12px 30px;
            border-radius: 30px;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: var(--transition);
        }

        .btn-outline-primary:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
            box-shadow: var(--shadow);
        }

        /* Animaciones */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive */
        @media (max-width: 992px) {
            .hero-title {
                font-size: 3rem;
            }
            
            .objetivo-content {
                padding: 0 20px;
                margin-top: 40px;
            }
        }

        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }
            
            .hero-subtitle {
                font-size: 1.2rem;
            }
            
            .section-title {
                font-size: 2rem;
            }
        }
    </style>

<style>
    :root {
      --primary-color: #2c3e50;
      --secondary-color: #3498db;
      --accent-color: #e74c3c;
      --light-bg: #f8f9fa;
      --dark-text: #2c3e50;
      --light-text: #7f8c8d;
    }

    .navbar {
      background-color: var(--primary-color) !important;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .navbar-brand {
      font-weight: 700;
      font-size: 1.5rem;
    }

    .search-container {
      background-color: var(--primary-color);
      color: white;
      padding: 2rem 0;
      margin-bottom: 0;
      box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    .search-container .form-label {
      color: white;
      font-weight: 500;
    }

    .btn-primary {
      background-color: var(--secondary-color);
      border-color: var(--secondary-color);
      font-weight: 500;
      transition: all 0.3s;
    }

    .btn-primary:hover {
      background-color: #2980b9;
      border-color: #2980b9;
      transform: translateY(-2px);
    }
  </style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark">
  <div class="container">
    <a class="navbar-brand" href="index.php">
      <i class="bi bi-house-door-fill"></i> Inmobiliaria
    </a>
  </div>
</nav>

<!-- Buscador -->
<div class="search-container">
  <div class="container">
    <h4 class="text-white mb-4">Encuentra tu propiedad ideal</h4>
    <form action="index.php" method="get" class="row g-3 align-items-end">
      <!-- Localidad -->
      <div class="col-md-3">
        <label class="form-label">Localidad</label>
        <select name="localidad" id="localidad" class="form-select" onchange="cargarBarrios()">
          <option value="">-- Todas --</option>
          <?php foreach ($localidades as $loc): ?>
            <option value="<?= htmlspecialchars($loc['localidad']) ?>" <?= $localidad === $loc['localidad'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($loc['localidad']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <!-- Barrio -->
      <div class="col-md-3">
        <label class="form-label">Barrio</label>
        <select name="barrio" id="barrio" class="form-select" disabled>
          <option value="">-- Todos --</option>
        </select>
      </div>

      <!-- Operación -->
      <div class="col-md-2">
        <label class="form-label">Operación</label>
        <select name="operacion" class="form-select">
          <option value="">-- Todas --</option>
          <option value="Comprar" <?= $operacion === 'Comprar' ? 'selected' : '' ?>>Comprar</option>
          <option value="Alquilar" <?= $operacion === 'Alquilar' ? 'selected' : '' ?>>Alquilar</option>
        </select>
      </div>

      <!-- Tipo -->
      <div class="col-md-2">
        <label class="form-label">Tipo</label>
        <select name="tipo" class="form-select">
          <option value="">-- Todos --</option>
          <?php
            $tipos = ['Casa', 'Departamento', 'PH', 'Lote', 'Galpón', 'Garage', 'Oficina'];
            foreach ($tipos as $t):
          ?>
          <option value="<?= $t ?>" <?= $tipo === $t ? 'selected' : '' ?>><?= $t ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <!-- Ambientes -->
      <div class="col-md-1">
        <label class="form-label">Amb.</label>
        <select name="ambientes" class="form-select">
          <option value="">--</option>
          <?php for ($i = 1; $i <= 4; $i++): ?>
            <option value="<?= $i ?>" <?= $ambientes === (string)$i ? 'selected' : '' ?>><?= $i ?></option>
          <?php endfor; ?>
        </select>
      </div>

      <!-- Botón -->
      <div class="col-md-1">
        <button type="submit" class="btn btn-primary w-100">
          <i class="bi bi-search"></i> Buscar
        </button>
      </div>
    </form>
  </div>
</div>

<script>
function cargarBarrios() {
  const locSel = document.getElementById('localidad');
  const barrioSel = document.getElementById('barrio');
  const loc = locSel.value;

  barrioSel.innerHTML = '<option value="">-- Todos --</option>';
  barrioSel.disabled = true;

  if (!loc) return;

  fetch('ajax_barrios.php?localidad=' + encodeURIComponent(loc))
    .then(r => r.json())
    .then(data => {
      if (data.length) {
        data.forEach(function(b){
          const opt = document.createElement('option');
          opt.value = b;
          opt.textContent = b;
          if (b === <?= json_encode($barrio) ?>) opt.selected = true;
          barrioSel.appendChild(opt);
        });
        barrioSel.disabled = false;
      }
    })
    .catch(console.error);
}

document.addEventListener('DOMContentLoaded', cargarBarrios);
</script>





<!-- Hero Section -->
<section class="hero" id="inicio">
    <div class="hero-content">
        <h1 class="hero-title">Encuentra la propiedad de tus sueños</h1>
        <p class="hero-subtitle">Descubre tu próximo hogar entre nuestra selección exclusiva de propiedades premium</p>
        <a href="#galeria" class="btn btn-primary btn-lg">Explorar propiedades</a>
    </div>
</section>

<!-- Objetivo Section -->
<section class="objetivo-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <img src="img/objetivo.jpg" alt="Sala de estar moderna" class="objetivo-img w-100">
            </div>
            <div class="col-lg-6">
                <div class="objetivo-content">
                    <h2 class="section-title">Nuestro objetivo: tu satisfacción</h2>
                    <p class="section-text">En NETFAN nos dedicamos a encontrar el hogar perfecto para ti, ofreciendo una amplia variedad de proyectos y propiedades cuidadosamente seleccionadas, ya sea que busques comprar o alquilar.</p>
                    <p class="section-text">Nos basamos en una comunicación clara y transparente para desarrollar estrategias personalizadas que cumplan con tus expectativas y necesidades específicas.</p>
                    <a href="propiedades.php" class="btn btn-outline-primary">Ver todos los proyectos</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Beneficios Section -->
<section class="beneficios-section">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title">Por qué elegirnos</h2>
            <p class="section-text mx-auto" style="max-width: 700px;">Ofrecemos soluciones inmobiliarias integrales diseñadas para satisfacer tus necesidades específicas</p>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4">
                <div class="beneficio-card">
                    <i class="bi bi-shop-window beneficio-icon"></i>
                    <h3 class="beneficio-title">Proyectos exclusivos</h3>
                    <p class="beneficio-text">Selección curada de propiedades ideales para tu primer hogar o como inversión inteligente.</p>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="beneficio-card">
                    <i class="bi bi-globe beneficio-icon"></i>
                    <h3 class="beneficio-title">Cobertura nacional</h3>
                    <p class="beneficio-text">Propiedades en las mejores ubicaciones del país y opciones internacionales seleccionadas.</p>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="beneficio-card">
                    <i class="bi bi-graph-up-arrow beneficio-icon"></i>
                    <h3 class="beneficio-title">Oportunidades únicas</h3>
                    <p class="beneficio-text">Acceso a oportunidades exclusivas en un amplio rango de valores y condiciones.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Galería Section -->
<section class="galeria-section" id="galeria">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title">Nuestras propiedades destacadas</h2>
            <p class="section-text mx-auto" style="max-width: 700px;">Explora nuestra selección de propiedades premium cuidadosamente seleccionadas</p>
        </div>
        
        <div class="filter-buttons">
            <button class="filter-btn active" data-cat="all">Todos</button>
            <button class="filter-btn" data-cat="Casa">Casas</button>
            <button class="filter-btn" data-cat="Departamento">Departamentos</button>
            <button class="filter-btn" data-cat="Oficina">Oficinas</button>
        </div>
        
        <div class="row">
            <?php while($g = $gal->fetch_assoc()): ?>
                <div class="col-lg-4 col-md-6 mb-4 filtro" data-cat="<?php echo $g['tipo']; ?>">
                    <div class="property-card">
                        <div class="property-img-container">
                            <img src="uploads/<?php echo htmlspecialchars($g['imagen']); ?>" alt="<?php echo htmlspecialchars($g['titulo']); ?>" class="property-img">
                            <span class="property-type"><?php echo $g['tipo']; ?></span>
                        </div>
                        <div class="property-body">
                            <h3 class="property-title"><?php echo htmlspecialchars($g['titulo']); ?></h3>
                            <a href="propiedad.php?id=<?php echo $g['id']; ?>" class="property-link">Ver detalles <i class="bi bi-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
        
        <div class="text-center mt-4">
            <a href="propiedades.php" class="btn btn-primary">Ver todas las propiedades</a>
        </div>
    </div>
</section>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Filtrado de propiedades
document.querySelectorAll('.filter-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        // Actualizar botones activos
        document.querySelectorAll('.filter-btn').forEach(b => b.classList.remove('active'));
        btn.classList.add('active');
        
        // Filtrar propiedades
        const cat = btn.dataset.cat;
        document.querySelectorAll('.filtro').forEach(el => {
            if (cat === 'all' || el.dataset.cat === cat) {
                el.style.display = 'block';
                setTimeout(() => {
                    el.style.opacity = '1';
                    el.style.transform = 'translateY(0)';
                }, 10);
            } else {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                setTimeout(() => {
                    el.style.display = 'none';
                }, 300);
            }
        });
    });
});

// Efecto hover en tarjetas
document.querySelectorAll('.property-card').forEach(card => {
    card.style.transition = 'transform 0.3s ease, box-shadow 0.3s ease';
});

// Smooth scrolling para enlaces
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function(e) {
        e.preventDefault();
        document.querySelector(this.getAttribute('href')).scrollIntoView({
            behavior: 'smooth'
        });
    });
});
</script>
</body>
</html>