<?php
// admin/api/ensure_year.php
declare(strict_types=1);
require __DIR__ . '/../auth.php';
require_login();
check_csrf();

header('Content-Type: application/json; charset=utf-8');

$year = (int)($_POST['year'] ?? 0);
if ($year < 2000 || $year > 2100){
  http_response_code(400);
  echo json_encode(['error'=>'Año inválido.'], JSON_UNESCAPED_UNICODE);
  exit;
}

$raw = is_file($CFG['resultados_json']) ? file_get_contents($CFG['resultados_json']) : '';
$data = json_decode($raw ?: '{}', true);
if (!is_array($data)) $data = [];

if (empty($data['title'])) $data['title'] = 'Resultados';
if (empty($data['years']) || !is_array($data['years'])) $data['years'] = [];

$y = (string)$year;
if (empty($data['years'][$y]) || !is_array($data['years'][$y])){
  $data['years'][$y] = [
    'title' => 'Resultados ' . $y,
    'events' => []
  ];
}

$data['updated_at'] = date('Y-m-d');

$out = json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
if (!atomic_write($CFG['resultados_json'], $out)){
  http_response_code(500);
  echo json_encode(['error'=>'No se pudo escribir resultados.json'], JSON_UNESCAPED_UNICODE);
  exit;
}

echo json_encode(['ok'=>true, 'year'=>$y], JSON_UNESCAPED_UNICODE);
