<?php
// admin/api/get_config.php
declare(strict_types=1);
require __DIR__ . '/../auth.php';
require_login();

$type = (string)($_GET['type'] ?? '');
$path = null;

if ($type === 'records') $path = $CFG['records_json'];
if ($type === 'resultados') $path = $CFG['resultados_json'];

if (!$path || !is_file($path)){
  http_response_code(404);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode(['error'=>'Archivo JSON no encontrado.'], JSON_UNESCAPED_UNICODE);
  exit;
}

header('Content-Type: application/json; charset=utf-8');
echo file_get_contents($path);
