<?php
// admin/api/scan_records.php
declare(strict_types=1);
require __DIR__ . '/../auth.php';
require_login();
check_csrf();

header('Content-Type: application/json; charset=utf-8');

$base = rtrim($CFG['img_dir'],'/') . '/records';
if (!is_dir($base)){
  http_response_code(400);
  echo json_encode(['error'=>'No existe la carpeta img/records.'], JSON_UNESCAPED_UNICODE);
  exit;
}

$groups = [];

$discDirs = glob($base . '/*', GLOB_ONLYDIR) ?: [];
sort($discDirs);

foreach ($discDirs as $discPath){
  $disc = basename($discPath);
  $items = [];
  $catDirs = glob($discPath . '/*', GLOB_ONLYDIR) ?: [];
  sort($catDirs);

  foreach ($catDirs as $catPath){
    $cat = basename($catPath);
    $pdf = $catPath . '/1.pdf';
    if (!is_file($pdf)) continue;
    $items[] = [
      'key' => $cat,
      'label' => $cat,
      'type' => 'pdf',
      'src' => 'img/records/' . $disc . '/' . $cat . '/1.pdf',
    ];
  }

  if ($items){
    $groups[] = [
      'key' => $disc,
      'label' => ucfirst($disc),
      'subtitle' => 'APUA WABDL',
      'items' => $items
    ];
  }
}

$data = [
  'title' => 'Récords APUA WABDL',
  'updated_at' => date('Y-m-d'),
  'groups' => $groups
];

$out = json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
if (!atomic_write($CFG['records_json'], $out)){
  http_response_code(500);
  echo json_encode(['error'=>'No se pudo escribir records.json'], JSON_UNESCAPED_UNICODE);
  exit;
}

echo json_encode(['ok'=>true, 'groups'=>count($groups)], JSON_UNESCAPED_UNICODE);
