<?php
// admin/api/upload_records.php
declare(strict_types=1);
require __DIR__ . '/../auth.php';
require_login();
check_csrf();

header('Content-Type: application/json; charset=utf-8');

$disc = safe_slug((string)($_POST['disc'] ?? ''));
$cat  = safe_slug((string)($_POST['cat'] ?? ''));

if (!$disc || !$cat){
  http_response_code(400);
  echo json_encode(['error'=>'Faltan disc/cat.'], JSON_UNESCAPED_UNICODE);
  exit;
}

if (empty($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK){
  http_response_code(400);
  echo json_encode(['error'=>'Archivo PDF inválido.'], JSON_UNESCAPED_UNICODE);
  exit;
}

$f = $_FILES['file'];
$ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
if ($ext !== 'pdf'){
  http_response_code(400);
  echo json_encode(['error'=>'Solo PDF.'], JSON_UNESCAPED_UNICODE);
  exit;
}

$targetDir = rtrim($CFG['img_dir'],'/') . '/records/' . $disc . '/' . $cat;
if (!is_dir($targetDir) && !@mkdir($targetDir, 0775, true)){
  http_response_code(500);
  echo json_encode(['error'=>'No se pudo crear carpeta destino.'], JSON_UNESCAPED_UNICODE);
  exit;
}

$target = $targetDir . '/1.pdf';
if (!move_uploaded_file($f['tmp_name'], $target)){
  http_response_code(500);
  echo json_encode(['error'=>'No se pudo guardar el PDF.'], JSON_UNESCAPED_UNICODE);
  exit;
}

// Actualiza JSON (agrega si no existe)
$raw = is_file($CFG['records_json']) ? file_get_contents($CFG['records_json']) : '';
$data = json_decode($raw ?: '{}', true);
if (!is_array($data)) $data = [];

$data['updated_at'] = date('Y-m-d');
if (empty($data['title'])) $data['title'] = 'Récords APUA WABDL';

$groups = $data['groups'] ?? [];
if (!is_array($groups)) $groups = [];

$srcRel = 'img/records/' . $disc . '/' . $cat . '/1.pdf';

// Busca grupo
$foundG = false;
foreach ($groups as &$g){
  if (($g['key'] ?? '') === $disc){
    $foundG = true;
    $items = $g['items'] ?? [];
    if (!is_array($items)) $items = [];
    $foundI = false;
    foreach ($items as &$it){
      if (($it['key'] ?? '') === $cat){
        $it['type'] = 'pdf';
        $it['src']  = $srcRel;
        if (empty($it['label'])) $it['label'] = $cat;
        $foundI = true;
        break;
      }
    }
    if (!$foundI){
      $items[] = ['key'=>$cat,'label'=>$cat,'type'=>'pdf','src'=>$srcRel];
    }
    $g['items'] = $items;
    if (empty($g['label'])) $g['label'] = ucfirst($disc);
    if (empty($g['subtitle'])) $g['subtitle'] = 'APUA WABDL';
    break;
  }
}
unset($g);

if (!$foundG){
  $groups[] = [
    'key'=>$disc,
    'label'=>ucfirst($disc),
    'subtitle'=>'APUA WABDL',
    'items'=>[
      ['key'=>$cat,'label'=>$cat,'type'=>'pdf','src'=>$srcRel]
    ]
  ];
}

$data['groups'] = $groups;

$out = json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
if (!atomic_write($CFG['records_json'], $out)){
  http_response_code(500);
  echo json_encode(['error'=>'No se pudo escribir records.json'], JSON_UNESCAPED_UNICODE);
  exit;
}

echo json_encode(['ok'=>true, 'src'=>$srcRel], JSON_UNESCAPED_UNICODE);
