<?php
// admin/api/upload_resultado.php
declare(strict_types=1);
require __DIR__ . '/../auth.php';
require_login();
check_csrf();

header('Content-Type: application/json; charset=utf-8');

$year  = (int)($_POST['year'] ?? 0);
$slug  = safe_slug((string)($_POST['slug'] ?? ''));
$label = trim((string)($_POST['label'] ?? ''));
$date  = trim((string)($_POST['date'] ?? ''));
$disc  = safe_slug((string)($_POST['disc'] ?? ''));

if ($year < 2000 || $year > 2100){
  http_response_code(400);
  echo json_encode(['error'=>'Año inválido.'], JSON_UNESCAPED_UNICODE);
  exit;
}
if ($slug === '' || $label === '' || $date === '' || $disc === ''){
  http_response_code(400);
  echo json_encode(['error'=>'Faltan datos (slug/label/date/disc).'], JSON_UNESCAPED_UNICODE);
  exit;
}
if (empty($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK){
  http_response_code(400);
  echo json_encode(['error'=>'Archivo PNG inválido.'], JSON_UNESCAPED_UNICODE);
  exit;
}

$f = $_FILES['file'];
$ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
if ($ext !== 'png'){
  http_response_code(400);
  echo json_encode(['error'=>'Solo PNG.'], JSON_UNESCAPED_UNICODE);
  exit;
}

$targetDir = rtrim($CFG['img_dir'],'/') . '/' . $slug . '/' . $disc;
if (!is_dir($targetDir) && !@mkdir($targetDir, 0775, true)){
  http_response_code(500);
  echo json_encode(['error'=>'No se pudo crear carpeta destino.'], JSON_UNESCAPED_UNICODE);
  exit;
}

$target = $targetDir . '/1.png';
if (!move_uploaded_file($f['tmp_name'], $target)){
  http_response_code(500);
  echo json_encode(['error'=>'No se pudo guardar el PNG.'], JSON_UNESCAPED_UNICODE);
  exit;
}

$srcRel = 'img/' . $slug . '/' . $disc . '/1.png';

// Actualiza JSON
$raw = is_file($CFG['resultados_json']) ? file_get_contents($CFG['resultados_json']) : '';
$data = json_decode($raw ?: '{}', true);
if (!is_array($data)) $data = [];
if (empty($data['title'])) $data['title'] = 'Resultados';
if (empty($data['years']) || !is_array($data['years'])) $data['years'] = [];

$y = (string)$year;
if (empty($data['years'][$y]) || !is_array($data['years'][$y])){
  $data['years'][$y] = ['title'=>'Resultados ' . $y, 'events'=>[]];
}

$events = $data['years'][$y]['events'] ?? [];
if (!is_array($events)) $events = [];

$found = false;
foreach ($events as &$ev){
  if (($ev['slug'] ?? '') === $slug){
    $found = true;
    $ev['label'] = $label;
    $ev['date']  = $date;
    if (empty($ev['disciplines']) || !is_array($ev['disciplines'])) $ev['disciplines'] = [];
    $disciplines = $ev['disciplines'];
    $foundD = false;
    foreach ($disciplines as &$d){
      if (($d['key'] ?? '') === $disc){
        $d['label'] = ucfirst($disc);
        $d['type']  = 'png';
        $d['src']   = $srcRel;
        $foundD = true;
        break;
      }
    }
    unset($d);
    if (!$foundD){
      $disciplines[] = ['key'=>$disc,'label'=>ucfirst($disc),'type'=>'png','src'=>$srcRel];
    }
    $ev['disciplines'] = $disciplines;
    break;
  }
}
unset($ev);

if (!$found){
  $events[] = [
    'slug'=>$slug,
    'label'=>$label,
    'date'=>$date,
    'disciplines'=>[
      ['key'=>$disc,'label'=>ucfirst($disc),'type'=>'png','src'=>$srcRel]
    ]
  ];
}

// Ordena por fecha (si es dd/mm/yyyy o d/m/yyyy)
usort($events, function($a,$b){
  $pa = $a['date'] ?? '';
  $pb = $b['date'] ?? '';
  $ta = strtotime(str_replace('/','-',$pa)) ?: 0;
  $tb = strtotime(str_replace('/','-',$pb)) ?: 0;
  return $ta <=> $tb;
});

$data['years'][$y]['events'] = $events;
$data['updated_at'] = date('Y-m-d');

$out = json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
if (!atomic_write($CFG['resultados_json'], $out)){
  http_response_code(500);
  echo json_encode(['error'=>'No se pudo escribir resultados.json'], JSON_UNESCAPED_UNICODE);
  exit;
}

echo json_encode(['ok'=>true, 'src'=>$srcRel], JSON_UNESCAPED_UNICODE);
