<?php
// admin/auth.php
declare(strict_types=1);
session_start();

$CFG = require __DIR__ . '/config.php';

function is_logged_in(): bool {
  return !empty($_SESSION['apl_admin']) && $_SESSION['apl_admin'] === true;
}

function require_login(): void {
  if (!is_logged_in()) {
    header('Location: login.php');
    exit;
  }
}

function csrf_token(): string {
  if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(16));
  }
  return $_SESSION['csrf'];
}

function check_csrf(): void {
  $t = $_POST['csrf'] ?? '';
  if (!$t || empty($_SESSION['csrf']) || !hash_equals($_SESSION['csrf'], $t)) {
    http_response_code(403);
    exit('CSRF inválido');
  }
}

function safe_slug(string $s): string {
  $s = strtolower(trim($s));
  $s = str_replace([' ','.'], ['-',''], $s);
  $s = preg_replace('/[^a-z0-9\-_]+/','', $s);
  return $s ?: 'item';
}

function atomic_write(string $path, string $content): bool {
  $dir = dirname($path);
  if (!is_dir($dir)) @mkdir($dir, 0775, true);
  $tmp = $path . '.tmp_' . bin2hex(random_bytes(6));
  if (file_put_contents($tmp, $content, LOCK_EX) === false) return false;
  return rename($tmp, $path);
}
