<?php
// admin/login.php
declare(strict_types=1);
require __DIR__ . '/auth.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pass = (string)($_POST['password'] ?? '');
  if ($pass !== '' && password_verify($pass, $CFG['password_hash'])) {
    $_SESSION['apl_admin'] = true;
    header('Location: panel.php');
    exit;
  }
  $error = 'Contraseña incorrecta';
}

?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login | Panel APL</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-5">
    <div class="row justify-content-center">
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm border-0 rounded-4">
          <div class="card-body p-4">
            <h1 class="h4 fw-bold mb-3">Panel APL</h1>
            <p class="text-muted mb-4">Ingresá la contraseña para administrar récords y resultados.</p>

            <?php if ($error): ?>
              <div class="alert alert-danger py-2"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <form method="post" autocomplete="off">
              <label class="form-label fw-semibold">Contraseña</label>
              <input type="password" name="password" class="form-control form-control-lg" required>
              <button class="btn btn-primary w-100 mt-3">Entrar</button>
            </form>

            <div class="small text-muted mt-3">Sitio: <a href="<?= htmlspecialchars($CFG['base_url']) ?>">ver</a></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
