<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Asociación de Powerlifting (APL) | Récords y Resultados</title>
  <meta name="description" content="Asociación de Powerlifting (APL). Consultá récords vigentes y resultados oficiales de torneos, con foco en Resultados 2025. Powerlifting, bench press, deadlift y push pull." />

  <!-- Bootstrap 5.3.3 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

  <style>
    :root{
      --sky:#4aa3df;         /* celeste */
      --sky-2:#e7f4ff;       /* celeste suave */
      --ink:#0d1b2a;         /* texto oscuro */
      --muted:#5b6b7b;
      --card:#ffffff;
      --border: rgba(13,27,42,.10);
      --radius: 18px;
      --shadow: 0 18px 40px rgba(13,27,42,.10);
    }

    html{ scroll-behavior:smooth; }
    body{
      color: var(--ink);
      background:
        radial-gradient(900px 380px at 20% -10%, rgba(74,163,223,.18), transparent 55%),
        radial-gradient(900px 380px at 85% 0%, rgba(74,163,223,.14), transparent 60%),
        linear-gradient(180deg, #ffffff 0%, #ffffff 55%, #f7fbff 100%);
    }

    /* helpers */
    .eyebrow{
      display:inline-flex;align-items:center;gap:.5rem;
      font-weight:700;letter-spacing:.08em;text-transform:uppercase;
      color: var(--sky);
      background: rgba(74,163,223,.10);
      padding:.35rem .6rem;border-radius:999px;
      font-size:.78rem;
    }
    .section{ padding: 80px 0; }
    .section-title{ font-weight: 800; letter-spacing:-.02em; }
    .section-subtitle{ color: var(--muted); max-width: 860px; margin: 0 auto; }

    .soft-card{
      background: var(--card);
      border: 1px solid var(--border);
      border-radius: var(--radius);
      box-shadow: var(--shadow);
    }
    .icon-pill{
      width:46px;height:46px;border-radius:14px;
      display:inline-flex;align-items:center;justify-content:center;
      background: rgba(74,163,223,.12);
      color: var(--sky);
      font-size: 1.2rem;
      flex: 0 0 auto;
    }

    /* navbar */
    .navbar{
      background: rgba(255,255,255,.92);
      backdrop-filter: blur(10px);
      border-bottom: 1px solid rgba(13,27,42,.08);
    }
    .brand-mark{
      width:38px;height:38px;border-radius:12px;
      background: linear-gradient(135deg, rgba(74,163,223,.95), rgba(74,163,223,.35));
      box-shadow: 0 10px 22px rgba(74,163,223,.25);
    }
    .nav-link{ color: var(--ink); font-weight: 600; }
    .nav-link:hover{ color: var(--sky); }
    .btn-sky{
      background: var(--sky);
      border-color: var(--sky);
      color: #fff;
      font-weight: 700;
      border-radius: 999px;
      padding: .65rem 1rem;
    }
    .btn-sky:hover{ filter: brightness(.96); color:#fff; }
    .btn-ghost{
      border: 1px solid rgba(13,27,42,.14);
      border-radius: 999px;
      font-weight: 700;
      padding: .65rem 1rem;
      background: #fff;
      color: var(--ink);
    }
    .btn-ghost:hover{ border-color: rgba(74,163,223,.55); color: var(--sky); }

    /* hero */
    .hero{
      padding: 110px 0 70px;
      position: relative;
    }
    .hero h1{ font-weight: 900; letter-spacing:-.03em; }
    .hero p{ color: var(--muted); }
    .hero-badges{
      display:flex;flex-wrap:wrap;gap:.5rem;margin-top: 14px;
    }
    .hero-badge{
      display:inline-flex;align-items:center;gap:.45rem;
      padding:.45rem .7rem;border-radius:999px;
      border: 1px solid rgba(13,27,42,.10);
      background: rgba(255,255,255,.85);
      color: var(--ink);
      font-weight: 600;
      font-size:.92rem;
    }
    .hero-media{
      border-radius: 24px;
      overflow:hidden;
      border: 1px solid rgba(13,27,42,.10);
      box-shadow: var(--shadow);
      background: #fff;
      min-height: 360px;
      display:flex;align-items:center;justify-content:center;
      padding: 10px;
    }
    .hero-media img{
      width: 100%;
      height: 100%;
      max-height: 520px;
      object-fit: contain;
      object-position: center;
      display:block;
    }

    /* services */
    .service-item{
      display:flex;gap:14px;
      padding: 16px;
      border-radius: 18px;
      border: 1px solid rgba(13,27,42,.10);
      background:#fff;
      height: 100%;
    }
    .service-item h3{ font-size: 1.05rem; margin: 0; font-weight: 800; }
    .service-item p{ margin: 6px 0 0; color: var(--muted); }

    /* faqs */
    .accordion-button{ font-weight: 800; }
    .accordion-button:not(.collapsed){
      color: var(--ink);
      background: rgba(74,163,223,.10);
      box-shadow:none;
    }
    .accordion-item{
      border: 1px solid rgba(13,27,42,.10) !important;
      border-radius: 16px !important;
      overflow:hidden;
      background: #fff;
    }
    .accordion .accordion-item + .accordion-item{ margin-top: 12px; }

    /* contact */
    .form-control, .form-select{
      border-radius: 14px;
      border: 1px solid rgba(13,27,42,.14);
      padding: .85rem .9rem;
    }
    .form-control:focus, .form-select:focus{
      border-color: rgba(74,163,223,.65);
      box-shadow: 0 0 0 .2rem rgba(74,163,223,.18);
    }

    /* footer */
    footer{
      padding: 44px 0;
      background: #0b2236;
      color: rgba(255,255,255,.86);
    }
    footer a{ color: rgba(255,255,255,.86); text-decoration: none; }
    footer a:hover{ color: #ffffff; }
    .footer-title{ font-weight: 900; color:#fff; }
    .footer-muted{ color: rgba(255,255,255,.68); }

    /* ===== NUEVO: bloques de botones tipo “records / resultados” ===== */
    .pick-box{
      background:#fff;
      border: 1px solid rgba(13,27,42,.12);
      border-radius: 18px;
      padding: 18px;
      height: 100%;
      box-shadow: 0 14px 34px rgba(13,27,42,.08);
    }
    .pick-title{
      font-weight: 900;
      letter-spacing: -.02em;
      margin: 0;
    }
    .pick-sub{
      margin: 0;
      color: var(--muted);
      font-weight: 600;
    }
    .pick-btn{
      width: 100%;
      border-radius: 12px;
      padding: 10px 12px;
      font-weight: 800;
      border: 1px solid rgba(13,27,42,.14);
      background: #0f172a;
      color: #fff;
    }
    .pick-btn:hover{ filter: brightness(.96); }
    .pick-btn:disabled{
      opacity:.45;
      cursor:not-allowed;
    }

    .tour-row{
      display:flex;
      flex-wrap:wrap;
      align-items:center;
      justify-content:space-between;
      gap: 12px;
      padding: 14px 16px;
      border: 1px solid rgba(13,27,42,.12);
      border-radius: 16px;
      background:#fff;
    }
    .tour-name{
      font-weight: 900;
      letter-spacing: -.02em;
      margin: 0;
      font-size: 1.05rem;
    }
    .tour-date{
      color: var(--muted);
      margin: 0;
      font-weight: 700;
    }
    .tour-actions{
      display:flex;
      flex-wrap:wrap;
      gap: 10px;
      justify-content:flex-end;
    }
    .tour-actions .pick-btn{
      width: auto;
      min-width: 150px;
      background: #111827;
    }

    /* ===== Modal visor (IMG / PDF) ===== */
    .doc-modal .modal-content{
      background:#0b0f19;
      border: 1px solid rgba(255,255,255,.12);
      border-radius: 18px;
      overflow:hidden;
    }
    .doc-modal .modal-header{
      border-bottom: 1px solid rgba(255,255,255,.12);
      background: rgba(255,255,255,.04);
    }
    .doc-modal .modal-title{
      color:#fff;
      font-weight: 900;
      letter-spacing: -.02em;
    }
    .doc-modal .modal-body{
      padding: 0;
      background:#000;
    }
    #docImg{
      width:100%;
      height:auto;
      max-height: 86vh;
      object-fit: contain;
      background:#000;
      display:none;
    }
    #docFrame{
      width:100%;
      height: 86vh;
      border:0;
      display:none;
      background:#000;
    }
    .doc-tools{
      display:flex;
      flex-wrap:wrap;
      gap: 10px;
      align-items:center;
      justify-content:space-between;
      padding: 10px 14px;
      border-top: 1px solid rgba(255,255,255,.12);
      background: rgba(255,255,255,.04);
    }
    .doc-tools a{
      color:#fff;
      text-decoration:none;
      font-weight:800;
    }
    .doc-tools a:hover{ text-decoration:underline; }

    @media (max-width: 991.98px){
      .hero{ padding: 92px 0 56px; }
      .hero-media{ min-height: 300px; }
      .tour-actions .pick-btn{ min-width: 140px; }
    }
    @media (max-width: 575.98px){
      .tour-actions .pick-btn{ width: 100%; min-width: unset; }
    }
  </style>
</head>

<body>

  <!-- NAVBAR -->
  <nav class="navbar navbar-expand-lg fixed-top">
    <div class="container">
      <a class="navbar-brand d-flex align-items-center gap-2 fw-bold" href="#inicio" aria-label="Inicio">
        <span class="brand-mark" aria-hidden="true"></span>
        <span>Asociación de Powerlifting <span class="text-muted fw-semibold">(APL)</span></span>
      </a>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navAPL" aria-controls="navAPL" aria-expanded="false" aria-label="Abrir menú">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navAPL">
        <ul class="navbar-nav ms-auto me-lg-3 mb-2 mb-lg-0 gap-lg-1">
          <li class="nav-item"><a class="nav-link" href="#inicio">Inicio</a></li>
          <li class="nav-item"><a class="nav-link" href="#records">Récords</a></li>
          <li class="nav-item"><a class="nav-link" href="#resultados2025">Resultados 2025</a></li>
          <li class="nav-item"><a class="nav-link" href="#quienes">Quiénes somos</a></li>
          <li class="nav-item"><a class="nav-link" href="#servicios">Servicios</a></li>
          <li class="nav-item"><a class="nav-link" href="#trabajos">Trabajos</a></li>
          <li class="nav-item"><a class="nav-link" href="#faqs">FAQs</a></li>
          <li class="nav-item"><a class="nav-link" href="#contacto">Contacto</a></li>
        </ul>

        <div class="d-flex gap-2">
          <a class="btn btn-ghost d-none d-lg-inline-flex align-items-center gap-2" href="https://www.instagram.com/apua.arg?igsh=MXR5OTVhem02d2loMA==" target="_blank" rel="noopener">
            <i class="bi bi-instagram"></i> Instagram
          </a>
          <a class="btn btn-sky d-inline-flex align-items-center gap-2" href="https://wa.me/5492236018815" target="_blank" rel="noopener">
            <i class="bi bi-whatsapp"></i> Escribinos
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- HERO -->
  <header id="inicio" class="hero">
    <div class="container">
      <div class="row align-items-center g-4">
        <div class="col-lg-6">
          <span class="eyebrow"><i class="bi bi-trophy-fill"></i> Asociación de Powerlifting</span>
          <h1 class="display-5 mt-3 mb-3">Récords vigentes y resultados oficiales de torneos</h1>
          <p class="lead mb-3">
            Promovemos y difundimos el Powerlifting, bench press, deadlift y push pull por todo el país.
            Consultá los <strong>récords actuales</strong> y los <strong>resultados del año 2025</strong> en un solo lugar.
          </p>

          <div class="d-flex flex-wrap gap-2 mt-3">
            <a href="#records" class="btn btn-sky d-inline-flex align-items-center gap-2">
              <i class="bi bi-award-fill"></i> Ver Récords Vigentes
            </a>
            <a href="#resultados2025" class="btn btn-ghost d-inline-flex align-items-center gap-2">
              <i class="bi bi-calendar-check"></i> Ver Resultados 2025
            </a>
          </div>

          <div class="hero-badges">
            <span class="hero-badge"><i class="bi bi-journal-check"></i> Registro de atletas, torneos y récords</span>
            <span class="hero-badge"><i class="bi bi-person-check"></i> Afiliación anual</span>
            <span class="hero-badge"><i class="bi bi-flag-fill"></i> Organización de torneos</span>
          </div>

          <div class="mt-4 small text-muted">
            Dominio: <a href="https://pcsdeportes.com.ar" target="_blank" rel="noopener" class="text-decoration-none">pcsdeportes.com.ar</a>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="hero-media">
            <img src="img/hero.jpg" alt="Asociación de Powerlifting - Competencia" loading="lazy">
          </div>
          <div class="text-center mt-2 small text-muted">Imagen ilustrativa / institucional</div>
        </div>
      </div>
    </div>
  </header>

  <!-- RECORDS (DINÁMICO: JSON + PDFs) -->
  <section id="records" class="section">
    <div class="container">
      <div class="text-center mb-5">
        <span class="eyebrow"><i class="bi bi-award"></i> Récords</span>
        <h2 class="section-title" id="recordsTitle">Récords vigentes</h2>
        <p class="section-subtitle" id="recordsSubtitle">
          Elegí disciplina y categoría. Se abre el <strong>PDF</strong>.
        </p>
        <div class="small text-muted mt-2" id="recordsUpdated" style="display:none;"></div>
      </div>

      <div id="recordsMount" class="row g-3"></div>

      <div class="text-center mt-3 small text-muted">
        Si algún PDF no abre, verificá que exista <strong>img/records/&lt;disciplina&gt;/&lt;categoría&gt;/1.pdf</strong>.
      </div>
    </div>
  </section>

  <!-- RESULTADOS (DINÁMICO: JSON + PNGs) -->
  <section id="resultados2025" class="section">
    <div class="container">
      <div class="text-center mb-4">
        <span class="eyebrow"><i class="bi bi-calendar-event"></i> Torneos</span>
        <h2 class="section-title" id="resultsTitle">Resultados</h2>
        <p class="section-subtitle" id="resultsSubtitle">
          Elegí año, torneo y disciplina. Se abre el <strong>PNG</strong>.
        </p>
      </div>

      <div class="d-flex justify-content-center mb-4" id="resultsYearWrap" style="display:none;">
        <div class="d-inline-flex align-items-center gap-2 px-3 py-2 rounded-4 border bg-white"
             style="border-color: rgba(13,27,42,.10) !important;">
          <i class="bi bi-calendar3 text-primary"></i>
          <div class="fw-bold">Año</div>
          <select id="resultsYear" class="form-select form-select-sm" style="width: 140px;">
          </select>
        </div>
      </div>

      <div class="d-grid gap-3" id="resultsMount"></div>
    </div>
  </section>

  <!-- QUIÉNES SOMOS -->
  <section id="quienes" class="section">
    <div class="container">
      <div class="text-center mb-5">
        <span class="eyebrow"><i class="bi bi-people-fill"></i> Institucional</span>
        <h2 class="section-title">Quiénes somos</h2>
        <p class="section-subtitle">
          Somos una asociación dedicada a promover, difundir y organizar disciplinas de fuerza:
          Powerlifting, bench press, deadlift y push pull.
        </p>
      </div>

      <div class="row g-3">
        <div class="col-lg-6">
          <div class="soft-card p-4 h-100">
            <div class="d-flex align-items-start gap-3">
              <span class="icon-pill"><i class="bi bi-bullseye"></i></span>
              <div>
                <h3 class="h5 fw-bold mb-1">Propósito</h3>
                <ul class="mb-0 text-muted">
                  <li>Promover y difundir el Powerlifting, bench press, deadlift &amp; push pull por todo el país.</li>
                  <li>Fomentar la amistad y colaboración entre socios mediante la práctica de este deporte.</li>
                  <li>Organizar torneos o campeonatos nacionales e internacionales.</li>
                  <li>Llevar un registro de atletas, torneos y récords.</li>
                  <li>Efectuar la afiliación de atletas de forma anual.</li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="soft-card p-4 h-100">
            <div class="d-flex align-items-start gap-3">
              <span class="icon-pill"><i class="bi bi-diagram-3-fill"></i></span>
              <div>
                <h3 class="h5 fw-bold mb-3">Comisión directiva</h3>
                <div class="row g-2 small">
                  <div class="col-sm-6">
                    <div class="p-3 rounded-4 border" style="border-color: rgba(13,27,42,.10) !important;">
                      <div class="fw-bold">Presidente</div>
                      <div class="text-muted">De Simone Serafín</div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="p-3 rounded-4 border" style="border-color: rgba(13,27,42,.10) !important;">
                      <div class="fw-bold">Vicepresidente</div>
                      <div class="text-muted">De Simone Bureaux Ezequiel</div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="p-3 rounded-4 border" style="border-color: rgba(13,27,42,.10) !important;">
                      <div class="fw-bold">Tesorera</div>
                      <div class="text-muted">Vallinoto Diana</div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="p-3 rounded-4 border" style="border-color: rgba(13,27,42,.10) !important;">
                      <div class="fw-bold">Pro tesorera</div>
                      <div class="text-muted">Bureaux Karina</div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="p-3 rounded-4 border" style="border-color: rgba(13,27,42,.10) !important;">
                      <div class="fw-bold">Secretaria</div>
                      <div class="text-muted">Ballesteros Natalia</div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="p-3 rounded-4 border" style="border-color: rgba(13,27,42,.10) !important;">
                      <div class="fw-bold">Veedor de torneos</div>
                      <div class="text-muted">Chávez Victor Hugo</div>
                    </div>
                  </div>
                  <div class="col-12">
                    <div class="p-3 rounded-4 border" style="border-color: rgba(13,27,42,.10) !important;">
                      <div class="fw-bold mb-1">Referentes zonales</div>
                      <div class="text-muted">Wagner Marcelo · Villalba Vanina · Alvarez Miguel</div>
                    </div>
                  </div>
                </div>

                <div class="mt-3 small text-muted">
                  APL – Levantamiento de pesas
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- SERVICIOS -->
  <section id="servicios" class="section">
    <div class="container">
      <div class="text-center mb-5">
        <span class="eyebrow"><i class="bi bi-list-check"></i> Servicios</span>
        <h2 class="section-title">Lo que hacemos</h2>
        <p class="section-subtitle">
          Gestión deportiva, organización y publicación de información oficial.
        </p>
      </div>

      <div class="row g-3">
        <div class="col-md-6 col-lg-4">
          <div class="service-item">
            <span class="icon-pill"><i class="bi bi-person-vcard"></i></span>
            <div>
              <h3>Registro de atletas</h3>
              <p>Alta y administración del registro anual.</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4">
          <div class="service-item">
            <span class="icon-pill"><i class="bi bi-person-check"></i></span>
            <div>
              <h3>Afiliación anual</h3>
              <p>Gestión de afiliaciones de atletas de forma anual.</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4">
          <div class="service-item">
            <span class="icon-pill"><i class="bi bi-flag"></i></span>
            <div>
              <h3>Organización de torneos</h3>
              <p>Coordinación de torneos y campeonatos nacionales e internacionales.</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-6">
          <div class="service-item">
            <span class="icon-pill"><i class="bi bi-award"></i></span>
            <div>
              <h3>Publicación de récords vigentes</h3>
              <p>Consulta pública de récords actualizados por categoría (según tu estructura oficial).</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-6">
          <div class="service-item">
            <span class="icon-pill"><i class="bi bi-clipboard-data"></i></span>
            <div>
              <h3>Resultados oficiales</h3>
              <p>Publicación y consulta de resultados, con foco en los Resultados 2025.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- POR QUÉ ELEGIRNOS -->
  <section id="porque" class="section">
    <div class="container">
      <div class="text-center mb-5">
        <span class="eyebrow"><i class="bi bi-shield-check"></i> Por qué APL</span>
        <h2 class="section-title">Por qué elegirnos</h2>
        <p class="section-subtitle">
          Centralizamos información y fortalecemos la comunidad del powerlifting en todo el país.
        </p>
      </div>

      <div class="row g-3">
        <div class="col-md-6 col-lg-4">
          <div class="soft-card p-4 h-100">
            <div class="d-flex gap-3">
              <span class="icon-pill"><i class="bi bi-eye"></i></span>
              <div>
                <h3 class="h5 fw-bold mb-1">Transparencia y orden</h3>
                <p class="mb-0 text-muted">Información clara, accesible y centralizada.</p>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4">
          <div class="soft-card p-4 h-100">
            <div class="d-flex gap-3">
              <span class="icon-pill"><i class="bi bi-journal-check"></i></span>
              <div>
                <h3 class="h5 fw-bold mb-1">Registro oficial</h3>
                <p class="mb-0 text-muted">Atletas, torneos y récords reunidos en un mismo sistema.</p>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4">
          <div class="soft-card p-4 h-100">
            <div class="d-flex gap-3">
              <span class="icon-pill"><i class="bi bi-geo-alt"></i></span>
              <div>
                <h3 class="h5 fw-bold mb-1">Enfoque federal</h3>
                <p class="mb-0 text-muted">Promoción del deporte por todo el país.</p>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4">
          <div class="soft-card p-4 h-100">
            <div class="d-flex gap-3">
              <span class="icon-pill"><i class="bi bi-people"></i></span>
              <div>
                <h3 class="h5 fw-bold mb-1">Comunidad y valores</h3>
                <p class="mb-0 text-muted">Fomentamos amistad y colaboración entre socios.</p>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4">
          <div class="soft-card p-4 h-100">
            <div class="d-flex gap-3">
              <span class="icon-pill"><i class="bi bi-arrow-repeat"></i></span>
              <div>
                <h3 class="h5 fw-bold mb-1">Actualización permanente</h3>
                <p class="mb-0 text-muted">Prioridad en récords vigentes y Resultados 2025.</p>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4">
          <div class="soft-card p-4 h-100">
            <div class="d-flex gap-3">
              <span class="icon-pill"><i class="bi bi-trophy"></i></span>
              <div>
                <h3 class="h5 fw-bold mb-1">Gestión de torneos</h3>
                <p class="mb-0 text-muted">Organización y veeduría para sostener estándares deportivos.</p>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </section>

  <!-- ===== GALERÍA REUTILIZABLE (TU SECCIÓN) ===== -->
  <section class="section gal-gallery" id="trabajos">
    <div class="container">
      <div class="text-center mb-5">
        <span class="eyebrow">Trabajos</span>
        <h2 class="section-title">Galería</h2>
        <p class="section-subtitle">Momentos de torneos, podios y jornadas de Powerlifting</p>
      </div>

      <div id="galTicker-1" class="carousel slide gal-carousel" data-bs-ride="carousel" data-bs-interval="4000">
        <div class="carousel-indicators"></div>

        <div class="carousel-inner">
          <div class="carousel-item active">
            <div class="gal-frame">
              <img src="img/1.jpeg" class="gal-img" alt="Galería 1" loading="lazy">
            </div>
          </div>
          <div class="carousel-item"><div class="gal-frame"><img src="img/2.jpeg" class="gal-img" alt="Galería 2" loading="lazy"></div></div>
          <div class="carousel-item"><div class="gal-frame"><img src="img/3.jpeg" class="gal-img" alt="Galería 3" loading="lazy"></div></div>
          <div class="carousel-item"><div class="gal-frame"><img src="img/4.jpeg" class="gal-img" alt="Galería 4" loading="lazy"></div></div>
          <div class="carousel-item"><div class="gal-frame"><img src="img/5.jpeg" class="gal-img" alt="Galería 5" loading="lazy"></div></div>
          <div class="carousel-item"><div class="gal-frame"><img src="img/6.jpeg" class="gal-img" alt="Galería 6" loading="lazy"></div></div>
          <div class="carousel-item"><div class="gal-frame"><img src="img/7.jpeg" class="gal-img" alt="Galería 7" loading="lazy"></div></div>
          <div class="carousel-item"><div class="gal-frame"><img src="img/8.jpeg" class="gal-img" alt="Galería 8" loading="lazy"></div></div>
          <div class="carousel-item"><div class="gal-frame"><img src="img/9.jpeg" class="gal-img" alt="Galería 9" loading="lazy"></div></div>
        </div>

        <button class="carousel-control-prev" type="button" data-bs-target="#galTicker-1" data-bs-slide="prev">
          <span class="carousel-control-prev-icon gal-ctrl-icon" aria-hidden="true"></span>
          <span class="visually-hidden">Anterior</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#galTicker-1" data-bs-slide="next">
          <span class="carousel-control-next-icon gal-ctrl-icon" aria-hidden="true"></span>
          <span class="visually-hidden">Siguiente</span>
        </button>
      </div>

      <div class="text-center mt-3 small text-muted">
        Tocá una imagen para verla en grande y navegar la galería.
      </div>
    </div>
  </section>

  <!-- ===== Modal Lightbox (galería) ===== -->
  <div class="modal fade" id="galLightbox" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
      <div class="modal-content bg-black">
        <div class="modal-body p-0 position-relative">
          <button type="button" class="btn-close btn-close-white position-absolute top-0 end-0 m-3" data-bs-dismiss="modal" aria-label="Cerrar"></button>
          <button type="button" class="gal-lightbox-nav gal-prev" aria-label="Anterior">&lsaquo;</button>
          <img id="galLightboxImg" src="" alt="" class="w-100 d-block">
          <button type="button" class="gal-lightbox-nav gal-next" aria-label="Siguiente">&rsaquo;</button>
        </div>
      </div>
    </div>
  </div>

  <!-- ===== Estilos (scope gal-*) ===== -->
  <style>
  .gal-gallery .carousel{max-width:980px;margin-inline:auto;position:relative}
  .gal-frame{
    height: clamp(220px, 48vh, 440px);
    background:#fff;border-radius:16px;overflow:hidden;
    box-shadow:0 12px 28px rgba(0,0,0,.12);
    display:flex;align-items:center;justify-content:center;padding:8px
  }
  .gal-img{
    width:auto !important;max-width:100%;
    height:auto !important;max-height:100%;
    object-fit:contain !important;object-position:center;display:block;cursor:zoom-in
  }
  .gal-gallery .carousel-control-prev,
  .gal-gallery .carousel-control-next{
    z-index:20;width:50px;height:50px;top:50%;transform:translateY(-50%);
    opacity:1;background:rgba(0,0,0,.55);border-radius:50%;margin:0 12px
  }
  .gal-gallery .carousel-control-prev{left:0}
  .gal-gallery .carousel-control-next{right:0}
  .gal-gallery .gal-ctrl-icon{width:2.6rem;height:2.6rem;background-size:60% 60%}
  .gal-gallery .carousel-indicators{z-index:10;bottom:-50px}
  .gal-gallery .carousel-indicators button{
    width:10px;height:10px;border-radius:50%;
    background:rgba(0,0,0,.5);border:none
  }
  .gal-gallery .carousel-indicators button.active{background:#000}
  .gal-gallery{padding-bottom:56px}
  #galLightbox .modal-content{background:#000}
  #galLightboxImg{max-height:86vh;width:100%;height:auto;object-fit:contain;background:#000}
  .gal-lightbox-nav{
    position:absolute;top:50%;transform:translateY(-50%);
    border:0;width:44px;height:44px;border-radius:999px;
    background:rgba(255,255,255,.18);color:#fff;font-size:30px;line-height:44px;text-align:center;z-index:5;cursor:pointer
  }
  .gal-lightbox-nav:hover{background:rgba(255,255,255,.28)}
  .gal-lightbox-nav.gal-prev{left:10px}
  .gal-lightbox-nav.gal-next{right:10px}
  @media (max-width: 575.98px){
    .gal-frame{height: clamp(200px, 40vh, 360px)}
  }
  </style>

  <!-- FAQs -->
  <section id="faqs" class="section">
    <div class="container">
      <div class="text-center mb-5">
        <span class="eyebrow"><i class="bi bi-patch-question-fill"></i> Ayuda</span>
        <h2 class="section-title">Preguntas frecuentes</h2>
        <p class="section-subtitle">
          Respuestas rápidas sobre disciplinas, récords, resultados y contacto.
        </p>
      </div>

      <div class="row justify-content-center">
        <div class="col-lg-9">
          <div class="accordion" id="faqAccordion">

            <div class="accordion-item">
              <h2 class="accordion-header" id="faq1">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq1c" aria-expanded="false" aria-controls="faq1c">
                  ¿Qué disciplinas abarca la asociación?
                </button>
              </h2>
              <div id="faq1c" class="accordion-collapse collapse" aria-labelledby="faq1" data-bs-parent="#faqAccordion">
                <div class="accordion-body text-muted">
                  Powerlifting, bench press, deadlift y push pull.
                </div>
              </div>
            </div>

            <div class="accordion-item">
              <h2 class="accordion-header" id="faq2">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2c" aria-expanded="false" aria-controls="faq2c">
                  ¿Dónde puedo ver los récords vigentes?
                </button>
              </h2>
              <div id="faq2c" class="accordion-collapse collapse" aria-labelledby="faq2" data-bs-parent="#faqAccordion">
                <div class="accordion-body text-muted">
                  En la sección <strong>Récords</strong>.
                </div>
              </div>
            </div>

            <div class="accordion-item">
              <h2 class="accordion-header" id="faq3">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3c" aria-expanded="false" aria-controls="faq3c">
                  ¿Dónde están los resultados del año 2025?
                </button>
              </h2>
              <div id="faq3c" class="accordion-collapse collapse" aria-labelledby="faq3" data-bs-parent="#faqAccordion">
                <div class="accordion-body text-muted">
                  En la sección <strong>Resultados 2025</strong>.
                </div>
              </div>
            </div>

            <div class="accordion-item">
              <h2 class="accordion-header" id="faq4">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4c" aria-expanded="false" aria-controls="faq4c">
                  ¿Cómo me afilio como atleta?
                </button>
              </h2>
              <div id="faq4c" class="accordion-collapse collapse" aria-labelledby="faq4" data-bs-parent="#faqAccordion">
                <div class="accordion-body text-muted">
                  Escribinos por WhatsApp o completá el formulario en <strong>Contacto</strong> seleccionando “Afiliación anual”.
                </div>
              </div>
            </div>

            <div class="accordion-item">
              <h2 class="accordion-header" id="faq5">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq5c" aria-expanded="false" aria-controls="faq5c">
                  ¿Cómo puedo hacer una consulta?
                </button>
              </h2>
              <div id="faq5c" class="accordion-collapse collapse" aria-labelledby="faq5" data-bs-parent="#faqAccordion">
                <div class="accordion-body text-muted">
                  Podés escribirnos desde el formulario o por WhatsApp al <strong>+54 9 2236 01-8815</strong>.
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>

    </div>
  </section>

  <!-- CONTACTO -->
  <section id="contacto" class="section">
    <div class="container">
      <div class="text-center mb-5">
        <span class="eyebrow"><i class="bi bi-envelope-fill"></i> Contacto</span>
        <h2 class="section-title">Escribinos</h2>
        <p class="section-subtitle">
          ¿Afiliación, registro, torneos, récords o resultados 2025? Mandanos tu consulta.
        </p>
      </div>

      <div class="row g-3">
        <div class="col-lg-7">
          <div class="soft-card p-4">
            <form action="enviar.php" method="POST" autocomplete="on">
              <input type="text" name="website" style="display:none" tabindex="-1" aria-hidden="true">

              <div class="row g-3">
                <div class="col-md-6">
                  <label class="form-label fw-bold" for="nombre">Nombre y apellido</label>
                  <input class="form-control" id="nombre" name="nombre" type="text" required>
                </div>
                <div class="col-md-6">
                  <label class="form-label fw-bold" for="email">Email</label>
                  <input class="form-control" id="email" name="email" type="email" required>
                </div>

                <div class="col-md-6">
                  <label class="form-label fw-bold" for="telefono">Teléfono / WhatsApp</label>
                  <input class="form-control" id="telefono" name="telefono" type="text" required>
                </div>
                <div class="col-md-6">
                  <label class="form-label fw-bold" for="servicio">Motivo</label>
                  <select class="form-select" id="servicio" name="servicio" required>
                    <option value="" selected disabled>Seleccioná una opción</option>
                    <option>Afiliación anual</option>
                    <option>Registro de atleta</option>
                    <option>Torneos</option>
                    <option>Récords vigentes</option>
                    <option>Resultados 2025</option>
                    <option>Otra consulta</option>
                  </select>
                </div>

                <div class="col-12">
                  <label class="form-label fw-bold" for="mensaje">Mensaje</label>
                  <textarea class="form-control" id="mensaje" name="mensaje" rows="5" required></textarea>
                </div>

                <div class="col-12 d-flex flex-wrap gap-2 align-items-center">
                  <button class="btn btn-sky d-inline-flex align-items-center gap-2" type="submit">
                    <i class="bi bi-send-fill"></i> Enviar consulta
                  </button>
                  <a class="btn btn-ghost d-inline-flex align-items-center gap-2" href="https://wa.me/5492236018815" target="_blank" rel="noopener">
                    <i class="bi bi-whatsapp"></i> WhatsApp
                  </a>
                  <span class="small text-muted">También respondemos por WhatsApp: <strong>+54 9 2236 01-8815</strong></span>
                </div>
              </div>
            </form>
          </div>
        </div>

        <div class="col-lg-5">
          <div class="soft-card p-4 h-100">
            <h3 class="h5 fw-bold mb-3">Información</h3>

            <div class="d-flex gap-3 mb-3">
              <span class="icon-pill"><i class="bi bi-whatsapp"></i></span>
              <div>
                <div class="fw-bold">WhatsApp</div>
                <a class="text-decoration-none" href="https://wa.me/5492236018815" target="_blank" rel="noopener">+54 9 2236 01-8815</a>
              </div>
            </div>

            <div class="d-flex gap-3 mb-3">
              <span class="icon-pill"><i class="bi bi-instagram"></i></span>
              <div>
                <div class="fw-bold">Instagram</div>
                <a class="text-decoration-none" href="https://www.instagram.com/apua.arg?igsh=MXR5OTVhem02d2loMA==" target="_blank" rel="noopener">@apua.arg</a>
              </div>
            </div>

            <div class="d-flex gap-3 mb-1">
              <span class="icon-pill"><i class="bi bi-globe2"></i></span>
              <div>
                <div class="fw-bold">Sitio</div>
                <a class="text-decoration-none" href="https://pcsdeportes.com.ar" target="_blank" rel="noopener">pcsdeportes.com.ar</a>
              </div>
            </div>

            <hr class="my-4">

            <div class="small text-muted">
              APL – Levantamiento de pesas
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- FOOTER -->
  <footer>
    <div class="container">
      <div class="row g-4">
        <div class="col-lg-5">
          <div class="d-flex align-items-center gap-2 mb-2">
            <span class="brand-mark" aria-hidden="true"></span>
            <div class="footer-title">Asociación de Powerlifting (APL)</div>
          </div>
          <div class="footer-muted">
            Promovemos y difundimos el Powerlifting, bench press, deadlift y push pull en Argentina.
          </div>
        </div>

        <div class="col-6 col-lg-3">
          <div class="footer-title mb-2">Secciones</div>
          <div class="d-grid gap-1">
            <a href="#records">Récords</a>
            <a href="#resultados2025">Resultados 2025</a>
            <a href="#quienes">Quiénes somos</a>
            <a href="#contacto">Contacto</a>
          </div>
        </div>

        <div class="col-6 col-lg-4">
          <div class="footer-title mb-2">Contacto</div>
          <div class="d-grid gap-1">
            <a href="https://wa.me/5492236018815" target="_blank" rel="noopener"><i class="bi bi-whatsapp"></i> +54 9 2236 01-8815</a>
            <a href="https://www.instagram.com/apua.arg?igsh=MXR5OTVhem02d2loMA==" target="_blank" rel="noopener"><i class="bi bi-instagram"></i> @apua.arg</a>
            <a href="https://pcsdeportes.com.ar" target="_blank" rel="noopener"><i class="bi bi-globe2"></i> pcsdeportes.com.ar</a>
          </div>
        </div>
      </div>

      <hr class="my-4" style="border-color: rgba(255,255,255,.18);">

      <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-2">
        <div class="footer-muted">© Asociación de Powerlifting – APL. Todos los derechos reservados.</div>
        <div class="footer-muted small">Diseño celeste y blanco · estética institucional</div>
      </div>
    </div>
  </footer>

  <!-- ===== MODAL VISOR (IMG / PDF) ===== -->
  <div class="modal fade doc-modal" id="docModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="docTitle">Documento</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>

        <div class="modal-body">
          <img id="docImg" alt="">
          <iframe id="docFrame" title="PDF"></iframe>
        </div>

        <div class="doc-tools">
          <div class="text-white-50 small" id="docHint">Abrir en visor</div>
          <a id="docOpenNew" href="#" target="_blank" rel="noopener">Abrir en pestaña nueva</a>
        </div>
      </div>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" defer></script>

  <!-- ===== JS: Galería + Visor IMG/PDF ===== -->
  <script>
  document.addEventListener('DOMContentLoaded', function(){
    // ====== Galería (tu init original) ======
    if (window.bootstrap && bootstrap.Modal){
      // 1) Autogenerar indicadores por cada carrusel
      document.querySelectorAll('.gal-carousel').forEach(function(carousel){
        const id = carousel.id || ('galTicker-' + Math.random().toString(36).slice(2));
        carousel.id = id;

        const items = Array.from(carousel.querySelectorAll('.carousel-item'));
        const indicators = carousel.querySelector('.carousel-indicators') || (function(){
          const el = document.createElement('div'); el.className = 'carousel-indicators';
          carousel.prepend(el); return el;
        })();

        indicators.innerHTML = '';
        items.forEach(function(_, idx){
          const btn = document.createElement('button');
          btn.type = 'button';
          btn.setAttribute('data-bs-target', '#' + id);
          btn.setAttribute('data-bs-slide-to', String(idx));
          btn.setAttribute('aria-label', 'Slide ' + (idx + 1));
          if (idx === 0){ btn.className = 'active'; btn.setAttribute('aria-current','true'); }
          indicators.appendChild(btn);
        });
      });

      const lightboxEl  = document.getElementById('galLightbox');
      const lightboxImg = document.getElementById('galLightboxImg');
      const modalGal = new bootstrap.Modal(lightboxEl, { backdrop: true, focus: true });

      let currentSlides = [];
      let currentIndex  = 0;

      function showCurrent(){
        const it = currentSlides[currentIndex];
        if (!it) return;
        lightboxImg.src = it.src;
        lightboxImg.alt = it.alt || '';
      }
      function prev(){ currentIndex = (currentIndex - 1 + currentSlides.length) % currentSlides.length; showCurrent(); }
      function next(){ currentIndex = (currentIndex + 1) % currentSlides.length; showCurrent(); }

      lightboxEl.querySelector('.gal-prev').addEventListener('click', prev);
      lightboxEl.querySelector('.gal-next').addEventListener('click', next);

      function keyHandler(e){
        if (e.key === 'ArrowLeft')  prev();
        if (e.key === 'ArrowRight') next();
        if (e.key === 'Escape')     modalGal.hide();
      }
      lightboxEl.addEventListener('shown.bs.modal', () => document.addEventListener('keydown', keyHandler));
      lightboxEl.addEventListener('hidden.bs.modal',()=> document.removeEventListener('keydown', keyHandler));

      document.body.addEventListener('click', function(e){
        const img = e.target.closest('img.gal-img');
        if (!img) return;

        const carousel = img.closest('.gal-carousel');
        const imgs = Array.from(carousel.querySelectorAll('img.gal-img'));
        currentSlides = imgs.map(n => ({ src: n.getAttribute('src'), alt: n.getAttribute('alt') || '' }));
        currentIndex  = Math.max(0, imgs.indexOf(img));
        showCurrent();
        modalGal.show();
      });
    }

    
    // ====== DATA dinámico (records/resultados) ======
    const DEFAULT_RECORDS = {
      "updated_at": "2025-10-11",
      "title": "Récords APUA WABDL",
      "groups": [
        { "key":"benchpress", "label":"Benchpress", "subtitle":"APUA WABDL",
          "items":[
            {"key":"benchpressraw","label":"Benchpress Raw"},
            {"key":"benchpressequipado","label":"Benchpress Equipado"},
            {"key":"benchpressffaa","label":"Benchpress FFAA"}
          ]},
        { "key":"deadlift", "label":"Deadlift", "subtitle":"APUA WABDL",
          "items":[
            {"key":"deadliftraw","label":"Deadlift Raw"},
            {"key":"deadliftequipado","label":"Deadlift Equipado"},
            {"key":"deadliftffaa","label":"Deadlift FFAA"},
            {"key":"deadliftffaaequipado","label":"Deadlift FFAA Equipado"}
          ]},
        { "key":"pushpull", "label":"Push Pull", "subtitle":"APUA WABDL",
          "items":[
            {"key":"pushpullraw","label":"Push Pull Raw"},
            {"key":"pushpullequipado","label":"Push Pull Equipado"},
            {"key":"pushpullffaa","label":"Push Pull FFAA"},
            {"key":"pushpullffaaequipado","label":"Push Pull FFAA Equipado"}
          ]}
      ]
    };

    const DEFAULT_RESULTADOS = {
      "title": "Resultados",
      "years": {
        "2025": {
          "title": "Resultados 2025",
          "events": [
            {"slug":"miramar","label":"Miramar","date":"19/4/2025","disciplines":["benchpress","deadlift","pushpull"]},
            {"slug":"pigue","label":"Pigué","date":"17/5/2025","disciplines":["benchpress","pushpull"]},
            {"slug":"laplata","label":"La Plata","date":"14/6/2025","disciplines":["benchpress","deadlift","pushpull"]},
            {"slug":"mike","label":"Mike's Gym","date":"9/8/2025","disciplines":["benchpress","deadlift","pushpull"]},
            {"slug":"campeonatoarg","label":"Campeonato Argentino","date":"11/10/2025","disciplines":["benchpress","deadlift","pushpull"]}
          ]
        }
      }
    };

    const DISC_LABEL = {
      "benchpress": "Benchpress",
      "deadlift": "Deadlift",
      "pushpull": "Push Pull",
      "pushpool": "Push Pull" // por si te quedó mal escrito en algún lado
    };

    async function safeFetchJson(url, fallback){
      try{
        const r = await fetch(url + (url.includes('?') ? '&' : '?') + 'ts=' + Date.now(), {cache:'no-store'});
        if(!r.ok) throw new Error('HTTP ' + r.status);
        const data = await r.json();
        return data && typeof data === 'object' ? data : fallback;
      }catch(err){
        console.warn('[APL] No se pudo cargar ' + url + ' → uso fallback.', err);
        return fallback;
      }
    }

    function normalizeKey(k){
      return (k || '').toString().trim().toLowerCase();
    }

    function renderRecords(data){
      const mount = document.getElementById('recordsMount');
      if(!mount) return;

      const titleEl = document.getElementById('recordsTitle');
      const updEl   = document.getElementById('recordsUpdated');

      if(titleEl && data.title) titleEl.textContent = data.title;
      if(updEl && data.updated_at){
        updEl.style.display = '';
        updEl.textContent = 'Actualización ' + data.updated_at;
      }

      const groups = Array.isArray(data.groups) ? data.groups : [];
      mount.innerHTML = '';

      groups.forEach(g => {
        const gKey = normalizeKey(g.key);
        const gLabel = g.label || g.key || 'Disciplina';
        const gSub = g.subtitle || '';

        const col = document.createElement('div');
        col.className = 'col-lg-4';

        const card = document.createElement('div');
        card.className = 'pick-box';

        card.innerHTML = `
          <div class="d-flex align-items-center gap-2 mb-2">
            <span class="icon-pill"><i class="bi bi-lightning-charge"></i></span>
            <div>
              <p class="pick-title">${escapeHtml(gLabel)}</p>
              <p class="pick-sub">${escapeHtml(gSub)}</p>
            </div>
          </div>
          <div class="d-grid gap-2 mt-3"></div>
        `;

        const btnWrap = card.querySelector('.d-grid');
        const items = Array.isArray(g.items) ? g.items : [];
        items.forEach(it => {
          const itKey = normalizeKey(it.key);
          const itLabel = it.label || it.key || 'Categoría';
          // SIEMPRE construimos la ruta (aunque en JSON no venga)
          const src = `img/records/${gKey}/${itKey}/1.pdf`;

          const btn = document.createElement('button');
          btn.type = 'button';
          btn.className = 'pick-btn js-open-doc';
          btn.setAttribute('data-type','pdf');
          btn.setAttribute('data-title', `${gLabel} - ${itLabel}`);
          btn.setAttribute('data-src', src);
          btn.textContent = itLabel;
          btnWrap.appendChild(btn);
        });

        col.appendChild(card);
        mount.appendChild(col);
      });
    }

    function renderResults(data){
      const yearsObj = (data && data.years && typeof data.years === 'object') ? data.years : {};
      const years = Object.keys(yearsObj).sort((a,b)=> (parseInt(b,10)||0) - (parseInt(a,10)||0));

      const titleEl = document.getElementById('resultsTitle');
      if(titleEl){
        // si hay un año seleccionado, ponemos "Resultados 2025" etc
        titleEl.textContent = (years.length ? (yearsObj[years[0]]?.title || 'Resultados ' + years[0]) : (data.title || 'Resultados'));
      }

      const yearWrap = document.getElementById('resultsYearWrap');
      const yearSel  = document.getElementById('resultsYear');
      const mount    = document.getElementById('resultsMount');
      if(!yearSel || !mount) return;

      yearSel.innerHTML = '';
      years.forEach(y=>{
        const opt=document.createElement('option');
        opt.value=y; opt.textContent=y;
        yearSel.appendChild(opt);
      });

      const saved = '';
      const defaultYear = years[0] || '2025';
      yearSel.value = years.includes(saved) ? saved : defaultYear;
      if(yearWrap) yearWrap.style.display = years.length > 1 ? '' : 'none';

      function paint(){
        const y = yearSel.value || defaultYear;
        const yearData = yearsObj[y] || { title: 'Resultados ' + y, events: [] };

        if(titleEl) titleEl.textContent = yearData.title || ('Resultados ' + y);

        const events = Array.isArray(yearData.events) ? yearData.events : [];
        mount.innerHTML = '';

        if(!events.length){
          mount.innerHTML = `<div class="text-center text-muted">No hay eventos cargados para ${escapeHtml(y)}.</div>`;
          return;
        }

        events.forEach(ev=>{
          const slug = normalizeKey(ev.slug);
          const label = ev.label || ev.slug || 'Torneo';
          const date = ev.date || '';
          const disciplines = Array.isArray(ev.disciplines) ? ev.disciplines : [];

          const row = document.createElement('div');
          row.className = 'tour-row';

          const left = document.createElement('div');
          left.innerHTML = `
            <p class="tour-name">${escapeHtml(label)} <span class="text-muted fw-semibold">${date ? '('+escapeHtml(date)+')' : ''}</span></p>
            <p class="tour-date">APUA WABDL</p>
          `;

          const actions = document.createElement('div');
          actions.className = 'tour-actions';

          disciplines.forEach(d=>{
            const dKey = normalizeKey(d);
            const src = `img/${slug}/${dKey}/1.png`;

            const btn = document.createElement('button');
            btn.type = 'button';
            btn.className = 'pick-btn js-open-doc';
            btn.setAttribute('data-type','img');
            btn.setAttribute('data-title', `${label} - ${DISC_LABEL[dKey] || dKey}`);
            btn.setAttribute('data-src', src);
            btn.textContent = DISC_LABEL[dKey] || dKey;
            actions.appendChild(btn);
          });

          row.appendChild(left);
          row.appendChild(actions);
          mount.appendChild(row);
        });
      }

      yearSel.addEventListener('change', paint);
      paint();
    }

    // helper para evitar HTML roto
    function escapeHtml(str){
      return String(str ?? '').replace(/[&<>"']/g, s => ({
        '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'
      }[s]));
    }

    // cargar datos y renderizar
    (async function(){
      const rec = await safeFetchJson('data/records.json', DEFAULT_RECORDS);
      renderRecords(rec);

      const res = await safeFetchJson('data/resultados.json', DEFAULT_RESULTADOS);
      renderResults(res);
    })();


    // ====== Visor único IMG/PDF (records + resultados) ======
    if (!(window.bootstrap && bootstrap.Modal)) return;

    const docModalEl = document.getElementById('docModal');
    const docModal   = new bootstrap.Modal(docModalEl, { backdrop: true, focus: true });

    const docTitle = document.getElementById('docTitle');
    const docImg   = document.getElementById('docImg');
    const docFrame = document.getElementById('docFrame');
    const docOpen  = document.getElementById('docOpenNew');
    const docHint  = document.getElementById('docHint');

    function openDoc(type, title, src){
      docTitle.textContent = title || 'Documento';
      docOpen.href = src || '#';

      docImg.style.display = 'none';
      docFrame.style.display = 'none';
      docImg.removeAttribute('src');
      docFrame.removeAttribute('src');

      if (type === 'pdf'){
        docHint.textContent = 'Mostrando PDF';
        // tip: algunos visores respetan #view=FitH
        docFrame.src = src + '#view=FitH';
        docFrame.style.display = 'block';
      } else {
        docHint.textContent = 'Mostrando imagen';
        docImg.src = src;
        docImg.alt = title || '';
        docImg.style.display = 'block';
      }

      docModal.show();
    }

    document.body.addEventListener('click', function(e){
      const btn = e.target.closest('.js-open-doc');
      if (!btn) return;

      const type  = btn.getAttribute('data-type') || 'img';
      const title = btn.getAttribute('data-title') || 'Documento';
      const src   = btn.getAttribute('data-src') || '';

      if (!src){
        alert('Falta data-src en el botón.');
        return;
      }
      openDoc(type, title, src);
    });
  });
  </script>

</body>
</html>
