<?php
// ajax/guardar_estado_sala.php
declare(strict_types=1);
require_once __DIR__.'/../conexion.php';
session_start();
header('Content-Type: application/json');

// -------------------------------------------------------------------------
// 1.  Leer siempre el cuerpo, venga como venga (sendBeacon o fetch)
// -------------------------------------------------------------------------
$raw = file_get_contents('php://input');          // texto plano
$body = json_decode($raw, true);

if (!$body || !isset($body['sala'], $body['estado'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'msg' => 'json vacío o malformado']);
    exit;
}

$salaId  = (int)$body['sala'];
$estado  = json_encode($body['estado'], JSON_UNESCAPED_UNICODE);
$session = session_id();

// -------------------------------------------------------------------------
// 2.  Upsert en tu tabla estado_sala_temp
// -------------------------------------------------------------------------
$sql = "INSERT INTO estado_sala_temp (id_sala, session_id, estado_json, updated_at)
        VALUES (?,?,?,NOW())
        ON DUPLICATE KEY UPDATE
            session_id = VALUES(session_id),
            estado_json = VALUES(estado_json),
            updated_at  = NOW()";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, 'iss', $salaId, $session, $estado);

if (mysqli_stmt_execute($stmt)) {
    echo json_encode(['success' => true]);
} else {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'msg'     => 'MySQL: '.mysqli_error($conn)
    ]);
}
