<?php
// ajax/guardar_cobro_mesa.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$mesa_id = intval($_POST['mesa_id'] ?? 0);
$monto = floatval($_POST['monto'] ?? 0);
$cliente = trim($_POST['cliente'] ?? '');
$comentario = trim($_POST['comentario'] ?? '');
$forma_pago = $_POST['forma_pago'] ?? '';
$efectivo = floatval($_POST['efectivo'] ?? 0);
$transferencia = floatval($_POST['transferencia'] ?? 0);

if ($mesa_id <= 0 || $monto <= 0 || !in_array($forma_pago, ['efectivo', 'transferencia', 'dividido'])) {
  echo json_encode(['error' => 'Datos inválidos']);
  exit;
}

$fecha = date('Y-m-d');
$hora = date('H:i:s');

// Insertar en caja_mesa
$stmt = $con->prepare("INSERT INTO caja_mesa (mesa_id, cliente, comentario, monto_total, efectivo, transferencia, forma_pago, fecha, hora) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("issddssss", $mesa_id, $cliente, $comentario, $monto, $efectivo, $transferencia, $forma_pago, $fecha, $hora);
$stmt->execute();
// ...
$ticket_id = $stmt->insert_id;
$stmt->close();

// Insertar en tickets_mesa
$stmt2 = $con->prepare("INSERT INTO tickets_mesa (mesa_id, cliente, comentario, total, efectivo, transferencia, forma_pago, descuento, fecha) VALUES (?, ?, ?, ?, ?, ?, ?, 0, NOW())");
$stmt2->bind_param("issddds", $mesa_id, $cliente, $comentario, $monto, $efectivo, $transferencia, $forma_pago);
$stmt2->execute();
$ticket_mesa_id = $stmt2->insert_id;
$stmt2->close();

// Insertar detalle en tickets_mesa_detalle
$productos_json = $_POST['productos'] ?? '[]';
$productos = json_decode($productos_json, true);

if (is_array($productos)) {
  $stmt3 = $con->prepare("INSERT INTO tickets_mesa_detalle (ticket_id, producto_id, precio) VALUES (?, ?, ?)");
  foreach ($productos as $prod) {
    $prod_id = intval($prod['id'] ?? 0);
    $precio = floatval($prod['precio'] ?? 0);
    if ($prod_id > 0 && $precio >= 0) {
      $stmt3->bind_param("iid", $ticket_mesa_id, $prod_id, $precio);
      $stmt3->execute();
    }
  }
  $stmt3->close();
}

echo json_encode(['success' => true, 'ticket_id' => $ticket_mesa_id]);
