<?php
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// --- Salas activas ---
$salas = mysqli_fetch_all(mysqli_query($con, "SELECT * FROM salas WHERE en_index = 1 ORDER BY id ASC"), MYSQLI_ASSOC);
$productos = mysqli_fetch_all(mysqli_query($con, "SELECT * FROM productos ORDER BY nombre ASC"), MYSQLI_ASSOC);
$alquileres = mysqli_fetch_all(mysqli_query($con, "SELECT * FROM alquileres ORDER BY nombre ASC"), MYSQLI_ASSOC);

// --- Mesas activas ---
$mesas = mysqli_fetch_all(mysqli_query($con, "SELECT * FROM mesas WHERE en_index = 1 ORDER BY id ASC"), MYSQLI_ASSOC);
$productos_mesas = mysqli_fetch_all(mysqli_query($con, "SELECT * FROM productos_mesas WHERE visible = 1 ORDER BY nombre ASC"), MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Sala Turnos</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <style>
    .card { margin-bottom: 20px; }
    .ticket-box { background: #f8f9fa; padding: 10px; border-radius: 5px; margin-top: 10px; }
    .btn-remove { margin-left: 5px; }
    #caja-panel {
      position: fixed;
      left: 0;
      top: 0;
      height: 100vh;
      width: 220px;
      background: #ffffff;
      border-right: 1px solid #ddd;
      padding: 20px 15px;
      z-index: 9999;
      box-shadow: 2px 0 8px rgba(0,0,0,0.05);
    }
    #toggle-caja {
      position: absolute;
      top: 15px;
      right: -30px;
      background: #198754;
      color: white;
      border-radius: 50%;
      padding: 6px 9px;
      cursor: pointer;
      box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    }
    #main-content {
      margin-left: 220px;
      padding: 20px;
    }
  </style>
</head>
<body>

<div id="caja-panel">

<!-- Caja Mesas -->
<div class="p-2 border-bottom mb-2">
  <h6 class="mb-1">Caja Mesas</h6>
  <p>💵 Efectivo: <strong id="efectivo-mesas">$0</strong></p>
  <p>💳 Transferencia: <strong id="transferencia-mesas">$0</strong></p>
  <p>💰 Total: <strong id="total-mesas">$0</strong></p>
</div>

  <div id="toggle-caja">👁️</div>
  <h6>💵 Caja</h6>
  <p>Efectivo: <strong id="total-efectivo">$0.00</strong></p>
  <p>Transferencia: <strong id="total-transferencia">$0.00</strong></p>
  <hr>
  <p>Total: <strong id="total-general">$0.00</strong></p>
</div>

<div id="main-content" class="container py-4">

<h2>Salas</h2>
<div class="row">
<?php foreach ($salas as $sala): ?>
  <div class="col-lg-4 col-md-6">
    <form class="card p-3" id="form_sala_<?= $sala['id'] ?>">
      <h5>Sala <?= htmlspecialchars($sala['nombre']) ?></h5>
      <div class="mb-2">
        <label>Cliente</label>
        <input type="text" class="form-control" name="cliente">
      </div>
      <div class="mb-2">
        <label>Hora de inicio</label>
        <input type="time" class="form-control hora-inicio" name="hora" value="10:00" data-sala="<?= $sala['id'] ?>">
      </div>
      <div class="mb-2">
        <label>Duración</label><br>
        <button type="button" class="btn btn-danger btn-sm modificar-duracion" data-sala="<?= $sala['id'] ?>" data-minutos="-30">-30m</button>
        <span class="mx-2 duracion-texto" id="duracion_<?= $sala['id'] ?>">0:00h</span>
        <button type="button" class="btn btn-success btn-sm modificar-duracion" data-sala="<?= $sala['id'] ?>" data-minutos="60">+1h</button>
        <input type="hidden" name="duracion" value="0">
      </div>
      <div class="mb-2">
        <label>Productos</label>
        <select class="form-select producto-select" data-sala="<?= $sala['id'] ?>">
          <option value="">-- Agregar producto --</option>
          <?php foreach ($productos as $p): ?>
            <option value="<?= $p['id'] ?>" data-precio="<?= $p['precio'] ?>"><?= $p['nombre'] ?> ($<?= $p['precio'] ?>)</option>
          <?php endforeach; ?>
        </select>
        <ul class="list-group mt-1 lista-productos" id="productos_<?= $sala['id'] ?>"></ul>

      </div>
      <div class="mb-2">
        <label>Alquileres</label>
        <select class="form-select alquiler-select" data-sala="<?= $sala['id'] ?>">
          <option value="">-- Agregar alquiler --</option>
          <?php foreach ($alquileres as $a): ?>
            <option value="<?= $a['id'] ?>" data-precio="<?= $a['precio'] ?>"><?= $a['nombre'] ?> ($<?= $a['precio'] ?>)</option>
          <?php endforeach; ?>
        </select>
        <ul class="list-group mt-1 lista-alquileres" id="alquileres_<?= $sala['id'] ?>"></ul>
      </div>
      <div class="mb-2">
        <label>Descuento (%)</label>
        <input type="number" class="form-control descuento-input" name="descuento" value="0">
      </div>
      <div class="ticket-box" id="ticket_<?= $sala['id'] ?>">
        Ticket:
        <div>Sala: $0</div>
        <div>Productos: -</div>
        <div>Alquileres: -</div>
        <div>Descuento: 0%</div>
        <div>Total: $0</div>
      </div>
      <div class="text-end mt-2">
        <button type="button" class="btn btn-success btn-sm cobrar-btn" data-sala-id="<?= $sala['id'] ?>">
          💰 Cerrar sala y cobrar
        </button>
      </div>
    </form>
  </div>
<?php endforeach; ?>
</div>
<iframe
  src="https://nodo25.netfan.host/sistema-bar-salas/sala_1.php"
  width="80%"
  height="900"
  frameborder="0"
  style="border:0;"
  allowfullscreen>
</iframe>
<script>
/* ---------- PERSISTENCIA DE FORMULARIOS POR SALA --------- */
function getStorageKey(idSala) { return `form_sala_${idSala}`; }

/* Escucha los eventos change / input de todos los iframes */
function initAutoSave(idSala) {
  const iframe = document.getElementById(`iframe_sala_${idSala}`);
  iframe.addEventListener('load', () => {
    const doc = iframe.contentDocument || iframe.contentWindow.document;
    const form = doc.getElementById(`form_sala_${idSala}`);
    if (!form) return;

    // 1) Restituir estado guardado
    const saved = localStorage.getItem(getStorageKey(idSala));
    if (saved) {
      const data = JSON.parse(saved);
      Object.entries(data).forEach(([name, value]) => {
        const field = form.elements[name];
        if (field) field.value = value;
      });
    }

    // 2) Escuchar cambios y guardarlos
    form.addEventListener('input', () => {
      const data = {};
      [...form.elements].forEach(el => {
        if (el.name) data[el.name] = el.value;
      });
      localStorage.setItem(getStorageKey(idSala), JSON.stringify(data));
    });
  });
}

/* Llamalo una vez por cada sala fija */
['1', '2', 'Bandas', 'H', 'M'].forEach(initAutoSave);

/* ---------- FIN PERSISTENCIA ------------------------------ */
</script>

<iframe
  src="https://nodo25.netfan.host/sistema-bar-salas/mesa_1.php"
  width="50%"
  height="600"
  frameborder="0"
  style="border:0;"
  allowfullscreen>
</iframe>


<h2 class="mt-5">Mesas</h2>
<div class="row">
<?php foreach ($mesas as $mesa): ?>
  <div class="col-lg-4 col-md-6">
    <form class="card p-3" id="form_mesa_<?= intval($mesa['id']) ?>">
      <h5>Mesa <?= isset($mesa['numero']) ? htmlspecialchars($mesa['numero']) : '-' ?> - <?= isset($mesa['nombre']) ? htmlspecialchars($mesa['nombre']) : '' ?></h5>
      <p><strong>Ubicación:</strong> <?= isset($mesa['ubicacion']) ? htmlspecialchars($mesa['ubicacion']) : 'Sin especificar' ?></p>
      <div class="mb-2">
        <label>Cliente</label>
        <input type="text" class="form-control" name="cliente">
      </div>
      <div class="mb-2">
        <label>Hora</label>
        <input type="time" class="form-control hora-mesa" name="hora" value="23:34" data-mesa="<?= $mesa['id'] ?>">
      </div>
      <div class="mb-2">
        <label>Productos</label>
        <select class="form-select producto-mesa-select" data-mesa="<?= $mesa['id'] ?>">
          <option value="">-- Agregar producto --</option>
          <?php foreach ($productos_mesas as $pm): ?>
            <option value="<?= $pm['id'] ?>" data-precio="<?= $pm['precio'] ?>" data-stock="<?= isset($pm['stock']) ? htmlspecialchars($pm['stock']) : '' ?>">
              <?= htmlspecialchars($pm['nombre']) ?> ($<?= $pm['precio'] ?>)
            </option>
          <?php endforeach; ?>
        </select>
        <ul class="list-group mt-1 lista-productos-mesa" id="productos_mesa_<?= $mesa['id'] ?>"></ul>
      </div>
      <div class="ticket-box" id="ticket_mesa_<?= $mesa['id'] ?>">
        Ticket:
        <div>Hora: <span class="ticket-hora">23:34</span></div>
        <div>Productos: -</div>
        <div>Total: $0</div>
      </div>

      <div class="mt-2">
        <button type="button" class="btn btn-success btn-sm" onclick="abrirModalCobroMesa(<?= $mesa['id'] ?>)">💰 Cerrar mesa y cobrar</button>
      </div>
    </form>
  </div>
<?php endforeach; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Función para actualizar el ticket de la sala
function actualizarTicket(salaId) {
  const form = $('#form_sala_' + salaId);
  const hora = form.find('.hora-inicio').val();
  const duracionMin = parseInt(form.find('input[name="duracion"]').val()) || 0;
  const descuento = parseInt(form.find('.descuento-input').val()) || 0;

  $.post('ajax/ajax_precio_sala.php', { sala_id: salaId, hora: hora }, function(data) {
    let base = parseFloat(data.precio) * (duracionMin / 60);
    let totalProd = 0;
    form.find('.lista-productos li').each(function() {
      totalProd += parseFloat($(this).data('precio'));
    });
    let totalAlq = 0;
    form.find('.lista-alquileres li').each(function() {
      totalAlq += parseFloat($(this).data('precio'));
    });

    let subtotal = base + totalProd + totalAlq;
    let totalFinal = subtotal - (subtotal * descuento / 100);
    $('#ticket_' + salaId).html(`
      Ticket:
      <div>Precio Sala $${base.toFixed(2)}</div>
      <div>Productos: $${totalProd.toFixed(2)}</div>
      <div>Alquileres: $${totalAlq.toFixed(2)}</div>
      <div>Descuento: ${descuento}%</div>
      <div>Total: $${totalFinal.toFixed(2)}</div>
    `);
    form.find('.cobrar-btn').attr('data-total', totalFinal.toFixed(2));
  }, 'json');
}

// Función para actualizar el ticket de la mesa
function actualizarTicketMesa(mesaId) {
  let total = 0;
  $('#productos_mesa_' + mesaId + ' li').each(function() {
    total += parseFloat($(this).data('precio'));
  });
  $('#ticket_mesa_' + mesaId).html(`
    Ticket:
    <div>Productos: $${total.toFixed(2)}</div>
    <div>Total: $${total.toFixed(2)}</div>
  `);
}

// Eventos para salas
$(document).on('change', '.hora-inicio, .descuento-input', function() {
  const sala = $(this).closest('form').attr('id').split('_')[2];
  actualizarTicket(sala);
});

$(document).on('click', '.modificar-duracion', function() {
  const sala = $(this).data('sala');
  let campo = $('#form_sala_' + sala + ' input[name="duracion"]');
  let actual = parseInt(campo.val()) || 0;
  let nuevo = actual + parseInt($(this).data('minutos'));
  if (nuevo < 0) nuevo = 0;
  campo.val(nuevo);
  $('#duracion_' + sala).text((nuevo / 60).toFixed(2) + 'h');
  actualizarTicket(sala);
});

$(document).on('change', '.producto-select', function() {
  const sala = $(this).data('sala');
  const val = $(this).find('option:selected');
  const precio = parseFloat(val.data('precio'));
  $('#productos_' + sala).append(`<li class="list-group-item" data-precio="${precio}">${val.text()} <button type="button" class="btn btn-sm btn-outline-danger btn-remove">🗑</button></li>`);
  $(this).val('');
  actualizarTicket(sala);
});

$(document).on('change', '.alquiler-select', function() {
  const sala = $(this).data('sala');
  const val = $(this).find('option:selected');
  const precio = parseFloat(val.data('precio'));
  $('#alquileres_' + sala).append(`<li class="list-group-item" data-precio="${precio}">${val.text()} <button type="button" class="btn btn-sm btn-outline-danger btn-remove">🗑</button></li>`);
  $(this).val('');
  actualizarTicket(sala);
});

// Eventos para mesas
$(document).on('change', '.hora-mesa', function() {
  const mesaId = $(this).data('mesa');
  const hora = $(this).val();
  $('#ticket_mesa_' + mesaId + ' .ticket-hora').text(hora);
});

$(document).on('change', '.producto-mesa-select', function() {
  const mesa = $(this).data('mesa');
  const val = $(this).find('option:selected');
  const precio = parseFloat(val.data('precio'));
  const stock = val.data('stock');
  const info = stock !== '' && stock !== null ? `Stock: ${stock}` : 'Consumo libre';
  $('#productos_mesa_' + mesa).append(`
    <li class="list-group-item d-flex justify-content-between align-items-center"
        data-precio="${precio}"
        data-nombre="${val.text()}">
      <span class="nombre-prod">${val.text()}</span>
      <span class="badge bg-secondary">${info}</span>
      <button type="button" class="btn btn-sm btn-outline-danger btn-remove">🗑</button>
    </li>
  `);
  $(this).val('');
  actualizarTicketMesa(mesa);
});

// Evento para eliminar productos/alquileres
$(document).on('click', '.btn-remove', function() {
  $(this).closest('li').remove();
  const id = $(this).closest('form').attr('id');
  if (id.includes('mesa')) {
    actualizarTicketMesa(id.split('_')[2]);
  } else {
    actualizarTicket(id.split('_')[2]);
  }
});

// Panel de caja
document.addEventListener("DOMContentLoaded", function() {
  function actualizarCaja() {
    fetch("ajax/consultar_totales_caja.php")
      .then(r => r.json())
      .then(data => {
        document.getElementById('total-efectivo').innerText = "$" + data.efectivo;
        document.getElementById('total-transferencia').innerText = "$" + data.transferencia;
        document.getElementById('total-general').innerText = "$" + data.total;
      });
  }

  actualizarCaja();
  function actualizarCajaMesas() {
  console.log('🔄 Llamando a consultar_totales_mesas.php...');
    fetch("ajax/consultar_totales_mesas.php")
      .then(r => r.json())
      .then(data => {
        document.getElementById('efectivo-mesas').innerText = "$" + data.efectivo;
        document.getElementById('transferencia-mesas').innerText = "$" + data.transferencia;
        document.getElementById('total-mesas').innerText = "$" + data.total;
      });
  }

  actualizarCajaMesas();
  setInterval(actualizarCajaMesas, 10000);

  setInterval(actualizarCaja, 10000);

  document.getElementById('toggle-caja').addEventListener('click', function() {
    const panel = document.getElementById('caja-panel');
    if (panel.style.left === "0px") {
      panel.style.left = "-200px";
      document.getElementById('main-content').style.marginLeft = "0px";
    } else {
      panel.style.left = "0px";
      document.getElementById('main-content').style.marginLeft = "200px";
    }
  });
});
</script>

<!-- Modal único para cobro de salas -->
<div class="modal fade" id="modalCobroSala" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="formCobroSala" class="p-3">
        <h5 class="mb-3">💰 Cerrar Sala y Cobrar</h5>
        <input type="hidden" id="modal-sala-id" name="sala_id">
        <input type="hidden" id="modal-total" name="total">

        <div class="mb-2">
          <label>Cliente</label>
          <input type="text" class="form-control" id="modal-cliente" name="cliente">
        </div>

        <div class="mb-2">
          <label>Comentario</label>
          <textarea class="form-control" id="modal-comentario" name="comentario" rows="2"></textarea>
        </div>

        <div class="mb-2">Total a cobrar: $<span id="texto-total">0.00</span></div>

        <div class="mb-2">
          <label class="d-block"><input type="radio" name="forma_pago" value="efectivo" checked> Efectivo</label>
          <label class="d-block"><input type="radio" name="forma_pago" value="transferencia"> Transferencia</label>
          <label class="d-block"><input type="radio" name="forma_pago" value="dividido"> Dividido</label>
        </div>

        <div id="dividido-inputs" class="mb-2" style="display:none;">
          <input type="number" class="form-control mb-2" id="input-efectivo" placeholder="Monto en efectivo">
          <input type="number" class="form-control" id="input-transferencia" placeholder="Monto en transferencia">
        </div>

        <div class="alert alert-danger d-none" id="alerta-monto">⚠️ El monto no coincide con el total.</div>

        <div class="mt-3 text-end">
          <button type="submit" class="btn btn-primary">Confirmar Cobro</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
// Script para manejar el modal de cobro
document.addEventListener("DOMContentLoaded", () => {
  const modalEl = document.getElementById('modalCobroSala');
  const bsModal = new bootstrap.Modal(modalEl);
  const formCobro = document.getElementById('formCobroSala');
  const txtTotal = document.getElementById('texto-total');
  const inpSalaId = document.getElementById('modal-sala-id');
  const inpTotal = document.getElementById('modal-total');
  const inpCliente = document.getElementById('modal-cliente');
  const inpComentario = document.getElementById('modal-comentario');
  const divDividido = document.getElementById('dividido-inputs');
  const alertaMonto = document.getElementById('alerta-monto');
  let totalActual = 0;

  // Evento para abrir el modal desde cualquier botón de cobrar
  document.addEventListener('click', e => {
    const btn = e.target.closest('.cobrar-btn');
    if (!btn) return;

    const salaId = btn.getAttribute('data-sala-id');
    const ticket = document.querySelector(`#ticket_${salaId}`);
    const totalLinea = ticket?.querySelector('div:last-child')?.textContent || '$0';
    totalActual = parseFloat(totalLinea.replace(/[^0-9,.]/g, '').replace(',','.')) || 0;

    formCobro.reset();
divDividido.style.display = 'none';
alertaMonto.classList.add('d-none');

// Llenar datos en el modal
    inpSalaId.value = salaId;
    inpTotal.value = totalActual.toFixed(2);
    txtTotal.textContent = totalActual.toFixed(2);

    // Obtener cliente del formulario de la sala
    const clienteInput = document.querySelector(`#form_sala_${salaId} input[name="cliente"]`);
    inpCliente.value = clienteInput ? clienteInput.value : '';

    // Resetear el modal
    divDividido.style.display = 'none';
    alertaMonto.classList.add('d-none');
    formCobro.reset();

    // Mostrar modal
    bsModal.show();
  });

  // Mostrar/ocultar inputs para pago dividido
  document.querySelectorAll('input[name="forma_pago"]').forEach(input => {
    input.addEventListener('change', function() {
      divDividido.style.display = (this.value === 'dividido') ? 'block' : 'none';
    });
  });

  // Enviar formulario de cobro
  let ticketIdGenerado = null; // Declarar fuera
  formCobro.addEventListener('submit', async e => {
  e.preventDefault();
  const formaPago = document.querySelector('input[name="forma_pago"]:checked').value;
  let efectivo = 0;
  let transferencia = 0;

  if (formaPago === 'dividido') {
    efectivo = parseFloat(document.getElementById('input-efectivo').value || 0);
    transferencia = parseFloat(document.getElementById('input-transferencia').value || 0);
    if (Math.abs((efectivo + transferencia) - totalActual) > 0.01) {
      alertaMonto.classList.remove('d-none');
      return;
    }
  } else if (formaPago === 'efectivo') {
    efectivo = totalActual;
  } else {
    transferencia = totalActual;
  }

  const formData = new FormData(formCobro);
  formData.append('efectivo', efectivo);
  formData.append('transferencia', transferencia);
  formData.append('sala_id', inpSalaId.value);
  formData.append('monto', inpTotal.value);
  formData.append('forma_pago', formaPago);

  // Obtener datos necesarios
  const horaInicio = document.querySelector(`#form_sala_${inpSalaId.value} .hora-inicio`).value;
  const duracionMin = parseInt(document.querySelector(`#form_sala_${inpSalaId.value} input[name="duracion"]`).value) || 0;

  formData.append('hora_inicio', horaInicio);
  formData.append('hora_fin', '23:59'); // por ahora fijo
  formData.append('duracion', duracionMin);

  // Obtener precio desde ajax
  let base = 0;
  try {
    const res = await fetch('ajax/ajax_precio_sala.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: new URLSearchParams({
        sala_id: inpSalaId.value,
        hora: horaInicio
      })
    });
    const data = await res.json();
    base = parseFloat(data.precio) * (duracionMin / 60);
  } catch (e) {
    alert('Error al calcular precio sala');
    return;
  }

  formData.append('precio_sala', base.toFixed(2));

  // Productos
  const productos = [];
  document.querySelectorAll(`#productos_${inpSalaId.value} li`).forEach(li => {
    const nombre = li.textContent.trim().replace('🗑', '').trim();
    const precio = parseFloat(li.dataset.precio || 0);
    productos.push({
      nombre,
      precio,
      cantidad: 1
    });
  });
  formData.append('productos_json', JSON.stringify(productos));
// Alquileres
  const alquileres = [];
  document.querySelectorAll(`#alquileres_${inpSalaId.value} li`).forEach(li => {
    alquileres.push({
      nombre: li.textContent.trim().replace('🗑', '').trim(),
      precio: parseFloat(li.dataset.precio)
    });
  });
  formData.append('alquileres', JSON.stringify(alquileres));

  const descuento = parseFloat(document.querySelector(`#form_sala_${inpSalaId.value} .descuento-input`).value) || 0;
  formData.append('descuento', descuento);

  // Enviar al servidor
  fetch('ajax/guardar_cobro_sala.php', {
    method: 'POST',
    body: formData
  })
  .then(r => r.json())
  .then(data => {
    if (data.success && data.ticket_id) {
      ticketIdGenerado = data.ticket_id;
      const modalBody = document.querySelector('#modalCobroSala .modal-content');
      modalBody.innerHTML = `
        <div class="p-3 text-center">
          <h5 class="text-success mb-3">✅ Cobro registrado correctamente</h5>
          <div class="d-flex justify-content-center gap-3">
            <button onclick="window.open('ver_ticket_sala.php?id=${ticketIdGenerado}', '_blank')" class="btn btn-primary">
              Ver Ticket
            </button>
            <button onclick="window.open('ver_ticket_sala.php?id=${ticketIdGenerado}&print=1', '_blank')" class="btn btn-secondary">
              Imprimir
            </button>
            <button onclick="location.reload()" class="btn btn-success">
              Finalizar
            </button>
          </div>
        </div>
      `;
      actualizarTotalesCaja();
    } else {
      alert('❌ Error al guardar el cobro');
    }
  })
  .catch(() => alert('❌ Error al conectar con el servidor'));
});


  // Función para actualizar los totales de caja
  function actualizarTotalesCaja() {
    fetch('ajax/consultar_totales_caja.php')
      .then(r => r.json())
      .then(data => {
        document.getElementById('total-efectivo').textContent = '$' + data.efectivo;
        document.getElementById('total-transferencia').textContent = '$' + data.transferencia;
        document.getElementById('total-general').textContent = '$' + data.total;
      });
  }
});
</script>
<style>
  :root {
    --primary-color: #4361ee;
    --secondary-color: #3f37c9;
    --success-color: #4cc9f0;
    --danger-color: #f72585;
    --light-color: #f8f9fa;
    --dark-color: #212529;
    --border-radius: 10px;
    --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    --transition: all 0.3s ease;
  }

  body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background-color: #f5f7fa;
  }

  .card {
    margin-bottom: 25px;
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--box-shadow);
    transition: var(--transition);
    overflow: hidden;
    background: white;
  }

  .card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
  }

  .card h5 {
    color: var(--primary-color);
    font-weight: 600;
    border-bottom: 2px solid #f0f0f0;
    padding-bottom: 10px;
    margin-bottom: 15px;
  }

  .form-control, .form-select {
    border-radius: var(--border-radius);
    border: 1px solid #e0e0e0;
    padding: 8px 12px;
    transition: var(--transition);
  }

  .form-control:focus, .form-select:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 0.25rem rgba(67, 97, 238, 0.25);
  }

  .btn {
    border-radius: var(--border-radius);
    font-weight: 500;
    padding: 8px 16px;
    transition: var(--transition);
  }

  .btn-success {
    background-color: var(--success-color);
    border-color: var(--success-color);
  }

  .btn-success:hover {
    background-color: #38b6db;
    border-color: #38b6db;
  }

  .btn-danger {
    background-color: var(--danger-color);
    border-color: var(--danger-color);
  }

  .btn-danger:hover {
    background-color: #e5177a;
    border-color: #e5177a;
  }

  .btn-sm {
    padding: 5px 10px;
    font-size: 0.875rem;
  }

  .ticket-box {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    padding: 15px;
    border-radius: var(--border-radius);
    margin-top: 15px;
    border-left: 4px solid var(--primary-color);
    font-size: 0.9rem;
  }

  .ticket-box div {
    margin-bottom: 5px;
  }

  .ticket-box div:last-child {
    font-weight: bold;
    color: var(--primary-color);
    margin-top: 8px;
    margin-bottom: 0;
  }

  .list-group-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 12px;
    border-radius: var(--border-radius) !important;
    margin-bottom: 5px;
    transition: var(--transition);
  }

  .list-group-item:hover {
    background-color: #f8f9fa;
  }

  .btn-remove {
    background-color: transparent;
    border: none;
    color: var(--danger-color);
    padding: 2px 5px;
    font-size: 1rem;
    transition: var(--transition);
  }

  .btn-remove:hover {
    transform: scale(1.1);
  }

  .modificar-duracion {
    width: 40px;
    height: 40px;
    border-radius: 50% !important;
    display: inline-flex;
    align-items: center;
    justify-content: center;
  }

  .duracion-texto {
    font-weight: bold;
    font-size: 1.1rem;
    color: var(--primary-color);
    display: inline-block;
    min-width: 60px;
    text-align: center;
  }

  #caja-panel {
    position: fixed;
    left: 0;
    top: 0;
    height: 100vh;
    width: 250px;
    background: white;
    border-right: 1px solid #e0e0e0;
    padding: 25px;
    z-index: 9999;
    box-shadow: 3px 0 15px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
  }

  #toggle-caja {
    position: absolute;
    top: 20px;
    right: -40px;
    background: var(--primary-color);
    color: white;
    border-radius: 50%;
    width: 35px;
    height: 35px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
    transition: var(--transition);
  }

  #toggle-caja:hover {
    transform: scale(1.1);
  }

  #main-content {
    margin-left: 250px;
    padding: 30px;
    transition: var(--transition);
  }

  /* Mejoras para el modal */
  .modal-content {
    border-radius: var(--border-radius);
    border: none;
    box-shadow: var(--box-shadow);
  }

  .modal-header {
    border-bottom: none;
    padding-bottom: 0;
  }

  .modal-footer {
    border-top: none;
  }

  /* Badges para stock */
  .badge {
    font-weight: 500;
    padding: 5px 8px;
    border-radius: 20px;
  }

  .bg-secondary {
    background-color: #6c757d !important;
  }

  /* Responsive */
  @media (max-width: 768px) {
    #caja-panel {
      width: 220px;
      padding: 15px;
    }
    
    #main-content {
      margin-left: 220px;
      padding: 15px;
    }
    
    .card {
      margin-bottom: 15px;
    }
  }
</style>
<<!-- Modal para cobrar mesa -->
<div class="modal fade" id="modalCobroMesa" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="formCobroMesa" class="p-3">
        <h5 class="mb-3">💰 Cerrar Mesa y Cobrar</h5>
        <input type="hidden" id="mesa-id" name="mesa_id">
        <input type="hidden" id="mesa-total" name="monto">

        <div class="mb-2">
          <label>Cliente</label>
          <input type="text" class="form-control" id="mesa-cliente" name="cliente">
        </div>

        <div class="mb-2">
          <label>Comentario</label>
          <textarea class="form-control" id="mesa-comentario" name="comentario" rows="2"></textarea>
        </div>

        <div class="mb-2">
          <label>Total</label>
          <input type="text" class="form-control" id="mesa-total-visible" disabled>
        </div>

        <div class="mb-2">
          <label>Forma de pago</label>
          <select class="form-select" id="mesa-forma-pago" name="forma_pago" required>
            <option value="">Seleccionar</option>
            <option value="efectivo">Efectivo</option>
            <option value="transferencia">Transferencia</option>
            <option value="dividido">Dividido</option>
          </select>
        </div>

        <div class="row mb-2" id="mesa-dividido" style="display: none;">
          <div class="col">
            <label>Efectivo</label>
            <input type="number" step="0.01" class="form-control" id="mesa-efectivo" name="efectivo">
          </div>
          <div class="col">
            <label>Transferencia</label>
            <input type="number" step="0.01" class="form-control" id="mesa-transferencia" name="transferencia">
          </div>
        </div>

        <div class="d-flex justify-content-between mt-3">
          <button type="submit" class="btn btn-success">💾 Confirmar cobro</button>
          <a id="mesa-ver-ticket" href="#" target="_blank" class="btn btn-outline-primary d-none">Ver ticket</a>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
function abrirModalCobroMesa(id) {
  const ticket = document.querySelector(`#ticket_mesa_${id}`);
  const totalLinea = ticket?.querySelector('div:last-child')?.textContent || '$0';
  const total = parseFloat(totalLinea.replace(/[^0-9.,]/g, '').replace(',', '.')) || 0;

  document.getElementById('mesa-id').value = id;
  document.getElementById('mesa-total').value = total;
  document.getElementById('mesa-total-visible').value = `$${total.toFixed(2)}`;
  document.getElementById('mesa-cliente').value = '';
  document.getElementById('mesa-comentario').value = '';
  document.getElementById('mesa-forma-pago').value = '';
  document.getElementById('mesa-dividido').style.display = 'none';
  document.getElementById('mesa-ver-ticket').classList.add('d-none');
  const modal = new bootstrap.Modal(document.getElementById('modalCobroMesa'));
  modal.show();
}

document.getElementById("mesa-forma-pago").addEventListener("change", function () {
  document.getElementById("mesa-dividido").style.display = this.value === "dividido" ? "flex" : "none";
});

const form = document.getElementById("formCobroMesa");
/* Mesa onsubmit duplicate removed */


function actualizarCajaMesas() {
  console.log('🔄 Llamando a consultar_totales_mesas.php...');
  fetch('ajax/consultar_totales_mesas.php')
    .then(r => r.json())
    .then(data => {
      console.log('👉 Datos de caja mesas:', data);
    .then(res => res.json())
    .then(data => {
      document.getElementById('efectivo-mesas').textContent = '$' + data.efectivo.toFixed(2);
      document.getElementById('transferencia-mesas').textContent = '$' + data.transferencia.toFixed(2);
      document.getElementById('total-mesas').textContent = '$' + data.total.toFixed(2);
    });
}

// Llamar al cargar
actualizarCajaMesas();

document.addEventListener('DOMContentLoaded', function() {
  const form = document.getElementById('formCobroMesa');
  if (form) {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      const btn = document.querySelector('#formCobroMesa button[type="submit"]');
      btn.disabled = true;

      const formData = new FormData(this);
// Ajuste forma de pago -> efectivo / transferencia
const forma = document.getElementById('mesa-forma-pago').value;
const total = parseFloat(document.getElementById('mesa-total').value) || 0;

if (forma === 'efectivo') {
  formData.set('efectivo', total.toFixed(2));
  formData.set('transferencia', 0);
} else if (forma === 'transferencia') {
  formData.set('efectivo', 0);
  formData.set('transferencia', total.toFixed(2));
} else if (forma === 'dividido') {
  const efec = parseFloat(document.getElementById('mesa-efectivo').value) || 0;
  const trans = parseFloat(document.getElementById('mesa-transferencia').value) || 0;
  formData.set('efectivo', efec);
  formData.set('transferencia', trans);
}

      const mesaId = document.getElementById('mesa-id').value;

      const productosSeleccionados = [];
      document.querySelectorAll(`#productos_mesa_${mesaId} li`).forEach(item => {
        const id = parseInt(item.dataset.id);
        const precio = parseFloat(item.dataset.precio);
        productosSeleccionados.push({ id, precio });
      });

      const descuento = parseFloat(document.querySelector(`#mesa-${mesaId} .descuento-input`)?.value || 0);

      formData.append('productos_json', JSON.stringify(productosSeleccionados));
      formData.append('descuento', descuento);

      fetch('ajax/guardar_cobro_mesa.php', {
        method: 'POST',
        body: formData
      })
      .then(res => res.json())
      .then(data => {

        if (data.success && data.ticket_id) {
          const modalContent = document.querySelector('#modalCobroMesa .modal-content');
          modalContent.innerHTML = `
            <div class="p-3 text-center">
              <h5 class="text-success mb-3">✅ Cobro registrado correctamente</h5>
              <div class="d-flex justify-content-center gap-3">
                <button onclick="window.open('ver_ticket_mesa.php?id=${data.ticket_id}', '_blank')" class="btn btn-primary">
                  Ver Ticket
                </button>
                <button onclick="window.open('ver_ticket_mesa.php?id=${data.ticket_id}&print=1', '_blank')" class="btn btn-secondary">
                  Imprimir
                </button>
                <button onclick="location.reload()" class="btn btn-success">
                  Finalizar
                </button>
              </div>
            </div>
          `;
          actualizarCajaMesas();
        } else {
          alert('❌ Error: ' + (data.error || 'Error desconocido'));
        }
      })
      .catch(() => alert('❌ Error al guardar'))
      .finally(() => {
        btn.disabled = false;
      });
    });

    document.getElementById('mesa-forma-pago').addEventListener('change', function () {
      document.getElementById('mesa-dividido').style.display = this.value === 'dividido' ? 'flex' : 'none';
    });
  }
});
</script>
