<?php
require '../conexion.php';
header('Content-Type: application/json');

/* sumamos efectivo y transferencia directamente */
$q = mysqli_query($con,"
    SELECT 
        SUM(efectivo)      AS total_efectivo,
        SUM(transferencia) AS total_transferencia
    FROM caja_sala
");

$row = mysqli_fetch_assoc($q);
$total_efectivo      = floatval($row['total_efectivo']      ?? 0);
$total_transferencia = floatval($row['total_transferencia'] ?? 0);

echo json_encode([
    'efectivo'      => number_format($total_efectivo,2,'.',''),
    'transferencia' => number_format($total_transferencia,2,'.',''),
    'total'         => number_format($total_efectivo + $total_transferencia,2,'.','')
]);
?>
