<?php
// ajax/guardar_estado_sala.php
// Guarda el estado temporal de una sala en la tabla estado_sala_temp
header('Content-Type: application/json');
require_once __DIR__ . '/../conexion.php'; // ajustá el path según tu estructura

$input = file_get_contents('php://input');
$data  = json_decode($input, true);

if (!$data || !isset($data['id_sala']) || !isset($data['estado'])) {
    http_response_code(400);
    echo json_encode(['success'=>false,'msg'=>'Payload inválido']);
    exit;
}

$id_sala = (int)$data['id_sala'];
$estado_json = mysqli_real_escape_string($conn, $data['estado']);
$session_id = session_id();

// Insertar o actualizar
$sql = "INSERT INTO estado_sala_temp (id_sala, session_id, estado_json, updated_at)
        VALUES ($id_sala, '$session_id', '$estado_json', NOW())
        ON DUPLICATE KEY UPDATE estado_json = VALUES(estado_json), updated_at = NOW()";

if (mysqli_query($conn, $sql)) {
    echo json_encode(['success'=>true]);
} else {
    http_response_code(500);
    echo json_encode(['success'=>false,'msg'=>mysqli_error($conn)]);
}
?>