<?php
require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// Agregar sala
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['accion'] === 'agregar') {
  $nombre = trim($_POST['nombre']);
  if ($nombre !== '') {
    $stmt = mysqli_prepare($con, "INSERT INTO salas (nombre, en_index) VALUES (?, 0)");
    mysqli_stmt_bind_param($stmt, 's', $nombre);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
  }
  header("Location: admin_salas.php");
  exit;
}

// Editar sala
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['accion'] === 'editar') {
  $id = intval($_POST['id']);
  $nombre = trim($_POST['nombre']);
  $en_index = isset($_POST['en_index']) ? 1 : 0;

  if ($id > 0 && $nombre !== '') {
    $stmt = mysqli_prepare($con, "UPDATE salas SET nombre = ?, en_index = ? WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'sii', $nombre, $en_index, $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
  }
  header("Location: admin_salas.php");
  exit;
}

// Traer todas las salas
$res = mysqli_query($con, "SELECT * FROM salas ORDER BY id ASC");
$salas = mysqli_fetch_all($res, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Administrar Salas</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .editar-btn { font-size: 0.9em; }
  </style>
</head>
<body class="bg-light">
<div class="container py-4">
  <h2 class="mb-4">🏠 Administrar Salas</h2>

  <form method="POST" class="row g-3 mb-4">
    <input type="hidden" name="accion" value="agregar">
    <div class="col-md-10">
      <input type="text" name="nombre" class="form-control" placeholder="Nombre de la sala" required>
    </div>
    <div class="col-md-2">
      <button type="submit" class="btn btn-success w-100">Agregar</button>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-bordered table-sm bg-white align-middle">
      <thead class="table-light">
        <tr>
          <th>ID</th>
          <th>Nombre</th>
          <th>En Index</th>
          <th style="width: 100px;">Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($salas as $s): ?>
          <tr>
            <form method="POST">
              <input type="hidden" name="accion" value="editar">
              <input type="hidden" name="id" value="<?= $s['id'] ?>">

              <td><?= $s['id'] ?></td>
              <td><input type="text" name="nombre" class="form-control form-control-sm" value="<?= htmlspecialchars($s['nombre']) ?>" required></td>
              <td class="text-center">
                <input type="checkbox" name="en_index" <?= $s['en_index'] ? 'checked' : '' ?>>
              </td>
              <td>
                <button type="submit" class="btn btn-sm btn-primary editar-btn">💾</button>
              </td>
            </form>
          </tr>
        <?php endforeach; ?>
        <?php if (count($salas) === 0): ?>
          <tr><td colspan="4" class="text-center text-muted">No hay salas cargadas.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
