<?php
require 'conexion.php';

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
  echo "ID inválido";
  exit;
}

$res = mysqli_query($con, "SELECT * FROM caja_sala WHERE id = $id LIMIT 1");
if (mysqli_num_rows($res) == 0) {
  echo "Ticket no encontrado.";
  exit;
}

$t = mysqli_fetch_assoc($res);
$productos = json_decode($t['productos'], true);
$alquileres = json_decode($t['alquileres'], true);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ticket Sala</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { padding: 2rem; }
    .ticket-box {
      max-width: 400px;
      margin: auto;
      border: 1px solid #ccc;
      padding: 1.5rem;
      border-radius: 10px;
    }
  </style>
</head>
<body>
  <div class="ticket-box">
    <h4>🧾 Ticket Sala</h4>
    <p><strong># Ticket:</strong> <?= $t['id'] ?></p>
    <p><strong>Fecha:</strong> <?= $t['fecha'] . ' ' . $t['hora'] ?></p>
    <p><strong>Sala:</strong> <?= $t['sala_id'] ?></p>
    <p><strong>Cliente:</strong> <?= htmlspecialchars($t['cliente']) ?></p>
    <p><strong>Comentario:</strong><br><?= nl2br(htmlspecialchars($t['comentario'])) ?></p>
    <hr>

    <?php if (!empty($productos)): ?>
      <p><strong>🧃 Productos:</strong></p>
      <ul>
        <?php foreach ($productos as $prod): ?>
          <li><?= htmlspecialchars($prod['nombre']) ?> x<?= $prod['cantidad'] ?> - $<?= number_format($prod['subtotal'], 2) ?></li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>

    <?php if (!empty($alquileres)): ?>
      <p><strong>🔧 Alquileres:</strong></p>
      <ul>
        <?php foreach ($alquileres as $alq): ?>
          <li><?= htmlspecialchars($alq['nombre']) ?> - $<?= number_format($alq['subtotal'], 2) ?></li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>

    <p><strong>Forma de Pago:</strong> <?= ucfirst($t['forma_pago']) ?></p>
    <p><strong>Efectivo:</strong> $<?= number_format($t['efectivo'], 2) ?></p>
    <p><strong>Transferencia:</strong> $<?= number_format($t['transferencia'], 2) ?></p>
    <hr>
    <h5><strong>Total:</strong> $<?= number_format($t['monto'], 2) ?></h5>

    <button class="btn btn-primary mt-3" onclick="window.print()">🖨️ Imprimir</button>
  </div>
</body>
</html>
