<?php
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
  die("ID inválido");
}

$result = mysqli_query($con, "SELECT * FROM caja_mesa WHERE id = $id LIMIT 1");
if (!$result || mysqli_num_rows($result) === 0) {
  die("Ticket no encontrado");
}
$ticket = mysqli_fetch_assoc($result);
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ticket Mesa #<?= $ticket['id'] ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { max-width: 400px; margin: auto; padding: 20px; font-size: 15px; }
    .ticket { border: 1px solid #ccc; padding: 20px; border-radius: 5px; }
    .ticket h3 { margin-bottom: 20px; }
    .ticket p { margin: 5px 0; }
    .text-center { text-align: center; }
    .btn-print { margin-top: 15px; }
  </style>
</head>
<body>
  <div class="ticket">
    <h3 class="text-center">🧾 Ticket Mesa</h3>
    <p><strong># Ticket:</strong> <?= $ticket['id'] ?></p>
    <p><strong>Fecha:</strong> <?= $ticket['fecha'] ?> <?= $ticket['hora'] ?></p>
    <p><strong>Mesa:</strong> <?= $ticket['mesa_id'] ?></p>
    <p><strong>Cliente:</strong> <?= htmlspecialchars($ticket['cliente']) ?></p>
    <p><strong>Comentario:</strong> <?= nl2br(htmlspecialchars($ticket['comentario'])) ?></p>
    <hr>
    <p><strong>Forma de Pago:</strong> <?= ucfirst($ticket['forma_pago']) ?></p>
    <p><strong>Efectivo:</strong> $<?= number_format($ticket['efectivo'], 2) ?></p>
    <p><strong>Transferencia:</strong> $<?= number_format($ticket['transferencia'], 2) ?></p>
    <hr>
    <p><strong>Total:</strong> $<?= number_format($ticket['monto_total'], 2) ?></p>
    <div class="text-center">
      <button class="btn btn-primary btn-print" onclick="window.print()">🖨 Imprimir</button>
    </div>
  </div>
</body>
</html>
