<?php
@session_start();
require_once '../db.php';
$pdo = pdo();

// Opcional, por si en db.php no está:
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// TODO: validar que sea admin / rol correcto

$errores = [];
$ok = false;
$data = [
    'nombre'            => '',
    'descripcion_corta' => '',
    'descripcion_larga' => '',
    'metros_cubiertos'  => '',
    'metros_galeria'    => '',
    'sistema_default'   => 'estructura',
    'precio_desde'      => '',
    'precio_lista'      => '',
    'activo'            => 1,
    'orden'             => 0
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    foreach ($data as $k => $v) {
        if (isset($_POST[$k])) {
            $data[$k] = trim($_POST[$k]);
        }
    }

    if ($data['nombre'] === '') {
        $errores[] = 'El nombre es obligatorio.';
    }

    $imgPath = null;

    // Subir imagen
    if (!empty($_FILES['imagen']['name'])) {
        $dir = __DIR__ . '/uploads/modelos/'; // admin/uploads/modelos/

        if (!is_dir($dir)) {
            @mkdir($dir, 0777, true);
        }

        if (!is_dir($dir) || !is_writable($dir)) {
            $errores[] = 'No se puede escribir en la carpeta de imágenes de modelos.';
        } else {
            $ext = pathinfo($_FILES['imagen']['name'], PATHINFO_EXTENSION);
            $ext = strtolower($ext);
            if (!in_array($ext, ['jpg','jpeg','png','webp','gif'])) {
                $errores[] = 'Formato de imagen no permitido.';
            } else {
                $fname = 'modelo_' . time() . '_' . rand(1000,9999) . '.' . $ext;
                $dest  = $dir . $fname;

                if (move_uploaded_file($_FILES['imagen']['tmp_name'], $dest)) {
                    // ojo: esto es ruta relativa desde /admin
                    $imgPath = 'uploads/modelos/' . $fname;
                } else {
                    $errores[] = 'Error al subir la imagen.';
                }
            }
        }
    }

    if (empty($errores)) {
        try {
            $stmt = $pdo->prepare("
                INSERT INTO modelos_casas
                (nombre, descripcion_corta, descripcion_larga,
                 metros_cubiertos, metros_galeria,
                 sistema_default,
                 precio_desde, precio_lista,
                 imagen_portada, activo, orden,
                 created_at)
                VALUES
                (:nombre, :desc_corta, :desc_larga,
                 :metros_cubiertos, :metros_galeria,
                 :sistema_default,
                 :precio_desde, :precio_lista,
                 :imagen_portada, :activo, :orden,
                 NOW())
            ");

            $stmt->execute([
                ':nombre'          => $data['nombre'],
                ':desc_corta'      => $data['descripcion_corta'],
                ':desc_larga'      => $data['descripcion_larga'],
                ':metros_cubiertos'=> $data['metros_cubiertos'] !== '' ? $data['metros_cubiertos'] : null,
                ':metros_galeria'  => $data['metros_galeria']   !== '' ? $data['metros_galeria']   : null,
                ':sistema_default' => $data['sistema_default'],
                ':precio_desde'    => $data['precio_desde']     !== '' ? $data['precio_desde']     : null,
                ':precio_lista'    => $data['precio_lista']     !== '' ? $data['precio_lista']     : null,
                ':imagen_portada'  => $imgPath,
                ':activo'          => (int)$data['activo'],
                ':orden'           => (int)$data['orden'],
            ]);

            $ok = true;

        } catch (PDOException $e) {
            // Acá estaba el 500: ahora lo mostramos como error amigable
            $errores[] = 'Error al guardar el modelo: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Nuevo modelo - Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-4">
    <h3>Nuevo modelo</h3>

    <?php if ($ok): ?>
        <div class="alert alert-success">Modelo creado correctamente.</div>
        <a href="modelos_listar.php" class="btn btn-primary">Volver</a>
    <?php else: ?>

        <?php if (!empty($errores)): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php foreach ($errores as $e): ?>
                        <li><?php echo h($e); ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data" class="row g-3">

            <div class="col-md-6">
                <label class="form-label">Nombre *</label>
                <input type="text" name="nombre" class="form-control" required value="<?php echo h($data['nombre']); ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">Imagen portada</label>
                <input type="file" name="imagen" class="form-control">
            </div>

            <div class="col-12">
                <label class="form-label">Descripción corta</label>
                <input type="text" name="descripcion_corta" class="form-control"
                       value="<?php echo h($data['descripcion_corta']); ?>">
            </div>

            <div class="col-12">
                <label class="form-label">Descripción larga</label>
                <textarea name="descripcion_larga" class="form-control" rows="4"><?php echo h($data['descripcion_larga']); ?></textarea>
            </div>

            <div class="col-md-4">
                <label class="form-label">Metros cubiertos *</label>
                <input type="number" step="0.01" name="metros_cubiertos" class="form-control" required
                       value="<?php echo h($data['metros_cubiertos']); ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">Metros galería</label>
                <input type="number" step="0.01" name="metros_galeria" class="form-control"
                       value="<?php echo h($data['metros_galeria']); ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">Sistema por defecto *</label>
                <select name="sistema_default" class="form-select">
                    <option value="estructura" <?php echo $data['sistema_default']==='estructura'?'selected':''; ?>>Estructura</option>
                    <option value="estructura_plataforma" <?php echo $data['sistema_default']==='estructura_plataforma'?'selected':''; ?>>Estructura + Plataforma</option>
                    <option value="llave_en_mano" <?php echo $data['sistema_default']==='llave_en_mano'?'selected':''; ?>>Llave en mano</option>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">Precio desde *</label>
                <input type="number" step="0.01" name="precio_desde" class="form-control" required
                       value="<?php echo h($data['precio_desde']); ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">Precio lista *</label>
                <input type="number" step="0.01" name="precio_lista" class="form-control" required
                       value="<?php echo h($data['precio_lista']); ?>">
            </div>

            <div class="col-md-2">
                <label class="form-label">Activo</label>
                <select name="activo" class="form-select">
                    <option value="1" <?php echo $data['activo']==1?'selected':''; ?>>Sí</option>
                    <option value="0" <?php echo $data['activo']==0?'selected':''; ?>>No</option>
                </select>
            </div>

            <div class="col-md-2">
                <label class="form-label">Orden</label>
                <input type="number" name="orden" class="form-control" value="<?php echo h($data['orden']); ?>">
            </div>

            <div class="col-12">
                <button class="btn btn-success" type="submit">Guardar</button>
                <a href="modelos_listar.php" class="btn btn-secondary">Cancelar</a>
            </div>
        </form>

    <?php endif; ?>
</div>

</body>
</html>
