<?php
// admin/panel.php
@session_start();
if (empty($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../db.php';
$pdo = pdo();

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// Contadores rápidos
$clientes_total     = $pdo->query("SELECT COUNT(*) FROM clientes")->fetchColumn();
$operaciones_total  = $pdo->query("SELECT COUNT(*) FROM operaciones")->fetchColumn();
$pagos_total        = $pdo->query("SELECT COUNT(*) FROM pagos")->fetchColumn();

// Operaciones recientes para los select (id + cliente)
$operaciones_recientes = [];
try {
    $stmtOps = $pdo->query("
        SELECT 
            o.id,
            c.nombre,
            c.apellido
        FROM operaciones o
        LEFT JOIN clientes c ON c.id = o.cliente_id
        ORDER BY o.id DESC
        LIMIT 30
    ");
    $operaciones_recientes = $stmtOps->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    // si falla la consulta, dejamos la lista vacía
    $operaciones_recientes = [];
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel - Cabañas Santiago</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons (opcional) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        body {
            background: #f5f6fa;
        }
        .card-stat {
            border: none;
            border-radius: .75rem;
        }
        .card-stat .icon-round {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background: rgba(13,110,253,.1);
            margin-bottom: .5rem;
        }
        .quick-card {
            border-radius: .75rem;
            transition: transform .1s ease, box-shadow .1s ease;
        }
        .quick-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 .5rem 1rem rgba(0,0,0,.08);
        }
        .quick-card .btn {
            width: 100%;
        }
        .section-title {
            font-weight: 600;
            margin: 2rem 0 1rem;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <span class="navbar-brand">Cabañas Santiago - Admin</span>
        <div class="d-flex">
            <span class="navbar-text me-3">
                <?php echo h($_SESSION['admin_usuario']); ?>
                (<?php echo h($_SESSION['admin_rol']); ?>)
            </span>
            <a class="btn btn-outline-light btn-sm" href="logout.php">Salir</a>
        </div>
    </div>
</nav>

<div class="container py-4">
    <h3 class="mb-3">Panel principal</h3>
    <p class="text-muted mb-4">Desde aquí podés acceder rápido a todas las secciones de gestión del sistema.</p>

    <!-- Stats -->
    <div class="row g-3">
        <div class="col-md-4">
            <div class="card card-stat shadow-sm h-100">
                <div class="card-body">
                    <div class="icon-round text-primary">
                        <i class="fa-solid fa-users"></i>
                    </div>
                    <h6 class="text-muted text-uppercase mb-1">Clientes</h6>
                    <h3 class="mb-0"><?php echo (int)$clientes_total; ?></h3>
                    <small class="text-muted">Registrados en el sistema</small>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card card-stat shadow-sm h-100">
                <div class="card-body">
                    <div class="icon-round text-success">
                        <i class="fa-solid fa-file-signature"></i>
                    </div>
                    <h6 class="text-muted text-uppercase mb-1">Operaciones</h6>
                    <h3 class="mb-0"><?php echo (int)$operaciones_total; ?></h3>
                    <small class="text-muted">Ventas / contratos cargados</small>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card card-stat shadow-sm h-100">
                <div class="card-body">
                    <div class="icon-round text-warning">
                        <i class="fa-solid fa-money-bill-wave"></i>
                    </div>
                    <h6 class="text-muted text-uppercase mb-1">Pagos registrados</h6>
                    <h3 class="mb-0"><?php echo (int)$pagos_total; ?></h3>
                    <small class="text-muted">Cuotas, señas, etc.</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Gestión de clientes -->
    <h5 class="section-title">Gestión de clientes</h5>
    <div class="row g-3">
        <div class="col-md-3 col-sm-6">
            <div class="card quick-card shadow-sm h-100">
                <div class="card-body d-flex flex-column">
                    <h6 class="mb-2"><i class="fa-solid fa-users me-2"></i>Clientes</h6>
                    <p class="text-muted small flex-grow-1 mb-3">Listado general de clientes.</p>
                    <a href="clientes.php" class="btn btn-outline-primary btn-sm">Ver clientes</a>
                </div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="card quick-card shadow-sm h-100">
                <div class="card-body d-flex flex-column">
                    <h6 class="mb-2"><i class="fa-solid fa-user-plus me-2"></i>Nuevo cliente</h6>
                    <p class="text-muted small flex-grow-1 mb-3">Cargar un cliente al sistema.</p>
                    <a href="cliente_form.php" class="btn btn-primary btn-sm">Crear cliente</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Modelos -->
    <h5 class="section-title">Modelos de casas</h5>
    <div class="row g-3">
        <div class="col-md-3 col-sm-6">
            <div class="card quick-card shadow-sm h-100">
                <div class="card-body d-flex flex-column">
                    <h6 class="mb-2"><i class="fa-solid fa-house-chimney me-2"></i>Modelos</h6>
                    <p class="text-muted small flex-grow-1 mb-3">Listado de modelos cargados.</p>
                    <a href="modelos_listar.php" class="btn btn-outline-primary btn-sm">Ver modelos</a>
                </div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="card quick-card shadow-sm h-100">
                <div class="card-body d-flex flex-column">
                    <h6 class="mb-2"><i class="fa-solid fa-plus me-2"></i>Nuevo modelo</h6>
                    <p class="text-muted small flex-grow-1 mb-3">Crear un nuevo modelo de casa.</p>
                    <a href="modelos_nuevo.php" class="btn btn-primary btn-sm">Crear modelo</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Operaciones y simulaciones -->
    <h5 class="section-title">Operaciones y simulaciones</h5>
    <div class="row g-3">
        <div class="col-md-3 col-sm-6">
            <div class="card quick-card shadow-sm h-100">
                <div class="card-body d-flex flex-column">
                    <h6 class="mb-2"><i class="fa-solid fa-file-circle-check me-2"></i>Operaciones</h6>
                    <p class="text-muted small flex-grow-1 mb-3">Listado de operaciones/ventas.</p>
                    <a href="operaciones.php" class="btn btn-outline-primary btn-sm">Ver operaciones</a>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="card quick-card shadow-sm h-100">
                <div class="card-body d-flex flex-column">
                    <h6 class="mb-2"><i class="fa-solid fa-file-circle-plus me-2"></i>Nueva operación</h6>
                    <p class="text-muted small flex-grow-1 mb-3">Cargar una operación directa.</p>
                    <a href="operacion_form.php" class="btn btn-primary btn-sm">Cargar operación</a>
                </div>
            </div>
        </div>

        <!-- Ir directo a una operación por ID -->
        <div class="col-md-6">
            <div class="card quick-card shadow-sm h-100">
                <div class="card-body">
                    <h6 class="mb-2"><i class="fa-solid fa-magnifying-glass me-2"></i>Ir directo a una operación</h6>
                    <p class="text-muted small">
                        Elegí una operación de la lista o escribí el ID para abrirla en el formulario.
                    </p>

                    <?php if (!empty($operaciones_recientes)): ?>
                        <div class="row g-2">
                            <div class="col-md-7">
                                <form method="get" action="operacion_form.php">
                                    <label class="form-label small mb-1">Operaciones recientes</label>
                                    <select name="id" class="form-select form-select-sm mb-2" required>
                                        <option value="">Seleccionar...</option>
                                        <?php foreach ($operaciones_recientes as $op): ?>
                                            <option value="<?php echo (int)$op['id']; ?>">
                                                #<?php echo (int)$op['id']; ?> —
                                                <?php echo h(trim(($op['apellido'] ?? '') . ' ' . ($op['nombre'] ?? ''))); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <button class="btn btn-outline-primary btn-sm w-100">Abrir operación</button>
                                </form>
                            </div>
                            <div class="col-md-5">
                                <form method="get" action="operacion_form.php">
                                    <label class="form-label small mb-1">Buscar por ID</label>
                                    <div class="input-group input-group-sm mb-2">
                                        <span class="input-group-text">#</span>
                                        <input type="number" min="1" name="id" class="form-control" required>
                                    </div>
                                    <button class="btn btn-primary btn-sm w-100">Ir</button>
                                </form>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-light small mb-0">
                            Aún no hay operaciones cargadas para buscar por ID.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Simulaciones -->
    <div class="row g-3 mt-1">
        <div class="col-md-3 col-sm-6">
            <div class="card quick-card shadow-sm h-100">
                <div class="card-body d-flex flex-column">
                    <h6 class="mb-2"><i class="fa-solid fa-calculator me-2"></i>Simulaciones</h6>
                    <p class="text-muted small flex-grow-1 mb-3">Listado de simulaciones realizadas.</p>
                    <a href="simulaciones_listar.php" class="btn btn-outline-primary btn-sm">Ver simulaciones</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Pagos -->
    <h5 class="section-title">Pagos</h5>
    <div class="row g-3">
        <div class="col-md-6 col-lg-5">
            <div class="card quick-card shadow-sm h-100">
                <div class="card-body">
                    <h6 class="mb-2"><i class="fa-solid fa-money-check-dollar me-2"></i>Pagos por operación</h6>
                    <p class="text-muted small">
                        Seleccioná la operación a la que querés cargar o consultar pagos.
                    </p>

                    <?php if (!empty($operaciones_recientes)): ?>
                        <div class="row g-2">
                            <div class="col-md-7">
                                <form method="get" action="pagos.php">
                                    <label class="form-label small mb-1">Operaciones recientes</label>
                                    <select name="operacion_id" class="form-select form-select-sm mb-2" required>
                                        <option value="">Seleccionar...</option>
                                        <?php foreach ($operaciones_recientes as $op): ?>
                                            <option value="<?php echo (int)$op['id']; ?>">
                                                #<?php echo (int)$op['id']; ?> —
                                                <?php echo h(trim(($op['apellido'] ?? '') . ' ' . ($op['nombre'] ?? ''))); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <button class="btn btn-outline-primary btn-sm w-100">Ir a pagos</button>
                                </form>
                            </div>
                            <div class="col-md-5">
                                <form method="get" action="pagos.php">
                                    <label class="form-label small mb-1">Buscar por ID</label>
                                    <div class="input-group input-group-sm mb-2">
                                        <span class="input-group-text">#</span>
                                        <input type="number" min="1" name="operacion_id" class="form-control" required>
                                    </div>
                                    <button class="btn btn-primary btn-sm w-100">Ir</button>
                                </form>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-light small mb-0">
                            Aún no hay operaciones cargadas para vincular pagos.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Herramientas del sistema -->
    <h5 class="section-title text-danger">Herramientas del sistema</h5>
    <div class="row g-3 mb-4">
        <div class="col-md-4 col-sm-6">
            <div class="card quick-card border-danger shadow-sm h-100">
                <div class="card-body d-flex flex-column">
                    <h6 class="mb-2 text-danger">
                        <i class="fa-solid fa-triangle-exclamation me-2"></i>
                        Resetear sistema
                    </h6>
                    <p class="text-muted small flex-grow-1 mb-3">
                        Elimina los datos cargados (operaciones, pagos, etc.) manteniendo usuarios.
                        Usar con extrema precaución.
                    </p>
                    <a href="reset_sistema.php"
                       class="btn btn-danger btn-sm"
                       onclick="return confirm('¿Seguro que querés resetear el sistema? Esta acción no se puede deshacer.');">
                        Ejecutar reset
                    </a>
                </div>
            </div>
        </div>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
