<?php
// admin/reset_sistema.php
@session_start();

// Ajustá esto si tu sesión usa otra clave
if (empty($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../db.php';
$pdo = pdo();

$mensaje = '';
$error   = '';

// ⚠️ Tablas que se van a vaciar (TRUNCATE)
$tablas_a_resetear = [
    'modelos_archivos',
    'modelos_casas',
    'operaciones',
    'operaciones_cuotas',
    'pagos',
    'pagos_solicitados',
    'simulaciones_detalle',
    'simulaciones_operacion',
];

// Procesar envío del formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $confirm = isset($_POST['confirm_text']) ? trim($_POST['confirm_text']) : '';

    if ($confirm !== 'RESET') {
        $error = 'Tenés que escribir exactamente la palabra RESET para confirmar.';
    } else {
        try {
            $pdo->beginTransaction();

            // Desactivar claves foráneas (MySQL/MariaDB)
            $pdo->exec("SET FOREIGN_KEY_CHECKS=0");

            foreach ($tablas_a_resetear as $tabla) {
                $tabla = trim($tabla);
                if ($tabla === '') continue;
                $pdo->exec("TRUNCATE TABLE `$tabla`");
            }

            // Volver a activar claves foráneas
            $pdo->exec("SET FOREIGN_KEY_CHECKS=1");

            $pdo->commit();
            $mensaje = '✅ El sistema fue reseteado correctamente. Se vaciaron todas las tablas configuradas.';
        } catch (Exception $e) {
            $pdo->rollBack();
            $error = '❌ Error al resetear el sistema: ' . $e->getMessage();
        }
    }
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Resetear sistema</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background:#f5f5f5;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }
        .card-reset {
            max-width: 600px;
            margin: 40px auto;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.08);
        }
    </style>
</head>
<body>
<div class="container">
    <div class="card card-reset">
        <div class="card-header bg-danger text-white">
            <h5 class="mb-0">⚠ Resetear sistema</h5>
        </div>
        <div class="card-body">
            <p>
                Esta acción <strong>ELIMINARÁ TODOS LOS DATOS</strong> de las siguientes tablas:
            </p>
            <ul>
                <?php foreach ($tablas_a_resetear as $t): ?>
                    <li><code><?= htmlspecialchars($t, ENT_QUOTES, 'UTF-8') ?></code></li>
                <?php endforeach; ?>
            </ul>

            <p class="text-danger mb-3">
                Los usuarios de acceso al sistema no se tocan (no están en la lista de tablas a resetear).
            </p>

            <?php if ($mensaje): ?>
                <div class="alert alert-success"><?= htmlspecialchars($mensaje, ENT_QUOTES, 'UTF-8') ?></div>
            <?php endif; ?>

            <?php if ($error): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></div>
            <?php endif; ?>

            <form method="post" onsubmit="return confirm('¿Seguro que querés resetear el sistema? Esta acción NO se puede deshacer.');">
                <div class="mb-3">
                    <label class="form-label fw-semibold">
                        Para confirmar, escribí <code>RESET</code> en el cuadro:
                    </label>
                    <input type="text" name="confirm_text" class="form-control" autocomplete="off" required>
                </div>

                <button type="submit" class="btn btn-danger">
                    🧨 Resetear sistema
                </button>
                <a href="index.php" class="btn btn-secondary ms-2">
                    ⬅ Volver al panel
                </a>
            </form>
        </div>
    </div>
</div>
</body>
</html>
