<?php
@session_start();
require_once '../db.php';
$pdo = pdo();

/*
  Listado de simulaciones enviadas desde simular.php
*/

$estado = isset($_GET['estado']) ? trim($_GET['estado']) : 'pendiente';
if (!in_array($estado, ['pendiente', 'todas'], true)) {
    $estado = 'pendiente';
}

$sql = "
    SELECT 
        s.*,
        c.nombre AS cli_nombre,
        c.apellido AS cli_apellido,
        c.dni AS cli_dni
    FROM simulaciones_operacion s
    LEFT JOIN clientes c ON c.id = s.cliente_id
";
$params = [];

if ($estado !== 'todas') {
    $sql .= " WHERE s.estado = :estado ";
    $params[':estado'] = $estado;
}

$sql .= " ORDER BY s.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$simulaciones = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Simulaciones de operaciones - Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{font-family:system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;}
        .badge-estado{font-size:.8rem;}
    </style>
</head>
<body class="bg-light">

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Simulaciones de operaciones</h3>
        <a href="modelos_listar.php" class="btn btn-outline-secondary btn-sm">Volver a modelos</a>
    </div>

    <form class="mb-3">
        <div class="row g-2 align-items-center">
            <div class="col-auto">
                <label class="col-form-label">Mostrar:</label>
            </div>
            <div class="col-auto">
                <select name="estado" class="form-select form-select-sm" onchange="this.form.submit()">
                    <option value="pendiente" <?php echo $estado==='pendiente'?'selected':''; ?>>Sólo pendientes</option>
                    <option value="todas" <?php echo $estado==='todas'?'selected':''; ?>>Todas</option>
                </select>
            </div>
        </div>
    </form>

    <?php if (empty($simulaciones)): ?>
        <div class="alert alert-info">
            No hay simulaciones para mostrar.
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-sm table-hover align-middle bg-white">
                <thead class="table-light">
                    <tr>
                        <th>Fecha</th>
                        <th>Cliente</th>
                        <th>DNI</th>
                        <th>Modelo</th>
                        <th>Forma deseada</th>
                        <th>Cuotas deseadas</th>
                        <th>Estado</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($simulaciones as $s): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($s['created_at']); ?></td>
                        <td><?php echo htmlspecialchars(trim(($s['cli_nombre'] ?? '').' '.($s['cli_apellido'] ?? ''))); ?></td>
                        <td><?php echo htmlspecialchars($s['cli_dni'] ?? ''); ?></td>
                        <td><?php echo htmlspecialchars($s['modelo']); ?></td>
                        <td><?php echo htmlspecialchars($s['forma_venta_deseada']); ?></td>
                        <td><?php echo (int)$s['cuotas_deseadas']; ?></td>
                        <td>
                            <span class="badge bg-secondary badge-estado">
                                <?php echo htmlspecialchars($s['estado']); ?>
                            </span>
                        </td>
                        <td class="text-end">
                            <a href="simulaciones_ver.php?id=<?php echo (int)$s['id']; ?>" 
                               class="btn btn-sm btn-primary">
                                Ver / convertir
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

</body>
</html>
