<?php
// admin/cliente_form.php
@session_start();
if (empty($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../db.php';
$pdo = pdo();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$es_edicion = $id > 0;

$errores = [];
$ok = false;

// Valores por defecto
$cliente = [
    'nombre'        => '',
    'apellido'      => '',
    'dni'           => '',
    'email'         => '',
    'telefono'      => '',
    'direccion'     => '',
    'localidad'     => '',
    'provincia'     => '',
    'codigo_acceso' => '',
    'estado'        => 'activo',
];

// Si es edición, cargar datos
if ($es_edicion) {
    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => $id]);
    $row = $stmt->fetch();
    if (!$row) {
        die('Cliente no encontrado.');
    }
    $cliente = array_merge($cliente, $row);
}

// Procesar POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cliente['nombre']        = trim($_POST['nombre'] ?? '');
    $cliente['apellido']      = trim($_POST['apellido'] ?? '');
    $cliente['dni']           = trim($_POST['dni'] ?? '');
    $cliente['email']         = trim($_POST['email'] ?? '');
    $cliente['telefono']      = trim($_POST['telefono'] ?? '');
    $cliente['direccion']     = trim($_POST['direccion'] ?? '');
    $cliente['localidad']     = trim($_POST['localidad'] ?? '');
    $cliente['provincia']     = trim($_POST['provincia'] ?? '');
    $cliente['codigo_acceso'] = trim($_POST['codigo_acceso'] ?? '');
    $cliente['estado']        = $_POST['estado'] ?? 'activo';

    if ($cliente['nombre'] === '') {
        $errores[] = 'El nombre es obligatorio.';
    }
    if ($cliente['apellido'] === '') {
        $errores[] = 'El apellido es obligatorio.';
    }
    if ($cliente['dni'] === '') {
        $errores[] = 'El DNI es obligatorio.';
    }

    if (empty($errores)) {
        try {
            if ($es_edicion) {
                $sql = "
                    UPDATE clientes
                    SET nombre = :nombre,
                        apellido = :apellido,
                        dni = :dni,
                        email = :email,
                        telefono = :telefono,
                        direccion = :direccion,
                        localidad = :localidad,
                        provincia = :provincia,
                        codigo_acceso = :codigo_acceso,
                        estado = :estado
                    WHERE id = :id
                ";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    ':nombre'        => $cliente['nombre'],
                    ':apellido'      => $cliente['apellido'],
                    ':dni'           => $cliente['dni'],
                    ':email'         => $cliente['email'],
                    ':telefono'      => $cliente['telefono'],
                    ':direccion'     => $cliente['direccion'],
                    ':localidad'     => $cliente['localidad'],
                    ':provincia'     => $cliente['provincia'],
                    ':codigo_acceso' => $cliente['codigo_acceso'] ?: null,
                    ':estado'        => $cliente['estado'],
                    ':id'            => $id,
                ]);
            } else {
                $sql = "
                    INSERT INTO clientes
                      (nombre, apellido, dni, email, telefono, direccion,
                       localidad, provincia, codigo_acceso, estado, created_at)
                    VALUES
                      (:nombre, :apellido, :dni, :email, :telefono, :direccion,
                       :localidad, :provincia, :codigo_acceso, :estado, NOW())
                ";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    ':nombre'        => $cliente['nombre'],
                    ':apellido'      => $cliente['apellido'],
                    ':dni'           => $cliente['dni'],
                    ':email'         => $cliente['email'],
                    ':telefono'      => $cliente['telefono'],
                    ':direccion'     => $cliente['direccion'],
                    ':localidad'     => $cliente['localidad'],
                    ':provincia'     => $cliente['provincia'],
                    ':codigo_acceso' => $cliente['codigo_acceso'] ?: null,
                    ':estado'        => $cliente['estado'],
                ]);
                $id = (int)$pdo->lastInsertId();
                $es_edicion = true;
            }

            header('Location: clientes.php');
            exit;
        } catch (PDOException $e) {
            // error por constraints (dni/codigo duplicados, etc.)
            $errores[] = 'Error al guardar el cliente: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title><?php echo $es_edicion ? 'Editar' : 'Nuevo'; ?> cliente - Cabañas Santiago</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a class="navbar-brand" href="panel.php">Cabañas Santiago - Admin</a>
        <div class="d-flex">
            <a class="btn btn-outline-light btn-sm me-2" href="clientes.php">Clientes</a>
            <a class="btn btn-outline-light btn-sm" href="logout.php">Salir</a>
        </div>
    </div>
</nav>

<div class="container py-4">
    <h3 class="mb-3">
        <?php echo $es_edicion ? 'Editar cliente' : 'Nuevo cliente'; ?>
    </h3>

    <?php if (!empty($errores)): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php foreach ($errores as $e): ?>
                    <li><?php echo htmlspecialchars($e); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="post" class="row g-3">
        <div class="col-md-6">
            <label class="form-label">Nombre *</label>
            <input type="text" name="nombre" class="form-control"
                   value="<?php echo htmlspecialchars($cliente['nombre']); ?>" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">Apellido *</label>
            <input type="text" name="apellido" class="form-control"
                   value="<?php echo htmlspecialchars($cliente['apellido']); ?>" required>
        </div>

        <div class="col-md-4">
            <label class="form-label">DNI *</label>
            <input type="text" name="dni" class="form-control"
                   value="<?php echo htmlspecialchars($cliente['dni']); ?>" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">Código de acceso (opcional)</label>
            <input type="text" name="codigo_acceso" class="form-control"
                   value="<?php echo htmlspecialchars($cliente['codigo_acceso']); ?>">
            <small class="text-muted">Para login de cliente además del DNI (ej: CS-000123).</small>
        </div>
        <div class="col-md-4">
            <label class="form-label">Estado</label>
            <select name="estado" class="form-select">
                <option value="activo" <?php echo $cliente['estado'] === 'activo' ? 'selected' : ''; ?>>
                    Activo
                </option>
                <option value="inactivo" <?php echo $cliente['estado'] === 'inactivo' ? 'selected' : ''; ?>>
                    Inactivo
                </option>
            </select>
        </div>

        <div class="col-md-6">
            <label class="form-label">Email</label>
            <input type="email" name="email" class="form-control"
                   value="<?php echo htmlspecialchars($cliente['email']); ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label">Teléfono</label>
            <input type="text" name="telefono" class="form-control"
                   value="<?php echo htmlspecialchars($cliente['telefono']); ?>">
        </div>

        <div class="col-md-12">
            <label class="form-label">Dirección</label>
            <input type="text" name="direccion" class="form-control"
                   value="<?php echo htmlspecialchars($cliente['direccion']); ?>">
        </div>

        <div class="col-md-6">
            <label class="form-label">Localidad</label>
            <input type="text" name="localidad" class="form-control"
                   value="<?php echo htmlspecialchars($cliente['localidad']); ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label">Provincia</label>
            <input type="text" name="provincia" class="form-control"
                   value="<?php echo htmlspecialchars($cliente['provincia']); ?>">
        </div>

        <div class="col-12 d-flex justify-content-between mt-3">
            <a href="clientes.php" class="btn btn-secondary">Volver</a>
            <button type="submit" class="btn btn-primary">
                Guardar
            </button>
        </div>
    </form>
</div>
</body>
</html>
