<?php
@session_start();
require_once '../db.php';
$pdo = pdo();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    die("ID inválido");
}

$stmt = $pdo->prepare("SELECT imagen_portada FROM modelos_casas WHERE id = :id");
$stmt->execute([':id' => $id]);
$m = $stmt->fetch();

if ($m) {
    // Borrar imagen
    if (!empty($m['imagen_portada'])) {
        $path = __DIR__ . '/' . $m['imagen_portada'];
        if (file_exists($path)) {
            unlink($path);
        }
    }

    // Borrar registro
    $pdo->prepare("DELETE FROM modelos_casas WHERE id = :id")
        ->execute([':id' => $id]);
}

header("Location: modelos_listar.php");
exit;
