file_put_contents(__DIR__.'/llegue.txt', date('[d-m H:i:s] LLEGÓ').PHP_EOL, FILE_APPEND);
<?php
// ---------------------------------------------
//  guardar_cobro_sala.php
//  (Reemplazar TODO el archivo con este contenido)
// ---------------------------------------------
ini_set('display_errors',1);
error_reporting(E_ALL);

require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// ---------- INPUT ----------
$sala_id       = intval($_POST['sala_id'] ?? 0);
$monto         = floatval($_POST['monto'] ?? 0);
$cliente       = trim($_POST['cliente'] ?? '');
$forma_pago    = $_POST['forma_pago'] ?? '';
$efectivo      = floatval($_POST['efectivo'] ?? 0);
$transferencia = floatval($_POST['transferencia'] ?? 0);

$hora_inicio = trim($_POST['hora_inicio'] ?? '');
$hora_fin    = trim($_POST['hora_fin'] ?? '');
$duracion    = intval($_POST['duracion'] ?? 0);
$precio_sala = floatval($_POST['precio_sala'] ?? 0);
$descuento   = floatval($_POST['descuento'] ?? 0);

$productos   = json_decode($_POST['productos_json'] ?? '[]', true);
$alquileres  = json_decode($_POST['alquileres'] ?? '[]', true);

// ---------- VALIDACIÓN ----------
if ($sala_id <= 0 || $monto <= 0 || !in_array($forma_pago, ['efectivo','transferencia','dividido'])) {
  echo json_encode(['error'=>'Datos inválidos']); exit;
}

// ---------- JSON DETALLE ----------
$detalles_json = json_encode([
  'hora_inicio'=>$hora_inicio,
  'hora_fin'   =>$hora_fin,
  'duracion'   =>$duracion,
  'precio_sala'=>$precio_sala,
  'productos'  =>$productos,
  'alquileres' =>$alquileres,
  'descuento'  =>$descuento
], JSON_UNESCAPED_UNICODE);

// ---------- INSERT ----------
$fecha = date('Y-m-d');
$hora  = date('H:i:s');

$stmt = $con->prepare(
  "INSERT INTO caja_sala
    (sala_id, fecha, hora,
     total, efectivo, transferencia,
     forma_pago, cliente,
     comentario, ticket_html, detalles_json)
   VALUES (?,?,?,?,?,?,?,?,?,?,?)"
);

$comentario = '';
$ticket_html = null;

$stmt->bind_param(
  'issdddsssss',
  $sala_id, $fecha, $hora,
  $monto, $efectivo, $transferencia,
  $forma_pago, $cliente,
  $comentario, $ticket_html, $detalles_json
);

if(!$stmt->execute()){
  echo json_encode(['error'=>$stmt->error]); exit;
}

$ticket_id = $stmt->insert_id;
$stmt->close();

// ---------- RESPUESTA ----------
echo json_encode(['success'=>true,'ticket_id'=>$ticket_id]);
?>
