<?php
/**
 * mapa_mesas_vertical.php – versión solo‑vista 04‑Ago‑2025
 * --------------------------------------------------------
 * ▸ Muestra SIEMPRE las 10 mesas (ID 1‑10) en las posiciones guardadas
 * ▸ No permite mover (sólo visualizar).
 * ▸ Si faltan filas las inserta automáticamente.
 * ▸ Al hacer clic abre el iframe de la mesa correspondiente.
 */

session_start();
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// Config
const TOT_MESAS = 10;
const IFRAME_H  = 420;
const MAP_H     = 300;
const MESA_SZ   = 32;

/* ---------- Garantizar columnas ---------- */
function ensure($con,$col,$sql){
  if(!mysqli_num_rows($con->query("SHOW COLUMNS FROM mesas LIKE '$col'")))
      $con->query($sql);
}
ensure($con,'pos_x', "ALTER TABLE mesas ADD COLUMN pos_x INT UNSIGNED NOT NULL DEFAULT 0");
ensure($con,'pos_y', "ALTER TABLE mesas ADD COLUMN pos_y INT UNSIGNED NOT NULL DEFAULT 0");
ensure($con,'placed',"ALTER TABLE mesas ADD COLUMN placed TINYINT(1) NOT NULL DEFAULT 0");

/* ---------- Garantizar 10 filas ---------- */
for($i=1;$i<=TOT_MESAS;$i++){
  $con->query("INSERT IGNORE INTO mesas (id,nombre,placed) VALUES ($i,'Mesa $i',1)");
}

/* ---------- Datos ---------- */
$mesas = $con->query("SELECT id,nombre,pos_x,pos_y FROM mesas WHERE placed = 1 ORDER BY id")
            ->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="es"><head><meta charset="utf-8">
<title>Mapa Mesas</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<style>
:root{
  --mesa: <?=MESA_SZ?>px;
  --bg-map: #415993;
}
html,body{margin:0;height:100%;overflow:hidden;background:#000;}
#wrap{display:flex;flex-direction:column;height:<?=IFRAME_H?>px;background:#fff;
      border:1px solid #cdd5e0;border-radius:8px;overflow:hidden;
      box-shadow:0 2px 8px rgba(0,0,0,.15);}
#mapa{height:<?=MAP_H?>px;background:var(--bg-map);position:relative;overflow:hidden;}
.mesa{width:var(--mesa);height:var(--mesa);background:#1976d2;border-radius:6px;
      color:#fff;font-weight:bold;font-size:13px;
      display:flex;align-items:center;justify-content:center;
      position:absolute;cursor:pointer;user-select:none;
      box-shadow:0 2px 4px rgba(0,0,0,.3);
      transition:transform .12s,background-color .2s;}
.mesa:hover{background:#1565c0;transform:scale(1.08);}
</style>
</head><body>
<div id="wrap">
  <div id="mapa">
    <?php foreach($mesas as $m): ?>
      <div class="mesa" data-id="<?=$m['id']?>"
           style="left:<?=$m['pos_x']?>px;top:<?=$m['pos_y']?>px;">
        <?=htmlspecialchars($m['nombre'])?>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="modalMesa" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content bg-dark text-white">
      <div class="modal-header border-0">
        <h5 class="modal-title">Mesa <span id="modalNum"></span></h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body p-0">
        <iframe id="modalIframe" style="width:100%;height:70vh;border:0;"></iframe>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('click',function(e){
  const target = e.target.closest('.mesa');
  if(!target) return;
  const id = target.dataset.id;
  document.getElementById('modalNum').textContent = id;
  document.getElementById('modalIframe').src = `mesa_${id}.php?embed=1&ts=${Date.now()}`;
  bootstrap.Modal.getOrCreateInstance('#modalMesa').show();
});
</script>
</body></html>