<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// Tablas a vaciar completamente
$tablas = [
  'caja_mesa',
  'caja_sala',
  'comandas',
  'comandas_cocina',
  'comentarios_mesa',
  'estado_mesa_temp',
  'estado_sala_temp',
  'sesiones_usuarios',
  'tickets_mesa',
  'tickets_mesa_detalle'
];

mysqli_query($con, "SET FOREIGN_KEY_CHECKS = 0");

// Truncar tablas
foreach ($tablas as $tabla) {
  $check = mysqli_query($con, "SHOW TABLES LIKE '$tabla'");
  if (mysqli_num_rows($check)) {
    if (mysqli_query($con, "TRUNCATE TABLE `$tabla`")) {
      echo "✅ `$tabla` vaciada.<br>";
    } else {
      echo "⚠️ Error al vaciar `$tabla`: " . mysqli_error($con) . "<br>";
    }
  } else {
    echo "❌ Tabla `$tabla` no existe, omitida.<br>";
  }
}

// Reiniciar campos en productos_mesas
if (mysqli_query($con, "UPDATE productos_mesas SET stock = 0, usados = 0, enviado_cocina = 0")) {
  echo "✅ productos_mesas reiniciados (stock, usados, enviado_cocina).<br>";
} else {
  echo "⚠️ Error en productos_mesas: " . mysqli_error($con) . "<br>";
}

// Reiniciar campos en productos
if (mysqli_query($con, "UPDATE productos SET stock = 0, usados = 0, enviado_cocina = 0")) {
  echo "✅ productos reiniciados (stock, usados, enviado_cocina).<br>";
} else {
  echo "⚠️ Error en productos: " . mysqli_error($con) . "<br>";
}

mysqli_query($con, "SET FOREIGN_KEY_CHECKS = 1");

echo "<hr><strong>✔️ Reset completo. Todo limpio.</strong>";
?>
