<?php
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$id = intval($_GET['id'] ?? 0);
$autoPrint = isset($_GET['print']);

if ($id <= 0) {
  echo "❌ ID inválido.";
  exit;
}

/**
 * Intenta obtener el ticket desde caja_mesa (nuevo esquema con detalles_json).
 * Si no existe, intenta desde tickets_mesa (esquema legacy).
 */
$ticket = null;
$desde  = ''; // indica desde qué tabla se extrajo

// ---------- 1) Buscar en caja_mesa ----------
$sql = "SELECT * FROM caja_mesa WHERE id = $id LIMIT 1";
if ($res = mysqli_query($con, $sql)) {
  if (mysqli_num_rows($res) > 0) {
    $ticket = mysqli_fetch_assoc($res);
    $ticket['detalles_json'] = $ticket['detalles_json'] ?? '{}';
    $desde  = 'caja';
  }
  mysqli_free_result($res);
}

// ---------- 2) Buscar en tickets_mesa ----------
if (!$ticket) {
  $sql = "SELECT * FROM tickets_mesa WHERE id = $id LIMIT 1";
  if ($res = mysqli_query($con, $sql)) {
    if (mysqli_num_rows($res) > 0) {
      $ticket = mysqli_fetch_assoc($res);
      $desde  = 'tickets';
    }
    mysqli_free_result($res);
  }
}

if (!$ticket) {
  echo "❌ Ticket no encontrado.";
  exit;
}

// ---------- Procesar detalle de productos ----------
$productos = [];
$descuento = 0;

if ($desde === 'caja') {
  $detalles = json_decode($ticket['detalles_json'] ?? '{}', true);
  $productos = $detalles['productos'] ?? [];
  $descuento = floatval($detalles['descuento'] ?? 0);

  // Completar nombre/cantidad si faltan
  foreach ($productos as &$prod) {
    if (empty($prod['nombre'])) {
      $pid = intval($prod['id'] ?? 0);
      if ($pid > 0) {
        $nameRes = mysqli_query($con, "SELECT nombre FROM productos_mesas WHERE id = $pid LIMIT 1");
        if ($nameRes && mysqli_num_rows($nameRes) == 0) {
          // intentar en tabla productos (por si se guardó desde sala u otra fuente)
          $nameRes = mysqli_query($con, "SELECT nombre FROM productos WHERE id = $pid LIMIT 1");
        }
        if ($nameRes && mysqli_num_rows($nameRes) > 0) {
          $rowName = mysqli_fetch_row($nameRes);
          $prod['nombre'] = $rowName[0];
        }
      }
    }
    if (!isset($prod['cantidad'])) {
      $prod['cantidad'] = 1;
    }
  }
  unset($prod);
} else {
  // tickets_mesa: buscar en tickets_mesa_detalle
  $detalleSql = "SELECT d.producto_id, d.precio,
                        COALESCE(p.nombre, pm.nombre, CONCAT('ID ', d.producto_id)) AS nombre
                 FROM tickets_mesa_detalle d
                 LEFT JOIN productos p        ON p.id  = d.producto_id
                 LEFT JOIN productos_mesas pm ON pm.id = d.producto_id
                 WHERE d.ticket_id = $id";
  $detalleRes = mysqli_query($con, $detalleSql);
  while ($row = mysqli_fetch_assoc($detalleRes)) {
    $productos[] = [
      'id'       => intval($row['producto_id']),
      'nombre'   => $row['nombre'],
      'precio'   => floatval($row['precio']),
      'cantidad' => 1
    ];
  }
  mysqli_free_result($detalleRes);
  $descuento = floatval($ticket['descuento'] ?? 0);
}

// ---------- Render HTML ----------
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Ticket #<?= $ticket['id'] ?></title>
  <style>
    /* Estilo optimizado para impresoras térmicas de 80mm */
    body {
      font-family: 'Courier New', monospace;
      font-size: 12px;
      width: 80mm;
      margin: 0;
      padding: 2mm;
      line-height: 1.2;
    }
    .header {
      text-align: center;
      margin-bottom: 3mm;
      border-bottom: 1px dashed #000;
      padding-bottom: 2mm;
    }
    .header h2 {
      margin: 0;
      font-size: 14px;
      font-weight: bold;
    }
    .info {
      margin-bottom: 3mm;
    }
    .productos {
      margin: 3mm 0;
    }
    .producto {
      display: flex;
      justify-content: space-between;
      margin-bottom: 1mm;
    }
    .producto-nombre {
      flex: 2;
      overflow: hidden;
      text-overflow: ellipsis;
    }
    .producto-cantidad {
      flex: 0.5;
      text-align: right;
      padding-right: 2mm;
    }
    .producto-precio {
      flex: 1;
      text-align: right;
    }
    .divider {
      border-top: 1px dashed #000;
      margin: 3mm 0;
    }
    .totales {
      margin-top: 3mm;
      font-weight: bold;
    }
    .footer {
      text-align: center;
      margin-top: 5mm;
      font-size: 10px;
    }
    .no-print {
      display: none;
    }
    @media print {
      .no-print {
        display: none !important;
      }
      body {
        padding: 0;
      }
    }
  </style>
</head>
<body>

<div class="header">
  <h2>:DDDDDDDDD</h2>
  Ticket Mesa #<?= $ticket['id'] ?><br>
  <?= date('d/m/Y H:i', strtotime($ticket['fecha'] ?? date('Y-m-d'))) ?>
</div>

<div class="info">
  <strong>Mesa:</strong> <?= htmlspecialchars($ticket['mesa_id']) ?><br>
  <strong>Cliente:</strong> <?= htmlspecialchars($ticket['cliente'] ?: '-') ?><br>
  <strong>Notas:</strong> <?= htmlspecialchars($ticket['comentario'] ?: '-') ?>
</div>

<div class="divider"></div>

<div class="productos">
  <strong>PRODUCTOS</strong><br>
  <?php if (count($productos) > 0): ?>
    <?php foreach ($productos as $p): ?>
      <?php
        $nombre   = htmlspecialchars($p['nombre'] ?? 'Producto');
        $precio   = floatval($p['precio'] ?? 0);
        $cantidad = intval($p['cantidad'] ?? 1);
        $subtotal = $precio * $cantidad;
      ?>
      <div class="producto">
        <span class="producto-nombre"><?= $nombre ?></span>
        <span class="producto-cantidad">x<?= $cantidad ?></span>
        <span class="producto-precio">$<?= number_format($subtotal, 2) ?></span>
      </div>
    <?php endforeach; ?>
  <?php else: ?>
    <div>No hay productos</div>
  <?php endif; ?>
</div>

<div class="divider"></div>

<div class="totales">
  <?php if ($descuento > 0): ?>
    <div>Descuento: <?= number_format($descuento, 2) ?>%</div>
  <?php endif; ?>
  <div>TOTAL: $<?= number_format($ticket['monto_total'] ?? $ticket['total'], 2) ?></div>
  <div>Forma de pago: <?= ucfirst($ticket['forma_pago']) ?></div>
  <?php if (($ticket['forma_pago'] ?? '') === 'dividido'): ?>
    <div>Efectivo: $<?= number_format($ticket['efectivo'], 2) ?></div>
    <div>Transferencia: $<?= number_format($ticket['transferencia'], 2) ?></div>
  <?php endif; ?>
</div>

<div class="footer">
  Gracias por su visita!<br>
  <?= date('d/m/Y H:i') ?>
</div>

<div class="no-print" style="margin-top: 10mm; text-align: center;">
  <button onclick="window.print()" style="padding: 5px 10px; font-size: 14px;">
    Imprimir Ticket
  </button>
</div>

<?php if ($autoPrint): ?>
<script>window.onload = () => window.print();</script>
<?php endif; ?>
</body>
</html>