<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="icon" href="img/favicon.png" type="image/png">

<style>
  /* ===== Variables y base ===== */
  :root{
    --navy:#15324c; --ink:#0f1a24; --link:#1f72b6; --bg:#ffffff; --muted:#6b7580;
  }
  *{ box-sizing:border-box }
  html,body{ margin:0; padding:0; background:var(--bg); color:var(--ink); font-family:Poppins,system-ui,Segoe UI,Roboto,Arial,sans-serif }
  a{ color:inherit; text-decoration:none }
  .container{ max-width:1200px; margin:0 auto; padding:0 20px }

  /* ===== Navbar ===== */
  .navbar{ position:sticky; top:0; z-index:50; background:#fff; border-bottom:1px solid rgba(0,0,0,.06) }
  .navbar .inner{ display:flex; align-items:center; justify-content:space-between; height:72px; gap:16px }
  .brand{ display:flex; align-items:center; gap:14px; font-weight:800; letter-spacing:.08em }
  .brand .title{ line-height:1 }
  .brand small{ display:block; font-weight:600; opacity:.8; letter-spacing:.2em; margin-top:2px }
  .nav-links{ display:flex; align-items:center; gap:22px; font-weight:600 }
  .nav-links a{ padding:10px 12px; border-radius:8px; transition:background .2s }
  .nav-links a:hover{ background:rgba(0,0,0,.05) }
  .nav-links a.active{ background:#1f72b6; color:#fff }
  .social{ display:flex; align-items:center; gap:14px }
  .social a{ opacity:.9 }
  .social a:hover{ opacity:1 }

  /* ===== Franja azul de fecha ===== */
  .datebar{ background:var(--navy); color:#fff; font-weight:600 }
  .datebar .inner{ height:40px; display:flex; align-items:center }

  /* ===== Footer ===== */
  footer{ background:var(--navy); color:#fff; }
  .footer-top{ padding:34px 0; border-bottom:1px solid rgba(255,255,255,.08) }
  .footer-grid{ display:grid; grid-template-columns:1fr auto; gap:24px; align-items:center }
  .footer-nav{ display:flex; flex-wrap:wrap; gap:18px; opacity:.95 }
  .footer-nav a{ color:#fff; opacity:.9 }
  .footer-nav a:hover{ opacity:1; text-decoration:underline }
  .footer-brand{ font-weight:800; letter-spacing:.12em; opacity:.95 }
  .footer-bottom{ padding:22px 0; display:flex; justify-content:space-between; align-items:center; gap:20px }
  .footer-social{ display:flex; gap:16px }
  .footer-social a{ color:#fff; opacity:.9 }
  .footer-social a:hover{ opacity:1 }

  /* ===== Responsive ===== */
  .burger{ display:none; font-size:28px; border:none; background:transparent }
  @media (max-width:980px){
    .nav-links{
      display:none; position:absolute; top:72px; left:0; right:0; background:#fff;
      border-bottom:1px solid rgba(0,0,0,.06); padding:10px 20px; flex-wrap:wrap
    }
    .nav-links.open{ display:flex }
    .burger{ display:block }
    .social{ display:none }
    .brand{ gap:10px }
    .footer-grid{ grid-template-columns:1fr }
    .footer-bottom{ flex-direction:column; align-items:flex-start }
  }

  /* ===== Sticky footer (sin huecos) ===== */
  html, body{ height:100%; }
  body{
    min-height:100vh; display:flex; flex-direction:column; overflow-x:hidden;
  }
  @supports (height: 100svh){
    body{ min-height:100svh; }
  }
  main{ flex:1 0 auto; min-height:0; }
  footer{ margin-top:0 !important; flex-shrink:0; }
  .section:last-of-type{ margin-bottom:0 !important; }
</style>
