<script>
  (function(){
    var burger = document.getElementById('burger');
    var nav = document.getElementById('nav');
    if (burger && nav) {
      burger.addEventListener('click', function(){
        nav.classList.toggle('open');
      });
    }
  })();
</script>
<script>
(function () {
  const el = document.getElementById('fecha-hoy');
  if (!el) return;
  try {
    const d = new Date();

    // SIN año (Miércoles, 22 de octubre)
    const fmt = new Intl.DateTimeFormat('es-AR', {
      weekday: 'long',
      day: '2-digit',
      month: 'long'
    });

    // // CON año (Miércoles, 22 de octubre de 2025)
    // const fmt = new Intl.DateTimeFormat('es-AR', {
    //   weekday: 'long',
    //   day: '2-digit',
    //   month: 'long',
    //   year: 'numeric'
    // });

    let s = fmt.format(d); // "miércoles, 22 de octubre"
    s = s.charAt(0).toUpperCase() + s.slice(1); // "Miércoles, 22 de octubre"
    el.textContent = s;
  } catch (e) {
    el.textContent = 'Hoy';
  }
})();
</script>
