<?php
@session_start();
require __DIR__ . '/db.php';
$pdo = pdo();

/* --- (Opcional) auth ---
if (empty($_SESSION['is_admin'])) { http_response_code(403); exit('Acceso restringido'); }
*/

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
function csrf_token(){
  if(empty($_SESSION['csrf_tarifas'])) $_SESSION['csrf_tarifas'] = bin2hex(random_bytes(16));
  return $_SESSION['csrf_tarifas'];
}
function check_csrf($t){ return isset($_SESSION['csrf_tarifas']) && hash_equals($_SESSION['csrf_tarifas'], (string)$t); }

function ensureDir($path){ if(!is_dir($path)) @mkdir($path, 0775, true); }

function rrmdir($dir){
  if (!is_dir($dir)) return;
  $it = new RecursiveDirectoryIterator($dir, FilesystemIterator::SKIP_DOTS);
  $files = new RecursiveIteratorIterator($it, RecursiveIteratorIterator::CHILD_FIRST);
  foreach($files as $f){
    if ($f->isDir()) @rmdir($f->getRealPath());
    else @unlink($f->getRealPath());
  }
  @rmdir($dir);
}

$flash = '';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (!check_csrf($_POST['csrf'] ?? '')) { $flash='Token inválido.'; }
  else {
    $accion = $_POST['accion'] ?? '';

    /* ===== AÑOS ===== */

    // Crear
    if ($accion==='crear_anio') {
      $anio = (int)($_POST['anio'] ?? 0);
      if ($anio < 2000 || $anio > 2100) { $flash='Año inválido'; }
      else {
        $st = $pdo->prepare("SELECT 1 FROM tarifa_anios WHERE anio=?");
        $st->execute([$anio]);
        if ($st->fetch()) { $flash='El año ya existe'; }
        else {
          $pdo->prepare("INSERT INTO tarifa_anios (anio, created_at) VALUES (?, NOW())")->execute([$anio]);
          ensureDir(__DIR__."/files/tarifas/$anio");
          $flash='Año creado';
        }
      }
    }

    // Editar (renombrar año + actualizar paths)
    if ($accion==='editar_anio') {
      $anio_id  = (int)($_POST['anio_id'] ?? 0);
      $nuevo    = (int)($_POST['nuevo_anio'] ?? 0);

      $row = null;
      if ($anio_id) {
        $st=$pdo->prepare("SELECT id, anio FROM tarifa_anios WHERE id=?"); $st->execute([$anio_id]); $row=$st->fetch(PDO::FETCH_ASSOC);
      }
      if (!$row) { $flash='Año no encontrado'; }
      elseif ($nuevo < 2000 || $nuevo > 2100) { $flash='Año inválido'; }
      else {
        $chk = $pdo->prepare("SELECT 1 FROM tarifa_anios WHERE anio=? AND id<>?");
        $chk->execute([$nuevo, $anio_id]);
        if ($chk->fetch()) { $flash='Ya existe ese año'; }
        else {
          $old = (int)$row['anio'];
          $oldDir = __DIR__."/files/tarifas/$old";
          $newDir = __DIR__."/files/tarifas/$nuevo";

          $pdo->beginTransaction();
          try{
            if (is_dir($oldDir)) {
              ensureDir(dirname($newDir));
              if (!@rename($oldDir, $newDir)) {
                throw new RuntimeException('No se pudo renombrar la carpeta de archivos');
              }
            } else {
              ensureDir($newDir);
            }

            // actualizar paths en DB
            $sel = $pdo->prepare("SELECT id, archivo_path FROM tarifa_archivos WHERE anio_id=?");
            $sel->execute([$anio_id]);
            $upd = $pdo->prepare("UPDATE tarifa_archivos SET archivo_path=? WHERE id=?");
            while($r=$sel->fetch(PDO::FETCH_ASSOC)){
              $nuevoPath = str_replace("files/tarifas/$old/", "files/tarifas/$nuevo/", $r['archivo_path']);
              $upd->execute([$nuevoPath, (int)$r['id']]);
            }

            // actualizar número de año
            $pdo->prepare("UPDATE tarifa_anios SET anio=? WHERE id=?")->execute([$nuevo, $anio_id]);

            $pdo->commit();
            $flash='Año actualizado';
          }catch(Throwable $e){
            $pdo->rollBack();
            $flash='Error al actualizar año: '.$e->getMessage();
          }
        }
      }
    }

    // Borrar año (con PDFs)
    if ($accion==='borrar_anio') {
      $anio_id = (int)($_POST['anio_id'] ?? 0);
      $st=$pdo->prepare("SELECT anio FROM tarifa_anios WHERE id=?"); $st->execute([$anio_id]);
      if (!$row=$st->fetch(PDO::FETCH_ASSOC)) { $flash='Año no encontrado'; }
      else {
        $anio=(int)$row['anio'];
        $pdo->beginTransaction();
        try{
          $dir = __DIR__."/files/tarifas/$anio";
          rrmdir($dir);
          $pdo->prepare("DELETE FROM tarifa_archivos WHERE anio_id=?")->execute([$anio_id]);
          $pdo->prepare("DELETE FROM tarifa_anios WHERE id=?")->execute([$anio_id]);
          $pdo->commit();
          $flash='Año eliminado';
        }catch(Throwable $e){
          $pdo->rollBack();
          $flash='Error al eliminar año: '.$e->getMessage();
        }
      }
    }

    /* ===== PDFs ===== */

    // Subir PDF
    if ($accion==='subir_pdf') {
      $anio_id = (int)($_POST['anio_id'] ?? 0);
      $titulo  = trim((string)($_POST['titulo'] ?? ''));
      $mes     = trim((string)($_POST['mes'] ?? ''));
      $orden   = (int)($_POST['orden'] ?? 0);

      $ar = $pdo->prepare("SELECT anio FROM tarifa_anios WHERE id=?");
      $ar->execute([$anio_id]);
      $rowAnio = $ar->fetch(PDO::FETCH_ASSOC);

      if (!$rowAnio) { $flash='Año no encontrado'; }
      else if (empty($_FILES['pdf']['tmp_name'])) { $flash='Subí un PDF'; }
      else {
        $f = $_FILES['pdf'];
        if ($f['error']!==UPLOAD_ERR_OK) { $flash='Error de subida'; }
        else {
          $mime = mime_content_type($f['tmp_name']);
          $ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
          if ($ext!=='pdf' || ($mime!=='application/pdf' && $mime!=='application/octet-stream')) {
            $flash='Solo PDF';
          } else {
            $anio = (int)$rowAnio['anio'];
            ensureDir(__DIR__."/files/tarifas/$anio");
            $safe = preg_replace('/[^a-zA-Z0-9._-]+/','_', strtolower($f['name']));
            if ($safe==='') $safe = 'archivo.pdf';
            $destRel = "files/tarifas/$anio/".uniqid('tar_',true).'_'.$safe;
            $destAbs = __DIR__.'/'.$destRel;
            if (!move_uploaded_file($f['tmp_name'], $destAbs)) {
              $flash='No se pudo guardar';
            } else {
              $st = $pdo->prepare("INSERT INTO tarifa_archivos (anio_id, titulo, mes, archivo_path, orden, created_at)
                                   VALUES (?,?,?,?,?,NOW())");
              $st->execute([$anio_id, $titulo, $mes, $destRel, $orden]);
              $flash='PDF cargado';
            }
          }
        }
      }
    }

    // Editar PDF (título / mes / orden, mover de año y/o reemplazar archivo)
    if ($accion==='editar_pdf') {
      $id        = (int)($_POST['id'] ?? 0);
      $anio_id   = (int)($_POST['anio_id'] ?? 0);      // año actual del pdf
      $nuevo_anio_id = (int)($_POST['nuevo_anio_id'] ?? 0); // a dónde mover (opcional)
      $titulo    = trim((string)($_POST['titulo'] ?? ''));
      $mes       = trim((string)($_POST['mes'] ?? ''));
      $orden     = (int)($_POST['orden'] ?? 0);

      // datos del pdf
      $st = $pdo->prepare("SELECT a.id, a.archivo_path, a.anio_id, ta.anio AS anio_num
                             FROM tarifa_archivos a
                        LEFT JOIN tarifa_anios ta ON ta.id=a.anio_id
                            WHERE a.id=?");
      $st->execute([$id]);
      if (!$pdf = $st->fetch(PDO::FETCH_ASSOC)) { $flash='PDF no encontrado'; }
      else {
        $pdo->beginTransaction();
        try{
          $archivo_path = $pdf['archivo_path'];
          $anio_actual_num = (int)$pdf['anio_num'];

          // ¿Mover a otro año?
          if ($nuevo_anio_id && $nuevo_anio_id !== (int)$pdf['anio_id']) {
            $q = $pdo->prepare("SELECT anio FROM tarifa_anios WHERE id=?");
            $q->execute([$nuevo_anio_id]);
            if (!$rowDest=$q->fetch(PDO::FETCH_ASSOC)) throw new RuntimeException('Año destino no existe');
            $anio_dest_num = (int)$rowDest['anio'];

            $oldAbs = __DIR__ . '/' . $archivo_path;
            $newDir = __DIR__ . "/files/tarifas/$anio_dest_num";
            ensureDir($newDir);
            $base = basename($archivo_path);
            $newAbs = $newDir . '/' . $base;
            $newRel = "files/tarifas/$anio_dest_num/$base";

            if (is_file($oldAbs)) {
              if (!@rename($oldAbs, $newAbs)) throw new RuntimeException('No se pudo mover el archivo al año nuevo');
              $archivo_path = $newRel;
            } else {
              $archivo_path = $newRel;
            }
            $anio_id = $nuevo_anio_id;
            $anio_actual_num = $anio_dest_num;
          }

          // ¿Reemplazar archivo?
          if (!empty($_FILES['pdf_replace']['tmp_name'])) {
            $f = $_FILES['pdf_replace'];
            if ($f['error']!==UPLOAD_ERR_OK) throw new RuntimeException('Error al subir PDF nuevo');
            $mime = mime_content_type($f['tmp_name']);
            $ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
            if ($ext!=='pdf' || ($mime!=='application/pdf' && $mime!=='application/octet-stream')) {
              throw new RuntimeException('El archivo nuevo debe ser PDF');
            }
            ensureDir(__DIR__."/files/tarifas/$anio_actual_num");
            $safe = preg_replace('/[^a-zA-Z0-9._-]+/','_', strtolower($f['name']));
            if ($safe==='') $safe = 'archivo.pdf';
            $destRel = "files/tarifas/$anio_actual_num/".uniqid('tar_',true).'_'.$safe;
            $destAbs = __DIR__.'/'.$destRel;

            if (!move_uploaded_file($f['tmp_name'], $destAbs)) {
              throw new RuntimeException('No se pudo guardar el PDF nuevo');
            }
            $oldAbs = __DIR__ . '/' . $archivo_path;
            if (is_file($oldAbs)) @unlink($oldAbs);

            $archivo_path = $destRel;
          }

          // actualizar datos
          $upd = $pdo->prepare("UPDATE tarifa_archivos
                                   SET anio_id=?, titulo=?, mes=?, archivo_path=?, orden=?
                                 WHERE id=?");
          $upd->execute([$anio_id, $titulo, $mes, $archivo_path, $orden, $id]);

          $pdo->commit();
          $flash='PDF actualizado';
        }catch(Throwable $e){
          $pdo->rollBack();
          $flash='Error al actualizar PDF: '.$e->getMessage();
        }
      }
    }

    // Borrar PDF
    if ($accion==='borrar_pdf') {
      $id = (int)($_POST['id'] ?? 0);
      $st = $pdo->prepare("SELECT archivo_path FROM tarifa_archivos WHERE id=?");
      $st->execute([$id]);
      if ($r=$st->fetch(PDO::FETCH_ASSOC)) {
        @unlink(__DIR__.'/'.$r['archivo_path']);
        $pdo->prepare("DELETE FROM tarifa_archivos WHERE id=?")->execute([$id]);
        $flash='PDF borrado';
      }
    }
  }
}

/* Datos para UI */
$years = $pdo->query("SELECT id, anio FROM tarifa_anios ORDER BY anio DESC")->fetchAll(PDO::FETCH_ASSOC);
$anio_sel = isset($_GET['anio_id']) ? (int)$_GET['anio_id'] : 0;
if (!$anio_sel && $years) $anio_sel = (int)$years[0]['id'];

$pdfs = [];
if ($anio_sel) {
  $st = $pdo->prepare("SELECT id, titulo, mes, archivo_path, orden, anio_id FROM tarifa_archivos WHERE anio_id=? ORDER BY orden ASC, id ASC");
  $st->execute([$anio_sel]);
  $pdfs = $st->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" href="img/favicon.png" type="image/png">

<title>Admin Tarifas</title>
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;800&display=swap" rel="stylesheet">
<style>
  :root{--bd:#e3e8ef;--mut:#5b6672;--ink:#0f1a24;--nav:#15324c;--btn:#1f72b6}
  *{box-sizing:border-box}
  body{margin:0;background:#fff;color:#0f1a24;font-family:Poppins,system-ui,Segoe UI,Roboto,Arial,sans-serif}
  .wrap{max-width:1200px;margin:24px auto;padding:0 16px}
  h1{margin:0 0 14px;font-size:24px}
  .row{display:grid;grid-template-columns:1fr 1fr;gap:18px}
  .card{border:1px solid var(--bd);border-radius:12px;background:#fff}
  .card h2{margin:0;padding:12px 14px;border-bottom:1px solid var(--bd);font-size:18px}
  .card .body{padding:14px}
  label{display:block;font-weight:600;margin:8px 0 6px}
  input[type="text"], input[type="number"], select, input[type="file"]{
    width:100%;padding:10px;border:1px solid var(--bd);border-radius:8px;background:#fff;font:inherit
  }
  .btn{display:inline-block;padding:10px 14px;border-radius:10px;border:1px solid #d1dae6;background:var(--btn);color:#fff;font-weight:700;cursor:pointer}
  .btn.sec{background:#fff;color:#0f1a24}
  table{width:100%;border-collapse:collapse}
  th,td{padding:10px;border-bottom:1px solid var(--bd);text-align:left;vertical-align:middle}
  .mut{color:#5b6672}
  .topbar{background:var(--nav);color:#fff;padding:10px 16px;margin-bottom:12px}
  .flash{background:#eef8ee;border:1px solid #b9e2b9;color:#1a5e1a;padding:8px 12px;border-radius:8px;margin:0 0 12px}
  @media (max-width:980px){.row{grid-template-columns:1fr}}
  .actions{display:flex;gap:8px;flex-wrap:wrap}
</style>
</head>
<body>
<div class="topbar"><strong>Admin Tarifas</strong></div>
<div class="wrap">

  <?php if($flash): ?><div class="flash"><?= h($flash) ?></div><?php endif; ?>

  <div class="row">
    <div class="card">
      <h2>1) Crear año</h2>
      <div class="body">
        <form method="post">
          <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
          <input type="hidden" name="accion" value="crear_anio">
          <label>Año</label>
          <input type="number" name="anio" placeholder="2025" min="2000" max="2100" required>
          <div style="margin-top:10px">
            <button class="btn" type="submit">Crear</button>
          </div>
        </form>
      </div>
    </div>

    <div class="card">
      <h2>2) Subir PDF a un año</h2>
      <div class="body">
        <form method="post" enctype="multipart/form-data">
          <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
          <input type="hidden" name="accion" value="subir_pdf">
          <label>Año</label>
          <select name="anio_id" required>
            <?php foreach($years as $y): ?>
              <option value="<?= (int)$y['id'] ?>" <?= $anio_sel==$y['id']?'selected':'' ?>>
                <?= (int)$y['anio'] ?>
              </option>
            <?php endforeach; ?>
          </select>
          <label>Título (opcional)</label>
          <input type="text" name="titulo" placeholder="Septiembre 2025">
          <label>Mes (opcional)</label>
          <input type="text" name="mes" placeholder="Septiembre 2025">
          <label>Orden (opcional)</label>
          <input type="number" name="orden" value="0">
          <label>Archivo PDF</label>
          <input type="file" name="pdf" accept="application/pdf" required>
          <div style="margin-top:10px">
            <button class="btn" type="submit">Subir PDF</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- 3) AÑOS -->
  <div class="card" style="margin-top:18px">
    <h2>3) Años — editar o borrar</h2>
    <div class="body">
      <table>
        <thead><tr><th>ID</th><th>Año</th><th style="width:320px">Acciones</th></tr></thead>
        <tbody>
        <?php foreach($years as $y): ?>
          <tr>
            <td><?= (int)$y['id'] ?></td>
            <td>
              <form method="post" class="actions">
                <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
                <input type="hidden" name="accion" value="editar_anio">
                <input type="hidden" name="anio_id" value="<?= (int)$y['id'] ?>">
                <input type="number" name="nuevo_anio" value="<?= (int)$y['anio'] ?>" min="2000" max="2100" required>
                <button class="btn" type="submit">Guardar</button>
              </form>
            </td>
            <td class="actions">
              <form method="post" onsubmit="return confirm('¿Eliminar este año y TODOS sus PDFs?')">
                <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
                <input type="hidden" name="accion" value="borrar_anio">
                <input type="hidden" name="anio_id" value="<?= (int)$y['id'] ?>">
                <button class="btn sec" type="submit">Borrar año</button>
              </form>
              <a class="btn sec" href="?anio_id=<?= (int)$y['id'] ?>">Ver PDFs</a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$years): ?>
          <tr><td colspan="3" class="mut">No hay años creados.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- 4) PDFs del año seleccionado -->
  <div class="card" style="margin-top:18px">
    <h2>4) PDFs del año seleccionado</h2>
    <div class="body">
      <form>
        <label>Ver año</label>
        <select name="anio_id" onchange="this.form.submit()">
          <?php foreach($years as $y): ?>
            <option value="<?= (int)$y['id'] ?>" <?= $anio_sel==$y['id']?'selected':'' ?>>
              <?= (int)$y['anio'] ?>
            </option>
          <?php endforeach; ?>
        </select>
      </form>

      <div style="margin:10px 0"></div>

      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th style="min-width:220px">Título</th>
            <th style="min-width:150px">Mes</th>
            <th>Orden</th>
            <th>Año</th>
            <th>Archivo</th>
            <th style="width:260px"></th>
          </tr>
        </thead>
        <tbody>
        <?php foreach($pdfs as $p): ?>
          <tr>
            <td><?= (int)$p['id'] ?></td>
            <td>
              <form method="post" enctype="multipart/form-data" class="actions">
                <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
                <input type="hidden" name="accion" value="editar_pdf">
                <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
                <input type="hidden" name="anio_id" value="<?= (int)$p['anio_id'] ?>">
                <input type="text" name="titulo" value="<?= h($p['titulo']) ?>" placeholder="Título">
            </td>
            <td>
                <input type="text" name="mes" value="<?= h($p['mes']) ?>" placeholder="Mes">
            </td>
            <td>
                <input type="number" name="orden" value="<?= (int)$p['orden'] ?>" style="width:90px">
            </td>
            <td>
              <select name="nuevo_anio_id">
                <option value="<?= (int)$p['anio_id'] ?>">(igual)</option>
                <?php foreach($years as $y): ?>
                  <?php if($y['id'] != $p['anio_id']): ?>
                    <option value="<?= (int)$y['id'] ?>"><?= (int)$y['anio'] ?></option>
                  <?php endif; ?>
                <?php endforeach; ?>
              </select>
            </td>
            <td>
              <a href="<?= h($p['archivo_path']) ?>" target="_blank">ver</a><br>
              <small class="mut">Reemplazar:</small>
              <input type="file" name="pdf_replace" accept="application/pdf">
            </td>
            <td class="actions">
                <button class="btn" type="submit">Guardar</button>
              </form>
              <form method="post" onsubmit="return confirm('¿Borrar este PDF?')" style="display:inline-block">
                <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
                <input type="hidden" name="accion" value="borrar_pdf">
                <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
                <button class="btn sec" type="submit">Borrar</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$pdfs): ?>
          <tr><td colspan="7" class="mut">No hay PDFs en este año.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <p class="mut" style="margin-top:14px">
    Los archivos se guardan en <code>/files/tarifas/{año}/</code> dentro del sitio.
  </p>
</div>
</body>
</html>
