<?php // index.php ?>

<?php
/* =======================
   BLOQUE NOTAS (seguro)
   ======================= */
$NT_items = [];
try {
  if (file_exists(__DIR__ . '/db.php')) {
    require __DIR__ . '/db.php';
    if (function_exists('pdo')) {
      $pdo = pdo();
      $q = $pdo->query("
        SELECT id, titulo, portada_url, contenido_json, created_at
        FROM noticias
        WHERE estado='publicado'
        ORDER BY created_at DESC
      ");
      if ($q) { $NT_items = $q->fetchAll(PDO::FETCH_ASSOC); }
    }
  }
} catch (Throwable $e) { $NT_items = []; }

if (!function_exists('nt_s')) {
  function nt_s($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
  function nt_norm($t){ $t=str_replace('&nbsp;',' ',(string)$t); $t=strip_tags($t); $t=preg_replace('/\s+/u',' ',$t); return trim($t); }
  function nt_first_h1($j){ $a=json_decode((string)$j,true); if(!is_array($a))return''; foreach($a as $b){ if(($b['type']??$b['tipo']??'')==='h1'){ $x=nt_norm($b['content']??$b['text']??''); if($x!=='')return $x; } } return''; }
  function nt_first_img($j){ $a=json_decode((string)$j,true); if(!is_array($a))return''; foreach($a as $b){ if(($b['type']??$b['tipo']??'')==='img'){ $s=trim((string)($b['src']??'')); if($s!=='')return $s; } } return''; }
  function nt_excerpt($j){ $a=json_decode((string)$j,true); if(!is_array($a))return''; foreach($a as $b){ if(($b['type']??$b['tipo']??'')==='p'){ $x=nt_norm($b['content']??$b['text']??''); if($x!=='')return mb_strimwidth($x,0,180,'…','UTF-8'); } } return''; }
  function nt_fmt_date($iso){ $ts=strtotime((string)$iso); return $ts?date('d/m/Y',$ts):''; }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta content="width=device-width, initial-scale=1" name="viewport" />
  <title>Fe.Tr.A — Federación de Transportadores Argentinos</title>
  <meta name="description" content="Federación de Transportadores Argentinos." />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <link rel="icon" href="img/favicon.png" type="image/png">

  <style>
    :root{ --navy:#15324c; --ink:#0f1a24; --link:#1f72b6; --bg:#ffffff; --muted:#6b7580; }
    *{box-sizing:border-box}
    html,body{margin:0;padding:0;background:var(--bg);color:var(--ink);font-family:Poppins,system-ui,Segoe UI,Roboto,Arial,sans-serif}
    a{color:inherit;text-decoration:none}
    .container{max-width:1200px;margin:0 auto;padding:0 20px}

    /* ===== Sticky footer con FLEX (sin banda blanca) ===== */
    html, body { height: 100%; }
    body{
      min-height:100vh;
      display:flex;
      flex-direction:column;   /* header - main - footer */
      overflow-x:hidden;
    }
    main{ flex:1 0 auto; min-height:0; }
    footer{ margin-top:0 !important; flex-shrink:0; }
    .section:last-of-type{ margin-bottom:0 !important; }

    /* NAVBAR */
    .navbar{position:sticky;top:0;z-index:50;background:#fff;border-bottom:1px solid rgba(0,0,0,.06)}
    .navbar .inner{display:flex;align-items:center;justify-content:space-between;height:72px;gap:16px}
    .brand{display:flex;align-items:center;gap:14px;font-weight:800;letter-spacing:.08em}
    .brand .title{line-height:1}
    .brand small{display:block;font-weight:600;opacity:.8;letter-spacing:.2em;margin-top:2px}
    .nav-links{display:flex;align-items:center;gap:22px;font-weight:600}
    .nav-links a{padding:10px 12px;border-radius:8px;transition:background .2s}
    .nav-links a:hover{background:rgba(0,0,0,.05)}
    .nav-links a.active{background:#1f72b6;color:#fff}
    .social{display:flex;align-items:center;gap:14px}
    .social a{opacity:.9}
    .social a:hover{opacity:1}

    /* Fecha */
    .datebar{background:var(--navy);color:#fff;font-weight:600}
    .datebar .inner{height:40px;display:flex;align-items:center}

    /* HERO */
    .hero{position:relative;min-height:64vh;overflow:hidden;display:flex;align-items:center;justify-content:center;}
    .hero::before{content:"";position:absolute;inset:0;background:url('img/fondo.png') center/cover no-repeat;filter:blur(2px) brightness(.9);transform:scale(1.04);}
    .hero-logo{position:relative;z-index:1;display:flex;justify-content:center;width:100%;padding:24px}
    .hero-logo img{width:clamp(240px,52vw,980px);height:auto;filter:drop-shadow(0 6px 18px rgba(0,0,0,.35))}

    /* Contacto */
    .section{padding:72px 0}
    .section-title{font-size:clamp(24px,3.4vw,36px);font-weight:800;color:#fff;display:flex;align-items:center;gap:20px}
    .section-title::after{content:"";flex:1;height:2px;background:#e3edf7;opacity:.3}

    .contact-wrap{display:grid;grid-template-columns:1fr 1fr;gap:40px;align-items:start}
    .contact-card{background:#fff;border:1px solid rgba(0,0,0,.06);border-radius:16px;padding:22px}
    .contact-list{display:grid;gap:12px;margin:0 0 18px 0}
    .contact-item{display:flex;gap:10px;align-items:flex-start;color:var(--ink)}
    .contact-item i{color:var(--navy);margin-top:3px}
    .social-inline{display:flex;gap:18px;align-items:center;margin-top:20px}
    .social-inline a{font-size:20px;color:#172b3a}
    form.contact-form{display:grid;gap:12px}
    .input, textarea{width:100%;padding:12px 14px;border:1px solid #dfe6ee;border-radius:10px;font:inherit;background:#fff;outline:none;}
    .input:focus, textarea:focus{border-color:#b7c9db;box-shadow:0 0 0 3px rgba(31,114,182,.08)}
    textarea{min-height:120px;resize:vertical}
    .grid-2{display:grid;grid-template-columns:1fr 1fr;gap:12px}
    .btn{appearance:none;border:0;border-radius:10px;padding:12px 18px;font-weight:700;cursor:pointer;background:#1f72b6;color:#fff;}
    .btn:disabled{opacity:.6;cursor:not-allowed}

    /* FOOTER */
    footer{background:var(--navy);color:#fff}          /* ← sin margin-top */
    .footer-top{padding:34px 0;border-bottom:1px solid rgba(255,255,255,.08)}
    .footer-grid{display:grid;grid-template-columns:1fr auto;gap:24px;align-items:center}
    .footer-nav{display:flex;flex-wrap:wrap;gap:18px;opacity:.95}
    .footer-nav a{color:#fff;opacity:.9}
    .footer-nav a:hover{opacity:1;text-decoration:underline}
    .footer-brand{font-weight:800;letter-spacing:.12em;opacity:.95}
    .footer-bottom{padding:22px 0;display:flex;justify-content:space-between;align-items:center;gap:20px}
    .footer-social{display:flex;gap:16px}
    .footer-social a{color:#fff;opacity:.9}
    .footer-social a:hover{opacity:1}

    /* Responsive */
    .burger{display:none;font-size:28px;border:none;background:transparent}
    @media (max-width: 980px){
      .nav-links{display:none;position:absolute;top:72px;left:0;right:0;background:#fff;border-bottom:1px solid rgba(0,0,0,.06);padding:10px 20px;flex-wrap:wrap}
      .nav-links.open{display:flex}
      .burger{display:block}
      .social{display:none}
      .brand{gap:10px}
      .contact-wrap{grid-template-columns:1fr}
      .footer-grid{grid-template-columns:1fr}
      .footer-bottom{flex-direction:column;align-items:flex-start}
    }

    /* ====== NOTAS: solo franja azul del título, fondo blanco ====== */
    .nt-band{background:#0f2a44;padding:14px 0;}
    .nt-band .inner{max-width:1200px;margin:0 auto;padding:0 20px;display:flex;align-items:center;gap:20px;color:#fff;}
    .nt-band h2{margin:0;font-size:22px;font-weight:800}
    .nt-band .rule{flex:1;height:2px;background:#e3edf7;opacity:.3}

    .nt-wrap{max-width:1200px;margin:0 auto;padding:22px 20px 44px;background:#fff;}
    .nt-grid{display:grid;grid-template-columns:repeat(3,1fr);gap:22px}
    @media (max-width:1024px){.nt-grid{grid-template-columns:repeat(2,1fr)}}
    @media (max-width:640px){.nt-grid{grid-template-columns:1fr}}

    .nt-card{background:#fff;border:1px solid #e9eef3;border-radius:14px;overflow:hidden;display:flex;flex-direction:column}
    .nt-cover{width:100%;aspect-ratio:16/9;object-fit:cover;transition:transform .35s ease;background:#f1f4f8}
    .nt-card:hover .nt-cover{transform:scale(1.02)}
    .nt-body{padding:14px 16px}
    .nt-title{font-size:18px;line-height:1.25;font-weight:700;margin:0 0 8px}
    .nt-title a{text-decoration:none}
    .nt-title a:hover{text-decoration:underline}
    .nt-more{display:inline-block;font-weight:600;font-size:14px;opacity:.8}
    .nt-more:hover{opacity:1;text-decoration:underline}
    .nt-meta{display:flex;gap:10px;align-items:center;font-size:12px;color:#5b6672;border-top:1px solid #eef2f6;padding:10px 16px}
    .nt-dot{width:4px;height:4px;border-radius:50%;background:#c9d1db;display:inline-block}
  </style>
</head>


<body>

  <!-- NAVBAR -->
  <header class="navbar">
    <div class="container inner">
      <div class="brand">
        <div class="title">
          <div>FEDERACIÓN DE</div>
          <small>TRANSPORTADORES ARGENTINOS</small>
        </div>
      </div>

      <button class="burger" id="burger" aria-label="Abrir menú"><i class="bi bi-list"></i></button>

      <nav class="nav-links" id="nav">
        <a href="index.php" class="active">INICIO</a>
        <a href="notas.php">NOTAS</a>
        <a href="servicios.php">SERVICIOS</a>
        <a href="delegaciones.php">DELEGACIONES</a>
        <a href="tarifas.php">TARIFAS</a>
        <a href="contacto.php">CONTACTO</a>
      </nav>

      <div class="social">
        <a href="https://www.facebook.com/share/19aQ41jjxB/" target="_blank" rel="noopener" aria-label="Facebook"><i class="bi bi-facebook"></i></a>
        <a href="https://x.com/afetra05?t=ZdX3j9XIGd2PvFizJYMcdg&s=09" target="_blank" rel="noopener" aria-label="X (Twitter)"><i class="bi bi-twitter-x"></i></a>
        <a href="https://www.instagram.com/fe_tr.a?igsh=ZHpqeHB2OW1iNmRq" target="_blank" rel="noopener" aria-label="Instagram"><i class="bi bi-instagram"></i></a>
        <a href="https://www.linkedin.com/in/federaci%C3%B3n-de-transportadores-argentinos-arg-8a33a1327?utm_source=share&utm_campaign=share_via&utm_content=profile&utm_medium=android_app" target="_blank" rel="noopener" aria-label="LinkedIn"><i class="bi bi-linkedin"></i></a>
      </div>
    </div>
  </header>

  <main>
    <!-- DATE BAR -->
    <div class="datebar">
      <div class="container inner"><span id="fecha-hoy">—</span></div>
    </div>

    <!-- HERO -->
    <section class="hero" id="inicio" aria-label="Portada">
      <div class="hero-logo">
        <img src="img/fetra-logo-text.png" alt="Fe.Tr.A — Federación de Transportadores Argentinos" width="768" height="247">
      </div>
    </section>

    <!-- SOLO LA FRANJA DEL TÍTULO EN AZUL -->
    <div class="nt-band">
      <div class="inner container">
        <h2>Notas</h2>
        <div class="rule"></div>
      </div>
    </div>

    <!-- CONTENIDO DE NOTAS EN FONDO BLANCO -->
    <section class="nt-wrap" id="notas">
      <div class="nt-grid">
        <?php if ($NT_items): foreach ($NT_items as $n):
          $h1    = nt_first_h1($n['contenido_json']);
          $title = ($n['titulo'] && $n['titulo']!=='Sin título') ? $n['titulo'] : $h1;
          if ($title==='') $title='Sin título';
          $cover   = $n['portada_url'] ?: nt_first_img($n['contenido_json']);
          $excerpt = nt_excerpt($n['contenido_json']);
          $fecha   = nt_fmt_date($n['created_at']);
        ?>
          <article class="nt-card">
            <?php if($cover): ?>
              <a href="nota.php?id=<?= (int)$n['id'] ?>">
                <img class="nt-cover" src="<?= nt_s($cover) ?>" alt="<?= nt_s($title) ?>">
              </a>
            <?php else: ?>
              <div class="nt-cover"></div>
            <?php endif; ?>
            <div class="nt-body">
              <h3 class="nt-title"><a href="nota.php?id=<?= (int)$n['id'] ?>"><?= nt_s($title) ?></a></h3>
              <?php if($excerpt): ?><div style="color:#374151;margin-bottom:10px"><?= nt_s($excerpt) ?></div><?php endif; ?>
              <a class="nt-more" href="nota.php?id=<?= (int)$n['id'] ?>">Leer más</a>
            </div>
            <div class="nt-meta">
              <span><?= nt_s($fecha) ?></span>
              <span class="nt-dot"></span>
              <span>No hay comentarios</span>
            </div>
          </article>
        <?php endforeach; else: ?>
          <div style="color:#5b6672">No hay noticias publicadas.</div>
        <?php endif; ?>
      </div>
    </section>
  </section>            <!-- cierra NOTAS -->
  <!-- CONDUCIENDO SALUDABLEMENTE -->
  <div class="nt-band">
    <div class="inner container">
      <h2>Conduciendo Saludablemente</h2>
      <div class="rule"></div>
    </div>
  </div>
  
  <section id="conduciendo-saludablemente" class="section">
    <div class="container">
      <div class="video-wrap" style="max-width:650px;margin:0 auto;"> <!-- Reducido a 500px -->
        <video controls preload="metadata" style="display:block;width:100%;height:auto;border-radius:8px;box-shadow:0 18px 40px rgba(15,42,68,0.35);">
          <source src="img/vid.mp4" type="video/mp4">
          Tu navegador no soporta la reproducción de video.
        </video>
      </div>
    </div>
  </section>
  <!-- CONTACTO -->
  <section id="contacto" ...

    <!-- CONTACTO -->
    <section id="contacto" class="section" style="background:#0f2a44;">
      <div class="container">
        <h2 class="section-title">Contacto</h2>
        <div class="contact-wrap" style="margin-top:28px">
          <div class="contact-card">
            <div class="contact-list">
              <div class="contact-item"><i class="bi bi-geo-alt-fill"></i> <div><strong>Sede Nacional</strong><br>E. Zeballos 1416 – CP 2000 Rosario S. F.</div></div>
              <div class="contact-item"><i class="bi bi-telephone-fill"></i> <a href="tel:+543414258218">(0341) 4258218</a></div>
              <div class="contact-item"><i class="bi bi-envelope-fill"></i> <a href="mailto:fetranacional@hotmail.com">fetranacional@hotmail.com</a></div>
            </div>
            <blockquote class="instagram-media" data-instgrm-permalink="https://www.instagram.com/fe_tr.a/" data-instgrm-version="14" style="background:#fff;border:0;border-radius:12px;box-shadow:0 1px 3px rgba(0,0,0,.06);padding:0;width:100%;max-width:460px;margin:6px auto;"></blockquote>
            <script async src="https://www.instagram.com/embed.js"></script>
            <div class="social-inline" aria-label="Redes sociales">
              <a href="https://www.facebook.com/share/19aQ41jjxB/" target="_blank" rel="noopener" aria-label="Facebook"><i class="bi bi-facebook"></i></a>
              <a href="https://x.com/afetra05?t=ZdX3j9XIGd2PvFizJYMcdg&s=09" target="_blank" rel="noopener" aria-label="X (Twitter)"><i class="bi bi-twitter-x"></i></a>
              <a href="https://www.instagram.com/fe_tr.a?igsh=ZHpqeHB2OW1iNmRq" target="_blank" rel="noopener" aria-label="Instagram"><i class="bi bi-instagram"></i></a>
              <a href="https://www.linkedin.com/in/federaci%C3%B3n-de-transportadores-argentinos-arg-8a33a1327?utm_source=share&utm_campaign=share_via&utm_content=profile&utm_medium=android_app" target="_blank" rel="noopener" aria-label="LinkedIn"><i class="bi bi-linkedin"></i></a>
            </div>
          </div>

          <div class="contact-card">
            <h3 style="margin:0 0 10px 0">Dejanos un mensaje y nos comunicaremos en la brevedad</h3>
            <form class="contact-form" action="enviar.php" method="post">
              <div class="grid-2">
                <input class="input" type="text" name="nombre" placeholder="Nombre" required>
                <input class="input" type="text" name="apellido" placeholder="Apellido" required>
              </div>
              <input class="input" type="tel" name="telefono" placeholder="Teléfono">
              <input class="input" type="email" name="email" placeholder="Email" required>
              <textarea name="consulta" class="input" placeholder="Consulta" required></textarea>
              <button class="btn" type="submit">ENVIAR</button>
              <small style="color:var(--muted)">Al enviar aceptás nuestra política de privacidad.</small>
            </form>
          </div>
        </div>
      </div>
    </section>
  </main>

  <!-- FOOTER -->
  <footer>
    <div class="footer-top">
      <div class="container footer-grid">
        <div class="footer-brand">FEDERACIÓN DE TRANSPORTADORES ARGENTINOS</div>
        <nav class="footer-nav" aria-label="Footer">
          <a href="#inicio">Inicio</a>
          <a href="notas.php">Notas</a>
          <a href="#servicios">Servicios</a>
          <a href="#delegaciones">Delegaciones</a>
          <a href="#tarifas">Tarifas</a>
          <a href="#contacto">Contacto</a>
        </nav>
      </div>
    </div>
    <div class="container footer-bottom">
      <div>© <?php echo date('Y'); ?> Fe.Tr.A — Todos los derechos reservados</div>
      <div class="footer-social">
        <a href="https://www.facebook.com/share/19aQ41jjxB/" target="_blank" rel="noopener" aria-label="Facebook"><i class="bi bi-facebook"></i></a>
        <a href="https://x.com/afetra05?t=ZdX3j9XIGd2PvFizJYMcdg&s=09" target="_blank" rel="noopener" aria-label="X (Twitter)"><i class="bi bi-twitter-x"></i></a>
        <a href="https://www.instagram.com/fe_tr.a?igsh=ZHpqeHB2OW1iNmRq" target="_blank" rel="noopener" aria-label="Instagram"><i class="bi bi-instagram"></i></a>
        <a href="https://www.linkedin.com/in/federaci%C3%B3n-de-transportadores-argentinos-arg-8a33a1327?utm_source=share&utm_campaign=share_via&utm_content=profile&utm_medium=android_app" target="_blank" rel="noopener" aria-label="LinkedIn"><i class="bi bi-linkedin"></i></a>
      </div>
    </div>
  </footer>

  <script>
  (function () {
    const el = document.getElementById('fecha-hoy');
    if (!el) return;
    try {
      const d = new Date();
  
      // Si NO querés el año:
      const fmt = new Intl.DateTimeFormat('es-AR', {
        weekday: 'long',
        day: '2-digit',
        month: 'long'
      });
      let s = fmt.format(d);              // ej: "miércoles, 22 de octubre"
      s = s.charAt(0).toUpperCase() + s.slice(1);  // "Miércoles, 22 de octubre"
      el.textContent = s;
  
      // --- Si en alguna página querés incluir el AÑO, usá este bloque en cambio ---
      // const fmt = new Intl.DateTimeFormat('es-AR', {
      //   weekday: 'long',
      //   day: '2-digit',
      //   month: 'long',
      //   year: 'numeric'
      // });
      // let s = fmt.format(d);            // ej: "miércoles, 22 de octubre de 2025"
      // s = s.charAt(0).toUpperCase() + s.slice(1);
      // el.textContent = s;
    } catch (e) {
      el.textContent = 'Hoy';
    }
  })();
  </script>
<?php
require_once __DIR__ . '/db.php';

/**
 * Render básico de publicidad desde la tabla ad_items.
 * Usalo así: publicidad_render('index'); // o 'contacto', 'tarifas', etc.
 */
if (!function_exists('publicidad_render')) {
  function publicidad_render(string $page_slug): void {
    try {
      $pdo = pdo();
      $st = $pdo->prepare("SELECT * FROM ad_items
                           WHERE page_slug=? AND is_active=1
                           ORDER BY zindex ASC, id ASC");
      $st->execute([$page_slug]);
      $rows = $st->fetchAll(PDO::FETCH_ASSOC);
    } catch (Throwable $e) {
      echo "<!-- publicidad_render error: ".htmlspecialchars($e->getMessage())." -->";
      return;
    }
    if (!$rows) { echo "<!-- publicidad_render: 0 items ($page_slug) -->"; return; }

    // Overlay fijo para posicionar en % (lo que guardes en la tabla)
    echo '<div class="pub-layer" style="position:fixed;inset:0;pointer-events:none;z-index:2147483600">';
    foreach ($rows as $r) {
      $x=(float)$r['x_pct']; $y=(float)$r['y_pct']; $w=(float)$r['w_pct'];
      $h = ($r['h_pct'] === null || $r['h_pct']==='') ? null : (float)$r['h_pct'];
      $z = (int)$r['zindex'];
      echo '<div style="position:absolute;left:'.$x.'%;top:'.$y.'%;width:'.$w.'%;'.
           ($h!==null ? 'height:'.$h.'%;' : '').'z-index:'.$z.';pointer-events:auto;">';

      $type = $r['type'];
      if ($type === 'section') {
        $title = htmlspecialchars($r['title'] ?? 'Sección', ENT_QUOTES, 'UTF-8');
        echo '<section style="position:absolute;inset:0;background:#15324c;color:#fff;display:flex;align-items:center;padding:12px 16px;font-weight:700;border-radius:8px">'.
             $title.'</section>';

      } elseif ($type === 'image' && !empty($r['media_url'])) {
        $src = htmlspecialchars($r['media_url'], ENT_QUOTES, 'UTF-8');
        $img = '<img src="'.$src.'" alt="" style="width:100%;height:100%;object-fit:contain;display:block">';
        if (!empty($r['link_url'])) {
          $href = htmlspecialchars($r['link_url'], ENT_QUOTES, 'UTF-8');
          echo '<a href="'.$href.'" target="_blank" rel="noopener">'.$img.'</a>';
        } else {
          echo $img;
        }

      } elseif ($type === 'video' && !empty($r['media_url'])) {
        $mu = (string)$r['media_url'];
        if (preg_match('~youtu\\.?be~', $mu) && preg_match('~(?:v=|\\.be/)([\\w-]+)~', $mu, $m) && !empty($m[1])) {
          echo '<iframe src="https://www.youtube.com/embed/'.$m[1].'" allow="autoplay;encrypted-media" allowfullscreen style="width:100%;height:100%;border:0"></iframe>';
        } else {
          $src = htmlspecialchars($mu, ENT_QUOTES, 'UTF-8');
          echo '<video src="'.$src.'" controls style="width:100%;height:100%;object-fit:cover"></video>';
        }

      } elseif ($type === 'html' && $r['html']!=='') {
        // Se imprime tal cual lo que guardes en ad_items.html
        echo $r['html'];

      } elseif ($type === 'link') {
        $label = htmlspecialchars($r['title'] ?: ($r['link_url'] ?: 'Link'), ENT_QUOTES, 'UTF-8');
        $href  = htmlspecialchars($r['link_url'] ?: '#', ENT_QUOTES, 'UTF-8');
        echo '<a href="'.$href.'" target="_blank" rel="noopener" style="position:absolute;inset:8px;display:flex;align-items:center;justify-content:center;border:2px dashed #1f72b6;border-radius:8px;text-decoration:none;color:#1f72b6;font-weight:600;background:#fff">'.$label.'</a>';
      }
      echo '</div>';
    }
    echo '</div>';
  }
}

// LLAMADA: cambiá 'index' por el slug de ESTA página:
publicidad_render('index');
?>
<?php require_once __DIR__.'/db.php'; ?>
<?php require_once __DIR__.'/admin_publicidad.php'; ?>
<?php admin_publicidad('index'); // cambiá 'index' por el slug de ESTA página ?>
<!-- Canvas Publicitario -->

</body>
</html>
