<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="icon" href="img/favicon.png" type="image/png">

<style>
  /* ===== Variables y base ===== */
  :root{
    --navy:#15324c; --ink:#0f1a24; --link:#1f72b6; --bg:#ffffff; --muted:#6b7580;
  }
  *{ box-sizing:border-box }
  html,body{ margin:0; padding:0; background:var(--bg); color:var(--ink); font-family:Poppins,system-ui,Segoe UI,Roboto,Arial,sans-serif }
  a{ color:inherit; text-decoration:none }
  .container{ max-width:1200px; margin:0 auto; padding:0 20px }

  /* ===== Navbar ===== */
  .navbar{ position:sticky; top:0; z-index:50; background:#fff; border-bottom:1px solid rgba(0,0,0,.06) }
  .navbar .inner{ display:flex; align-items:center; justify-content:space-between; height:72px; gap:16px }
  .brand{ display:flex; align-items:center; gap:14px; font-weight:800; letter-spacing:.08em }
  .brand .title{ line-height:1 }
  .brand small{ display:block; font-weight:600; opacity:.8; letter-spacing:.2em; margin-top:2px }
  .nav-links{ display:flex; align-items:center; gap:22px; font-weight:600 }
  .nav-links a{ padding:10px 12px; border-radius:8px; transition:background .2s }
  .nav-links a:hover{ background:rgba(0,0,0,.05) }
  .nav-links a.active{ background:#1f72b6; color:#fff }
  .social{ display:flex; align-items:center; gap:14px }
  .social a{ opacity:.9 }
  .social a:hover{ opacity:1 }

  /* ===== Franja azul de fecha ===== */
  .datebar{ background:var(--navy); color:#fff; font-weight:600 }
  .datebar .inner{ height:40px; display:flex; align-items:center }

  /* ===== Footer ===== */
  footer{ background:var(--navy); color:#fff; }
  .footer-top{ padding:34px 0; border-bottom:1px solid rgba(255,255,255,.08) }
  .footer-grid{ display:grid; grid-template-columns:1fr auto; gap:24px; align-items:center }
  .footer-nav{ display:flex; flex-wrap:wrap; gap:18px; opacity:.95 }
  .footer-nav a{ color:#fff; opacity:.9 }
  .footer-nav a:hover{ opacity:1; text-decoration:underline }
  .footer-brand{ font-weight:800; letter-spacing:.12em; opacity:.95 }
  .footer-bottom{ padding:22px 0; display:flex; justify-content:space-between; align-items:center; gap:20px }
  .footer-social{ display:flex; gap:16px }
  .footer-social a{ color:#fff; opacity:.9 }
  .footer-social a:hover{ opacity:1 }

  /* ===== Responsive ===== */
  .burger{ display:none; font-size:28px; border:none; background:transparent }
  @media (max-width:980px){
    .nav-links{
      display:none; position:absolute; top:72px; left:0; right:0; background:#fff;
      border-bottom:1px solid rgba(0,0,0,.06); padding:10px 20px; flex-wrap:wrap
    }
    .nav-links.open{ display:flex }
    .burger{ display:block }
    .social{ display:none }
    .brand{ gap:10px }
    .footer-grid{ grid-template-columns:1fr }
    .footer-bottom{ flex-direction:column; align-items:flex-start }
  }

  /* ===== Sticky footer (sin huecos) ===== */
  html, body{ height:100%; }
  body{
    min-height:100vh; display:flex; flex-direction:column; overflow-x:hidden;
  }
  @supports (height: 100svh){
    body{ min-height:100svh; }
  }
  main{ flex:1 0 auto; min-height:0; }
  footer{ margin-top:0 !important; flex-shrink:0; }
  .section:last-of-type{ margin-bottom:0 !important; }
</style>

<style>
  /* ===== Submenú Servicios (Beneficios) ===== */
  .nav-links .nav-item{
    position:relative;
  }
  .nav-links .nav-item > a{
    display:flex;
    align-items:center;
    gap:4px;
  }
  .nav-links .nav-item .chevron{
    font-size:13px;
  }
  .nav-links .submenu{
    position:absolute;
    top:100%;
    left:0;
    background:#fff;
    min-width:190px;
    border-radius:10px;
    box-shadow:0 10px 25px rgba(0,0,0,.12);
    padding:6px 0;
    display:none;
    z-index:60;
  }
  .nav-links .submenu a{
    display:block;
    padding:8px 16px;
    font-weight:500;
    border-radius:0;
    white-space:nowrap;
  }
  .nav-links .submenu a:hover{
    background:rgba(0,0,0,.05);
  }
  .nav-links .nav-item:hover > .submenu{
    display:block;
  }

  @media (max-width:980px){
    .nav-links .nav-item{
      width:100%;
    }
    .nav-links .submenu{
      position:static;
      box-shadow:none;
      padding:0 0 0 18px;
      margin-top:4px;
      display:block;
      min-width:0;
    }
  }

  /* ===== Grid de beneficios ===== */
  .beneficios-hero{
    padding:40px 0 10px;
  }
  .beneficios-hero h1{
    font-size:32px;
    margin:0 0 8px;
  }
  .beneficios-hero p{
    margin:0;
    color:var(--muted);
  }
  .beneficios-grid{
    display:grid;
    grid-template-columns:repeat(3,minmax(0,1fr));
    gap:24px;
    padding:30px 0 60px;
  }
  .beneficio-card{
    border-radius:14px;
    overflow:hidden;
    border:1px solid rgba(0,0,0,.06);
    background:#fff;
    box-shadow:0 10px 30px rgba(0,0,0,.04);
    display:flex;
    flex-direction:column;
  }
  .beneficio-card figure{
    margin:0;
    overflow:hidden;
  }
  .beneficio-card img{
    width:100%;
    height:220px;
    object-fit:cover;
    display:block;
  }
  .beneficio-card .beneficio-body{
    padding:16px 18px 18px;
  }
  .beneficio-card h3{
    margin:0 0 6px;
    font-size:18px;
  }
  .beneficio-card p{
    margin:0;
    font-size:14px;
    color:var(--muted);
  }

  @media (max-width:980px){
    .beneficios-grid{
      grid-template-columns:repeat(2,minmax(0,1fr));
    }
    .beneficio-card img{
      height:190px;
    }
  }
  @media (max-width:640px){
    .beneficios-grid{
      grid-template-columns:1fr;
    }
    .beneficio-card img{
      height:200px;
    }
  }
</style>

<style>
  /* ===== Mejora visual submenú Servicios/Beneficios ===== */
  .nav-links .nav-item{
    position:relative;
  }

  .nav-links .nav-item > a{
    display:flex;
    align-items:center;
    gap:6px;
  }

  .nav-links .nav-item .chevron{
    font-size:14px;
    opacity:0.85;
    transform-origin:center;
    transition:transform .18s ease, opacity .18s ease;
    margin-top:1px;
  }

  .nav-links .nav-item:hover > a .chevron{
    transform:rotate(180deg);
    opacity:1;
  }

  .nav-links .submenu{
    position:absolute;
    top:100%;
    left:0;
    background:rgba(255,255,255,0.96);
    backdrop-filter:blur(10px);
    min-width:210px;
    border-radius:14px;
    box-shadow:
      0 20px 40px rgba(15,23,42,0.18),
      0 0 0 1px rgba(15,23,42,0.04);
    padding:8px 0;
    display:none;
    z-index:80;
    opacity:0;
    transform:translateY(8px);
    transition:opacity .18s ease, transform .18s ease;
  }

  .nav-links .nav-item:hover > .submenu{
    display:block;
    opacity:1;
    transform:translateY(0);
  }

  .nav-links .submenu::before{
    content:"";
    position:absolute;
    inset:0;
    border-radius:inherit;
    border-top:3px solid var(--accent, #0066ff);
    pointer-events:none;
  }

  .nav-links .submenu a{
    position:relative;
    z-index:1;
    display:block;
    padding:9px 16px;
    font-weight:500;
    font-size:14px;
    border-radius:0;
    white-space:nowrap;
  }

  .nav-links .submenu a:hover{
    background:rgba(15,23,42,0.06);
  }

  @media (max-width:980px){
    .nav-links .submenu{
      position:static;
      min-width:0;
      box-shadow:none;
      backdrop-filter:none;
      border-radius:10px;
      margin-top:4px;
      transform:none;
      opacity:1;
      padding:4px 0 4px 18px;
      display:block;
    }
    .nav-links .submenu::before{
      border-top:none;
    }
    .nav-links .submenu a{
      padding:6px 6px 6px 10px;
      font-size:13px;
    }
  }
</style>
