<?php
// dashboard.php o dashboard_fetra.php

error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

// Conexion del proyecto (db.php)
if (file_exists(__DIR__ . '/db.php')) {
    require __DIR__ . '/db.php';
}

// Usuario (cambiá la key si tu sesión usa otra cosa)
$usuario_nombre = isset($_SESSION['usuario']) ? $_SESSION['usuario'] : 'admin';
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Panel Fe.Tr.A – Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

  <style>
    body {
      background: #0f172a;
      font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
      color: #e5e7eb;
    }
    .navbar {
      background: linear-gradient(90deg, #0f172a, #1e293b);
      border-bottom: 1px solid rgba(148, 163, 184, 0.3);
    }
    .navbar-brand {
      font-weight: 700;
      letter-spacing: .03em;
      font-size: 0.98rem;
    }
    .brand-pill {
      display:inline-flex;
      align-items:center;
      gap:.4rem;
      padding:.25rem .6rem;
      border-radius:999px;
      background:rgba(15,23,42,.85);
      border:1px solid rgba(148,163,184,.5);
      font-size:.72rem;
      text-transform:uppercase;
      letter-spacing:.12em;
      color:#e5e7eb;
    }
    .dashboard-wrapper {
      padding: 2rem 1rem 3rem;
    }
    @media (min-width: 992px) {
      .dashboard-wrapper {
        padding: 3rem;
      }
    }
    .section-title {
      font-size: 1.4rem;
      font-weight: 600;
      margin-bottom: .4rem;
    }
    .section-subtitle {
      font-size: .9rem;
      color: #9ca3af;
      margin-bottom: 1.4rem;
    }
    .card-dashboard {
      background: radial-gradient(circle at top left, rgba(59,130,246,.25), transparent 55%),
                  radial-gradient(circle at bottom right, rgba(56,189,248,.18), transparent 55%),
                  #020617;
      border-radius: 1rem;
      border: 1px solid rgba(148, 163, 184, 0.35);
      padding: 1.1rem 1.05rem;
      height: 100%;
      position: relative;
      overflow: hidden;
      transition: transform .15s ease, box-shadow .15s ease, border-color .15s ease, background .2s ease;
    }
    .card-dashboard:hover {
      transform: translateY(-3px);
      box-shadow: 0 20px 45px rgba(15, 23, 42, 0.9);
      border-color: rgba(96, 165, 250, 0.7);
      background: radial-gradient(circle at top left, rgba(59,130,246,.35), transparent 55%),
                  radial-gradient(circle at bottom right, rgba(56,189,248,.27), transparent 55%),
                  #020617;
    }
    .card-icon {
      width: 2.3rem;
      height: 2.3rem;
      border-radius: .9rem;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      margin-bottom: .75rem;
      background: rgba(15,23,42,.9);
      border: 1px solid rgba(148,163,184,.6);
      font-size: 1.15rem;
    }
    .card-title {
      font-size: 1rem;
      font-weight: 600;
      margin-bottom: .3rem;
      color: #e5e7eb;
    }
    .card-text {
      font-size: .85rem;
      color: #9ca3af;
      margin-bottom: .8rem;
      min-height: 2.1em;
    }
    .btn-ghost {
      font-size: .8rem;
      padding: .35rem .8rem;
      border-radius: 999px;
      border: 1px solid rgba(148,163,184,.7);
      background: rgba(15,23,42,.7);
      color: #e5e7eb;
    }
    .btn-ghost i {
      font-size: .75rem;
    }
    .btn-ghost:hover {
      background: rgba(37,99,235,.95);
      border-color: rgba(59,130,246,1);
      color: #f9fafb;
    }
    .user-pill {
      font-size: .75rem;
      padding: .2rem .6rem;
      border-radius: 999px;
      border: 1px solid rgba(148,163,184,.4);
      color:#e5e7eb;
      background:rgba(15,23,42,.8);
      display:inline-flex;
      align-items:center;
      gap:.35rem;
    }
    .user-pill i{
      font-size:.75rem;
    }
  </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark">
  <div class="container-fluid px-3 px-lg-4">
    <a class="navbar-brand d-flex align-items-center gap-2" href="#">
      <i class="fa-solid fa-truck-moving"></i>
      <span>Fe.Tr.A · Panel</span>
    </a>
    <div class="ms-auto d-flex align-items-center gap-2">
      <span class="brand-pill d-none d-sm-inline-flex">
        <i class="fa-solid fa-gauge-high"></i>
        Dashboard
      </span>
      <span class="user-pill">
        <i class="fa-solid fa-user-shield"></i>
        <span><?php echo htmlspecialchars($usuario_nombre, ENT_QUOTES, 'UTF-8'); ?></span>
      </span>
    </div>
  </div>
</nav>

<main class="dashboard-wrapper">
  <div class="container-fluid px-2 px-lg-1">

    <div class="row mb-4">
      <div class="col-12 col-lg-8">
        <h1 class="h4 mb-1">Panel de administración Fe.Tr.A</h1>
        <p class="text-secondary small mb-0">
          Elegí qué querés administrar: noticias, publicidad o tarifas.
        </p>
      </div>
    </div>

    <div class="row g-3 g-lg-4">
      <!-- Noticias -->
      <div class="col-12 col-md-4">
        <div class="card-dashboard">
          <div class="card-icon"><i class="fa-solid fa-newspaper"></i></div>
          <div class="card-title">Noticias</div>
          <p class="card-text">Carga y edición de noticias que se muestran en la web.</p>
          <a href="../admin_noticias.php" class="btn btn-ghost btn-sm">
            <i class="fa-solid fa-arrow-right"></i> Ir a noticias
          </a>
        </div>
      </div>

      <!-- Publicidad -->
      <div class="col-12 col-md-4">
        <div class="card-dashboard">
          <div class="card-icon"><i class="fa-solid fa-rectangle-ad"></i></div>
          <div class="card-title">Publicidad</div>
          <p class="card-text">Banners, espacios de publicidad y piezas gráficas.</p>
          <a href="../admin_publicidad.php" class="btn btn-ghost btn-sm">
            <i class="fa-solid fa-arrow-right"></i> Ir a publicidad
          </a>
        </div>
      </div>

      <!-- Tarifas -->
      <div class="col-12 col-md-4">
        <div class="card-dashboard">
          <div class="card-icon"><i class="fa-solid fa-dollar-sign"></i></div>
          <div class="card-title">Tarifas</div>
          <p class="card-text">Gestión de tarifas, valores y cuadros de referencia.</p>
          <a href="../admin_tarifas.php" class="btn btn-ghost btn-sm">
            <i class="fa-solid fa-arrow-right"></i> Ir a tarifas
          </a>
        </div>
      </div>
    </div>

  </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
