<?php
session_start(); if(empty($_SESSION['admin'])){ header('Location: /admin/login.php'); exit; }
require __DIR__.'/../db.php'; $pdo=pdo();
require __DIR__.'/upload.php';
if (($_POST['csrf'] ?? '') !== ($_SESSION['csrf'] ?? '')) { exit('CSRF'); }

$id=(int)($_POST['id']??0);
$titulo=trim($_POST['titulo']??''); $slug=trim($_POST['slug']??'');
$resumen=trim($_POST['resumen']??''); $estado=(($_POST['estado']??'borrador')==='publicado')?'publicado':'borrador';
$publicado_en=trim($_POST['publicado_en']??'') ?: null;
if($titulo===''||$slug===''){ exit('Falta título/slug'); }

$pdo->beginTransaction();
try{
  $portada=null;
  if(!empty($_FILES['portada']['name'])) $portada=save_file('portada',['jpg','jpeg','png','webp']);
  else if($id) $portada=$pdo->query("SELECT portada FROM notas WHERE id=".$id)->fetchColumn();

  if($id){
    $pdo->prepare("UPDATE notas SET titulo=?,slug=?,resumen=?,portada=?,estado=?,publicado_en=? WHERE id=?")
        ->execute([$titulo,$slug,$resumen,$portada,$estado,$publicado_en,$id]);
    $nota_id=$id;
    $pdo->prepare("DELETE FROM nota_bloques WHERE nota_id=?")->execute([$nota_id]);
  }else{
    $pdo->prepare("INSERT INTO notas (titulo,slug,resumen,portada,estado,publicado_en) VALUES (?,?,?,?,?,?)")
        ->execute([$titulo,$slug,$resumen,$portada,$estado,$publicado_en]);
    $nota_id=(int)$pdo->lastInsertId();
  }

  foreach(($_POST['blocks']??[]) as $i=>$b){
    $tipo=$b['tipo']??'texto'; $orden=(int)($b['orden']??($i*10)); $data=[];
    if($tipo==='texto'){ $data=['html'=>$b['html']??'']; }
    elseif($tipo==='imagen'){ $src=save_file("blocks_file_$i",['jpg','jpeg','png','webp']) ?: ($b['src']??null); $data=['src'=>$src,'alt'=>$b['alt']??'','caption'=>$b['caption']??'','link'=>$b['link']??'']; }
    elseif($tipo==='video'){ $data=['url'=>$b['url']??'','caption'=>$b['caption']??'']; }
    elseif($tipo==='audio'){ $src=save_file("blocks_file_$i",['mp3','ogg','wav']) ?: ($b['src']??null); $data=['src'=>$src,'caption'=>$b['caption']??'']; }
    elseif($tipo==='link'){ $img=save_file("blocks_file_$i",['jpg','jpeg','png','webp']) ?: ($b['img']??null); $data=['href'=>$b['href']??'','label'=>$b['label']??'','img'=>$img]; }
    $pdo->prepare("INSERT INTO nota_bloques (nota_id,orden,tipo,data) VALUES (?,?,?,?)")
        ->execute([$nota_id,$orden,$tipo,json_encode($data,JSON_UNESCAPED_UNICODE)]);
  }

  $pdo->commit();
  header("Location: /admin/nota_edit.php?id=".$nota_id."&ok=1");
} catch(Throwable $e){
  if($pdo->inTransaction()) $pdo->rollBack();
  http_response_code(500); echo "Error guardando: ".$e->getMessage();
}
