(() => {
  const CFG = window.__ADS_CONF__ || {page: 'index', api: 'ads_api.php', edit: false};

  // ===== util
  const $ = (s, r=document) => r.querySelector(s);
  const el = (tag, props={}) => Object.assign(document.createElement(tag), props);
  const clamp01 = v => Math.max(0, Math.min(100, v));
  const fetchJSON = (url, opts) => fetch(url, opts).then(r => r.json());

  // ===== state
  let items = [];
  let selected = null;

  // ===== overlay fijo (siempre visible para render)
  const overlay = el('div', {className:'ads-overlay'});
  Object.assign(overlay.style, {
    position:'fixed', inset:'0', pointerEvents:'none', zIndex:'2147483647'
  });
  document.addEventListener('DOMContentLoaded', () => document.body.appendChild(overlay));

  // ===== styles
  const css = `
    .ads-box{position:absolute;border:1px dashed #1f72b6;background:rgba(31,114,182,.07);border-radius:10px;overflow:hidden;pointer-events:auto}
    .ads-box.disabled{opacity:.45;filter:grayscale(.4)}
    .ads-bar{position:absolute;left:0;top:0;right:0;background:#1f72b6;color:#fff;padding:6px 8px;font:12px/1 system-ui;display:flex;justify-content:space-between;align-items:center;cursor:move}
    .ads-handle{position:absolute;right:0;bottom:0;padding:6px 8px;background:#1f72b6;color:#fff;font:12px/1 system-ui;border-top-left-radius:8px;cursor:nwse-resize}
    .ads-ghost{outline:2px dashed rgba(31,114,182,.6); outline-offset:2px}

    /* panel lateral (solo en modo edición) */
    .ads-panel{position:fixed;top:0;right:0;width:340px;height:100vh;background:#fff;border-left:1px solid #e6eaf0;box-shadow:-12px 0 30px rgba(15,26,36,.06);z-index:2147483647;padding:12px;display:flex;flex-direction:column;gap:10px}
    .ads-panel h3{margin:4px 0 2px;font:600 13px/1.2 system-ui;color:#0f1a24}
    .ads-input{width:100%;border:1px solid #dbe3ed;border-radius:10px;padding:8px 10px;font:14px system-ui}
    .ads-row{display:grid;grid-template-columns:1fr 1fr;gap:8px}
    .ads-btn{border:1px solid #cfd8e3;background:#fff;border-radius:10px;padding:8px 10px;cursor:pointer}
    .ads-btn.primary{background:#1f72b6;color:#fff;border-color:#1f72b6}
    .ads-list{overflow:auto;border:1px solid #edf0f5;border-radius:10px;padding:8px;max-height:32vh}
    .ads-item{display:flex;justify-content:space-between;gap:8px;border:1px solid #edf0f5;border-radius:10px;padding:6px 8px;margin-bottom:6px}
    .ads-hint{font:12px/1.4 system-ui;color:#6b7480}
  `;
  const styleTag = el('style', {textContent: css});
  document.head.appendChild(styleTag);

  // ===== draw
  function drawAll(){
    overlay.innerHTML = '';
    items.forEach(drawItem);
  }
  function drawItem(it){
    const box = el('div', {className: 'ads-box'+(it.is_active?'':' disabled')});
    box.dataset.id = it.id;
    Object.assign(box.style, {
      left: it.x_pct+'%', top: it.y_pct+'%', width: it.w_pct+'%',
      height: it.h_pct!=null ? it.h_pct+'%' : '', zIndex: it.zindex
    });

    // content
    const content = el('div');
    Object.assign(content.style, {position:'relative',width:'100%',height:'100%',background:'transparent'});

    if (it.type==='section'){
      content.innerHTML = `<div style="position:absolute;inset:0;background:#15324c;color:#fff;display:flex;align-items:center;padding:12px 16px;font-weight:700;border-radius:8px">${it.title||'Sección'}</div>`;
    } else if (it.type==='image' && it.media_url){
      content.innerHTML = `<img src="${it.media_url}" style="width:100%;height:100%;object-fit:contain;display:block">`;
    } else if (it.type==='video'){
      const mu = it.media_url||'';
      if (/youtu\.?be/.test(mu)){
        const m = mu.match(/(?:v=|\.be\/)([\w-]+)/); const id = m && m[1] || '';
        content.innerHTML = id ? `<iframe src="https://www.youtube.com/embed/${id}" allow="autoplay;encrypted-media" allowfullscreen style="width:100%;height:100%;border:0"></iframe>` : `<div style="padding:12px">URL YouTube inválida</div>`;
      } else if (mu){
        content.innerHTML = `<video src="${mu}" controls style="width:100%;height:100%;object-fit:cover"></video>`;
      }
    } else if (it.type==='html'){
      content.innerHTML = it.html || '';
    } else if (it.type==='link'){
      const label = it.title || it.link_url || 'Link';
      const href = it.link_url || '#';
      content.innerHTML = `<a href="${href}" target="_blank" style="position:absolute;inset:8px;display:flex;align-items:center;justify-content:center;border:2px dashed #1f72b6;border-radius:8px;text-decoration:none;color:#1f72b6;font-weight:600;background:#fff">${label}</a>`;
    }

    // chrome (solo en edición)
    if (CFG.edit){
      const bar = el('div', {className:'ads-bar'});
      bar.innerHTML = `<div><b>${it.type}</b> <span style="opacity:.85">${it.title||''}</span></div>
                       <div style="display:flex;gap:6px">
                         <button class="ads-btn" data-act="zup">▲</button>
                         <button class="ads-btn" data-act="zdown">▼</button>
                         <button class="ads-btn" data-act="toggle">on/off</button>
                         <button class="ads-btn" data-act="del">🗑</button>
                       </div>`;
      const handle = el('div', {className:'ads-handle', textContent:'↘'});
      box.append(bar, content, handle);

      box.addEventListener('pointerdown', e => { select(it.id); e.stopPropagation(); });
      bar.addEventListener('pointerdown', e => startDrag(it, box, e));
      handle.addEventListener('pointerdown', e => startResize(it, box, e));
      bar.addEventListener('click', (e)=>{
        const b=e.target.closest('button'); if(!b) return;
        const act=b.dataset.act;
        if (act==='del'){ if(confirm('¿Eliminar?')) { items = items.filter(x=>x.id!==it.id); drawAll(); buildList(); if (selected===it.id) selected=null; } }
        if (act==='toggle'){ it.is_active = it.is_active?0:1; drawAll(); highlight(); buildList(); }
        if (act==='zup'){ it.zindex++; drawAll(); highlight(); buildList(); }
        if (act==='zdown'){ it.zindex = Math.max(0, it.zindex-1); drawAll(); highlight(); buildList(); }
      });
    } else {
      box.append(content);
    }

    overlay.appendChild(box);
  }
  function select(id){ selected = id; highlight(); buildProps(); }
  function highlight(){
    overlay.querySelectorAll('.ads-box').forEach(n => n.classList.toggle('ads-ghost', +n.dataset.id===selected));
  }

  // ===== drag/resize
  let drag=null, rez=null;
  function rect(){ const r=overlay.getBoundingClientRect(); return {W:r.width, H:r.height}; }
  function startDrag(it, el, ev){
    ev.preventDefault(); const {W,H}=rect();
    drag={it, el, sx:ev.clientX, sy:ev.clientY, ox:it.x_pct, oy:it.y_pct, W, H};
    window.addEventListener('pointermove', onDrag);
    window.addEventListener('pointerup', endDrag, {once:true});
  }
  function onDrag(ev){
    if(!drag) return;
    const speed = ev.shiftKey?2:1;
    const dx=(ev.clientX-drag.sx)*speed, dy=(ev.clientY-drag.sy)*speed;
    let nx=drag.ox+(dx/drag.W)*100, ny=drag.oy+(dy/drag.H)*100;
    drag.it.x_pct=clamp01(nx); drag.it.y_pct=clamp01(ny);
    Object.assign(drag.el.style, {left:drag.it.x_pct+'%', top:drag.it.y_pct+'%'});
  }
  function endDrag(){ window.removeEventListener('pointermove', onDrag); drag=null; buildProps(); }

  function startResize(it, el, ev){
    ev.preventDefault(); const {W,H}=rect();
    rez={it, el, sx:ev.clientX, sy:ev.clientY, ow:it.w_pct, oh:it.h_pct??null, W, H};
    window.addEventListener('pointermove', onResize);
    window.addEventListener('pointerup', endResize, {once:true});
  }
  function onResize(ev){
    if(!rez) return;
    const dx=ev.clientX-rez.sx, dy=ev.clientY-rez.sy;
    let nw=rez.ow+(dx/rez.W)*100; nw=Math.max(5, clamp01(nw)); rez.it.w_pct=nw;
    if (rez.it.h_pct!=null){ let nh=(rez.oh??rez.it.h_pct)+(dy/rez.H)*100; nh=Math.max(5, clamp01(nh)); rez.it.h_pct=nh; }
    drawAll(); select(rez.it.id);
  }
  function endResize(){ window.removeEventListener('pointermove', onResize); rez=null; buildProps(); }

  // ===== panel de edición (solo en modo edit)
  let panel, uploader;
  function mountPanel(){
    if (!CFG.edit) return;
    panel = el('div', {className:'ads-panel'});
    panel.innerHTML = `
      <div style="display:flex;gap:6px">
        <button class="ads-btn" data-add="section">Section</button>
        <button class="ads-btn" data-add="image">Imagen</button>
        <button class="ads-btn" data-add="video">Video</button>
        <button class="ads-btn" data-add="html">HTML</button>
        <button class="ads-btn" data-add="link">Link</button>
      </div>

      <h3>Propiedades</h3>
      <div id="ads-props" class="ads-hint">Seleccioná un bloque</div>

      <h3>Listado</h3>
      <div id="ads-list" class="ads-list"></div>

      <div style="display:flex;gap:8px;margin-top:auto">
        <button class="ads-btn" id="ads-reload">Recargar</button>
        <button class="ads-btn primary" id="ads-save">Guardar</button>
      </div>

      <input id="ads-upload" type="file" hidden accept="image/*,video/*">
      <div class="ads-hint" style="margin-top:6px">Arrastrá para mover, ↘ para redimensionar. Shift=rápido, Alt=micro. PageUp/PageDown cambia Z. Supr borra.</div>
    `;
    document.body.appendChild(panel);
    panel.querySelectorAll('[data-add]').forEach(b => b.addEventListener('click', () => addItem(b.dataset.add)));
    $('#ads-reload').onclick = load;
    $('#ads-save').onclick = save;
    uploader = $('#ads-upload');
  }

  function addItem(type){
    const it = {
      id: 0, page_slug: CFG.page, type, title:'', media_url:'', link_url:'', html:'',
      x_pct:10, y_pct:10, w_pct:30, h_pct: (type==='section'?12:null), zindex:10, is_active:1
    };
    if(type==='link'){ it.title='Ver más'; it.link_url='#'; it.w_pct=15; }
    if(type==='video'){ it.w_pct=35; }
    if(type==='section'){ it.title='Sección'; it.x_pct=0; it.w_pct=100; it.zindex=5; }
    items.push(it); drawAll(); buildList(); select(it.id);
  }

  function buildList(){
    if (!CFG.edit) return;
    const list = $('#ads-list'); if (!list) return;
    list.innerHTML = items.map(i => `
      <div class="ads-item">
        <div><b>#${i.id}</b> <span style="opacity:.7">${i.type}</span> ${i.title? '— '+i.title:''}</div>
        <div style="display:flex;gap:6px">
          <button class="ads-btn" data-jump="${i.id}">Ir</button>
          <button class="ads-btn" data-del="${i.id}">🗑</button>
        </div>
      </div>`).join('') || '<div class="ads-hint">No hay bloques.</div>';

    list.querySelectorAll('[data-jump]').forEach(b => b.onclick = ()=> select(+b.dataset.jump));
    list.querySelectorAll('[data-del]').forEach(b => b.onclick = ()=>{ const id=+b.dataset.del; if(confirm('¿Eliminar?')){ items = items.filter(i=>i.id!==id); drawAll(); buildList(); if(selected===id) selected=null; }});
  }

  function buildProps(){
    if (!CFG.edit) return;
    const box = $('#ads-props'); if (!box) return;
    const it = items.find(i => i.id===selected);
    if (!it){ box.innerHTML='<span class="ads-hint">Seleccioná un bloque</span>'; return; }

    let spec = '';
    if (it.type!=='html'){
      spec += `<div class="ads-row" style="grid-template-columns:1fr auto">
        <input id="p_media" class="ads-input" placeholder="Media URL" value="${it.media_url||''}">
        <button class="ads-btn" id="p_upload">Subir</button>
      </div>`;
    }
    if (it.type==='video'){
      spec += `<div class="ads-hint">YouTube (https://youtu.be/ID o ?v=ID) o MP4 subido.</div>`;
    }
    if (it.type==='link' || it.type==='image'){
      spec += `<input id="p_link" class="ads-input" placeholder="Link URL" value="${it.link_url||''}">`;
    }
    if (it.type==='html'){
      spec += `<textarea id="p_html" class="ads-input" style="min-height:120px">${(it.html||'').replaceAll('<','&lt;')}</textarea>`;
    }

    box.innerHTML = `
      <input id="p_title" class="ads-input" placeholder="Título / Label" value="${it.title||''}">
      ${spec}
      <div class="ads-row">
        <div><div class="ads-hint">X%</div><input id="p_x" class="ads-input" value="${it.x_pct}"></div>
        <div><div class="ads-hint">Y%</div><input id="p_y" class="ads-input" value="${it.y_pct}"></div>
      </div>
      <div class="ads-row">
        <div><div class="ads-hint">W%</div><input id="p_w" class="ads-input" value="${it.w_pct}"></div>
        <div><div class="ads-hint">H% (vacío=auto)</div><input id="p_h" class="ads-input" value="${it.h_pct??''}"></div>
      </div>
      <div class="ads-row">
        <div><div class="ads-hint">Z</div><input id="p_z" class="ads-input" value="${it.zindex}"></div>
        <div><div class="ads-hint">Activo</div>
          <select id="p_en" class="ads-input">
            <option value="1" ${it.is_active? 'selected':''}>Sí</option>
            <option value="0" ${!it.is_active? 'selected':''}>No</option>
          </select>
        </div>
      </div>
      <div style="display:flex;gap:8px;margin-top:6px">
        <button class="ads-btn primary" id="p_apply">Aplicar</button>
      </div>
    `;

    $('#p_upload')?.addEventListener('click', () => { uploader.value=''; uploader.click(); });
    if (uploader){
      uploader.onchange = async () => {
        const f = uploader.files?.[0]; if(!f) return;
        const fd = new FormData(); fd.append('action','upload'); fd.append('file', f);
        const js = await fetchJSON(CFG.api, {method:'POST', body:fd});
        if (js.ok){ it.media_url = js.url; buildProps(); drawAll(); select(it.id); } else alert(js.error||'Upload fail');
      };
    }

    $('#p_apply').onclick = () => {
      it.title = $('#p_title')?.value||'';
      if (it.type!=='html') it.media_url = $('#p_media')?.value||'';
      if (it.type==='link' || it.type==='image') it.link_url = $('#p_link')?.value||'';
      if (it.type==='html') it.html = ($('#p_html')?.value||'').replaceAll('&lt;','<');
      it.x_pct = +($('#p_x')?.value||it.x_pct);
      it.y_pct = +($('#p_y')?.value||it.y_pct);
      it.w_pct = +($('#p_w')?.value||it.w_pct);
      const hv = $('#p_h')?.value; it.h_pct = hv===''? null : +hv;
      it.zindex = +($('#p_z')?.value||it.zindex);
      it.is_active = +($('#p_en')?.value||it.is_active);
      drawAll(); buildList();
    };
  }

  // teclado
  window.addEventListener('keydown', (e)=>{
    if (!CFG.edit || selected==null) return;
    const it = items.find(i=>i.id===selected); if (!it) return;
    const step = e.altKey?0.2:(e.shiftKey?5:1);
    if (['ArrowLeft','ArrowRight','ArrowUp','ArrowDown','Delete','PageUp','PageDown'].includes(e.key)) e.preventDefault();
    if (e.key==='ArrowLeft'){ if (e.ctrlKey) it.w_pct = Math.max(5, clamp01(it.w_pct-step)); else it.x_pct = clamp01(it.x_pct-step); }
    if (e.key==='ArrowRight'){ if (e.ctrlKey) it.w_pct = Math.max(5, clamp01(it.w_pct+step)); else it.x_pct = clamp01(it.x_pct+step); }
    if (e.key==='ArrowUp'){ if (e.ctrlKey && it.h_pct!=null) it.h_pct = Math.max(5, clamp01((it.h_pct||0)-step)); else it.y_pct = clamp01(it.y_pct-step); }
    if (e.key==='ArrowDown'){ if (e.ctrlKey && it.h_pct!=null) it.h_pct = Math.max(5, clamp01((it.h_pct||0)+step)); else it.y_pct = clamp01(it.y_pct+step); }
    if (e.key==='Delete'){ items = items.filter(x=>x.id!==it.id); selected=null; }
    if (e.key==='PageUp'){ it.zindex++; }
    if (e.key==='PageDown'){ it.zindex = Math.max(0, it.zindex-1); }
    drawAll(); buildList(); buildProps();
  });

  // ===== CRUD
  async function load(){
    const js = await fetchJSON(CFG.api+'?action=list&page='+encodeURIComponent(CFG.page));
    items = (js.items||[]).map(r => ({
      ...r,
      id:+r.id||r.id, x_pct:+r.x_pct, y_pct:+r.y_pct, w_pct:+r.w_pct,
      h_pct:r.h_pct===null?null:+r.h_pct, zindex:+r.zindex, is_active:+r.is_active
    }));
    drawAll(); buildList(); buildProps();
  }
  async function save(){
    const fd = new FormData();
    fd.append('action','save');
    fd.append('payload', JSON.stringify(items));
    const js = await fetchJSON(CFG.api, {method:'POST', body:fd});
    if (js.ok){ alert('Guardado'); await load(); } else alert(js.error||'Error al guardar');
  }

  // ===== init
  document.addEventListener('DOMContentLoaded', async () => {
    await load();
    if (CFG.edit){ mountPanel(); }
  });

})();
