<?php
// beneficios.php
require __DIR__ . '/db.php';
$pdo = pdo();

// asegurar tabla por si se entra primero por acá
$pdo->exec("CREATE TABLE IF NOT EXISTS beneficios (
  id INT AUTO_INCREMENT PRIMARY KEY,
  titulo VARCHAR(190) NOT NULL,
  descripcion TEXT NOT NULL,
  imagen VARCHAR(255) DEFAULT NULL,
  orden INT DEFAULT NULL,
  estado ENUM('borrador','publicado') NOT NULL DEFAULT 'publicado',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$stmt = $pdo->query("SELECT * FROM beneficios WHERE estado='publicado' ORDER BY COALESCE(orden, 9999), created_at DESC");
$beneficios = $stmt->fetchAll(PDO::FETCH_ASSOC);

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// Fecha en español para la franja
setlocale(LC_TIME, 'es_AR.UTF-8', 'es_AR', 'es_ES.UTF-8', 'es_ES', 'es');
date_default_timezone_set('America/Argentina/Buenos_Aires');
$meses = ['enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];
$dias  = ['Domingo','Lunes','Martes','Miércoles','Jueves','Viernes','Sábado'];
$txtFecha = $dias[(int)date('w')] . ' ' . date('j') . ' de ' . $meses[((int)date('n'))-1] . ' de ' . date('Y');
?><!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Beneficios | Fe.Tr.A</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <?php include '_head_assets.php'; ?>
</head>
<body>
  <style>
  .beneficio-card img{
      width:100%;
      height:auto;               /* se adapta a la imagen */
      max-height:420px;          /* límite por si alguno es muy alto */
      object-fit:contain;        /* NO recorta, muestra todo */
      display:block;
      background:#f3f4f6;        /* fondo gris suave si sobra espacio */
  }
  
  </style>
<?php include '_navbar.php'; ?>

<!-- DATE BAR -->
<div class="datebar">
  <div class="container inner"><span id="fecha-hoy">—</span></div>
</div>
<style>
/* Fecha */
.datebar{background:var(--navy);color:#fff;font-weight:600}
.datebar .inner{height:40px;display:flex;align-items:center}
</style>

<main>
  <section class="beneficios-hero">
    <div class="container">
      <p style="text-transform:uppercase; font-size:12px; letter-spacing:.18em; color:var(--muted); margin:0 0 6px;">Servicios</p>
      <h1>Beneficios para afiliados y transportistas</h1>
      <p>Accedé a los beneficios exclusivos que Fe.Tr.A gestiona para fortalecer la actividad y el bienestar de sus asociados.</p>
    </div>
  </section>

  <section>
    <div class="container">
      <?php if (!$beneficios): ?>
        <p class="text-muted">Próximamente vamos a publicar los beneficios disponibles.</p>
      <?php else: ?>
        <div class="beneficios-grid">
          <?php foreach ($beneficios as $b): ?>
            <article class="beneficio-card">
              <?php if (!empty($b['imagen'])): ?>
                <figure>
                  <img src="img/beneficios/<?php echo h($b['imagen']); ?>" alt="<?php echo h($b['titulo']); ?>">
                </figure>
              <?php endif; ?>
              <div class="beneficio-body">
                <h3><?php echo h($b['titulo']); ?></h3>
                <p><?php echo nl2br(h($b['descripcion'])); ?></p>
              </div>
            </article>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>
  </section>
</main>

<?php include '_footer.php'; ?>
<?php include '_navbar_script.php'; ?>

</body>
</html>
