<?php @session_start(); ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Contacto — Fe.Tr.A</title>
  <?php include __DIR__ . '/_head_assets.php'; ?>
  <style>
    /* Estilos locales del formulario (coherentes con tu diseño) */
    .contact-page{padding:40px 0}
    .contact-wrap{display:grid;grid-template-columns:1fr;gap:24px}
    .contact-card{background:#fff;border:1px solid rgba(0,0,0,.06);border-radius:16px;padding:22px}
    .contact-title{font-weight:800;font-size:clamp(20px,2.6vw,26px);margin:0 0 12px}
    .contact-sub{color:#6b7580;margin-bottom:14px}
    .grid-2{display:grid;grid-template-columns:1fr 1fr;gap:12px}
    @media (max-width:720px){.grid-2{grid-template-columns:1fr}}
    .input, textarea{
      width:100%;padding:12px 14px;border:1px solid #dfe6ee;border-radius:10px;
      font:inherit;background:#fff;outline:none
    }
    .input:focus, textarea:focus{border-color:#b7c9db;box-shadow:0 0 0 3px rgba(31,114,182,.08)}
    textarea{min-height:140px;resize:vertical}
    .btn{appearance:none;border:0;border-radius:10px;padding:12px 18px;font-weight:700;cursor:pointer;background:#1f72b6;color:#fff}
    .muted{color:#6b7580}
    .alert{border-radius:12px;padding:12px 14px;margin:0 0 16px;border:1px solid}
    .alert.ok{background:#eef8ee;border-color:#b9e2b9;color:#1a5e1a}
    .alert.err{background:#fff3f0;border-color:#ffccbf;color:#8a2c0f}
    /* Honeypot escondido pero presente en el DOM */
    .hp{position:absolute;left:-10000px;top:auto;width:1px;height:1px;overflow:hidden}
  </style>
</head>
<body>
  <?php include __DIR__ . '/_navbar.php'; ?>

  <!-- Franja azul de fecha -->
  <div class="datebar">
    <div class="container inner"><span id="fecha-hoy">—</span></div>
  </div>

  <main class="container contact-page">
    <?php if(isset($_GET['enviado'])): ?>
      <div class="alert ok">✅ Tu consulta fue enviada. ¡Gracias! Te responderemos a la brevedad.</div>
    <?php elseif(isset($_GET['error'])): ?>
      <div class="alert err">⚠️ No se pudo enviar el mensaje. Probá nuevamente o escribinos por WhatsApp.</div>
    <?php endif; ?>

    <div class="contact-wrap">
      <div class="contact-card">
        <h1 class="contact-title">Pongámonos en contacto</h1>
        <p class="contact-sub">Completá el formulario y te respondemos a la brevedad.</p>

        <form action="enviar.php" method="post" novalidate>
          <!-- Honeypot anti-bot: debe quedar vacío -->
          <div class="hp">
            <label>Empresa (dejar vacío)</label>
            <input type="text" name="empresa" autocomplete="off">
          </div>

          <div class="grid-2">
            <input class="input" type="text" name="nombre" placeholder="Nombre y apellido *" required>
            <input class="input" type="text" name="localidad" placeholder="Localidad">
          </div>

          <div class="grid-2" style="margin-top:12px">
            <input class="input" type="tel" name="telefono" placeholder="Teléfono / WhatsApp">
            <input class="input" type="email" name="email" placeholder="Email">
          </div>

          <div style="margin-top:12px">
            <textarea class="input" name="mensaje" placeholder="Tu consulta *" required></textarea>
          </div>

          <div style="display:flex;align-items:center;gap:12px;margin-top:14px">
            <button class="btn" type="submit">ENVIAR</button>
            <small class="muted">Al enviar aceptás nuestra política de privacidad.</small>
          </div>
        </form>
      </div>
    </div>
  </main>

  <?php include __DIR__ . '/_footer.php'; ?>
  <?php include __DIR__ . '/_navbar_script.php'; ?>
    <!-- Publicidad: imprime los objetos guardados para la página "servicios" -->
  <script src="admin_publicidad.php?action=embed&page=contacto"></script>
</body>
</html>
