<?php
// editar_producto_market.php
require __DIR__ . '/market_bootstrap.php';

if (!market_is_logged()) {
    header('Location: login_market.php');
    exit;
}
$pdo = market_pdo();
$U   = market_current_user();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { header('Location: perfil_market.php'); exit; }

$st = $pdo->prepare("SELECT * FROM market_productos WHERE id=? AND usuario_id=? LIMIT 1");
$st->execute([$id, $U['id']]);
$P = $st->fetch(PDO::FETCH_ASSOC);
if (!$P) { header('Location: perfil_market.php'); exit; }

// Acciones sobre fotos (portada / eliminar)
if (isset($_GET['del_foto'])) {
    $fid = (int)$_GET['del_foto'];
    $pdo->prepare("DELETE FROM market_productos_fotos WHERE id=? AND producto_id=?")
        ->execute([$fid, $id]);
    header("Location: editar_producto_market.php?id=".$id);
    exit;
}
if (isset($_GET['portada'])) {
    $fid = (int)$_GET['portada'];
    $pdo->prepare("UPDATE market_productos_fotos SET es_portada=0 WHERE producto_id=?")->execute([$id]);
    $pdo->prepare("UPDATE market_productos_fotos SET es_portada=1 WHERE id=? AND producto_id=?")
        ->execute([$fid,$id]);
    header("Location: editar_producto_market.php?id=".$id);
    exit;
}

// Leer fotos
$stF = $pdo->prepare("SELECT * FROM market_productos_fotos WHERE producto_id=? ORDER BY id ASC");
$stF->execute([$id]);
$fotos = $stF->fetchAll(PDO::FETCH_ASSOC);

$errores = [];
$ok      = '';

$titulo      = $P['titulo'];
$descripcion = $P['descripcion'];
$precio      = $P['precio'];
$modo_precio = $P['modo_precio'];
$ubicacion   = $P['ubicacion'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $titulo      = trim($_POST['titulo'] ?? '');
    $descripcion = trim($_POST['descripcion'] ?? '');
    $precio      = trim($_POST['precio'] ?? '');
    $modo_precio = ($_POST['modo_precio'] ?? 'consultar') === 'precio' ? 'precio' : 'consultar';
    $ubicacion   = trim($_POST['ubicacion'] ?? '');

    if ($titulo === '') {
        $errores[] = 'Poné un título para el producto.';
    }

    if (!$errores) {
        $precioVal = null;
        if ($modo_precio === 'precio' && $precio !== '') {
            $precioVal = (float)str_replace(',','.', $precio);
        }

        $stU = $pdo->prepare("
            UPDATE market_productos
               SET titulo=?, descripcion=?, precio=?, modo_precio=?, ubicacion=?
             WHERE id=? AND usuario_id=? LIMIT 1
        ");
        $stU->execute([$titulo,$descripcion,$precioVal,$modo_precio,$ubicacion,$id,$U['id']]);

        // Nuevas fotos
        if (!empty($_FILES['fotos']['name'][0])) {
            $total = count($_FILES['fotos']['name']);
            $tiene_portada = false;
            foreach ($fotos as $f) {
                if ($f['es_portada']) { $tiene_portada = true; break; }
            }

            for ($i = 0; $i < $total; $i++) {
                if ($_FILES['fotos']['error'][$i] !== UPLOAD_ERR_OK || $_FILES['fotos']['name'][$i] === '') continue;
                $tmp = [
                    'name'     => $_FILES['fotos']['name'][$i],
                    'type'     => $_FILES['fotos']['type'][$i],
                    'tmp_name' => $_FILES['fotos']['tmp_name'][$i],
                    'error'    => $_FILES['fotos']['error'][$i],
                    'size'     => $_FILES['fotos']['size'][$i],
                ];
                $_FILES['_mkfoto'] = $tmp;
                $ruta = market_upload_file('_mkfoto', null);
                unset($_FILES['_mkfoto']);

                if ($ruta) {
                    $es_portada = (!$tiene_portada && $i === 0) ? 1 : 0;
                    $stF2 = $pdo->prepare("
                        INSERT INTO market_productos_fotos (producto_id, archivo, es_portada)
                        VALUES (?, ?, ?)
                    ");
                    $stF2->execute([$id,$ruta,$es_portada]);
                }
            }
        }

        $ok = 'Producto actualizado correctamente.';
        // recargar fotos actualizadas
        $stF->execute([$id]);
        $fotos = $stF->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Editar producto - Marketplace</title>
    <?php require __DIR__ . '/_head_assets.php'; ?>
    <style>
        .mk-main {padding:2.5rem 0 3rem;background:#f4f6fb;}
        .mk-card {
            background:#fff;border-radius:18px;
            box-shadow:0 14px 30px rgba(0,0,0,0.12);
            overflow:hidden;max-width:1100px;margin:0 auto;
        }
        .mk-card-header {
            padding:1.5rem 1.75rem;
            background:linear-gradient(135deg,#0d6efd,#20c997);
            color:#fff;
        }
        .mk-card-header h1 {font-size:1.7rem;margin:0;font-weight:800;}
        .mk-card-header p {margin:.35rem 0 0;font-size:.9rem;opacity:.95;}
        .mk-card-body {padding:1.75rem;}
        .mk-label {font-weight:600;font-size:.9rem;}
        .mk-help {font-size:.8rem;color:#6c757d;}
        .btn-mk-primary {background:#0d6efd;border-color:#0d6efd;font-weight:700;}
        .btn-mk-primary:hover {background:#0b5ed7;border-color:#0b5ed7;}
        .mk-radio-chip label {
            border-radius:999px;padding:.3rem .8rem;
            border:1px solid #ced4da;font-size:.85rem;
            cursor:pointer;margin-right:.5rem;
        }
        .mk-radio-chip input:checked + label {
            background:#0d6efd;color:#fff;border-color:#0d6efd;
        }
        .mk-dropzone {
            border:2px dashed #b6bec8;border-radius:12px;
            padding:1rem 1.25rem;background:#f8f9fc;
            font-size:.9rem;
        }
        .mk-thumbs img {width:100%;height:110px;object-fit:cover;border-radius:10px;}
        .mk-thumb-actions .btn {width:100%;margin-top:.35rem;font-size:.8rem;}
    </style>
</head>
<body>
<?php require __DIR__ . '/_navbar.php'; ?>

<main class="mk-main">
    <div class="container">
        <div class="mk-card">
            <div class="mk-card-header">
                <h1>Editar producto</h1>
                <p>Actualizá datos y fotos de tu publicación.</p>
            </div>
            <div class="mk-card-body">
                <?php if ($errores): ?>
                    <div class="alert alert-danger">
                        <?php foreach ($errores as $e): ?>
                            <div><?= htmlspecialchars($e, ENT_QUOTES, 'UTF-8') ?></div>
                        <?php endforeach; ?>
                    </div>
                <?php elseif ($ok): ?>
                    <div class="alert alert-success"><?= htmlspecialchars($ok, ENT_QUOTES, 'UTF-8') ?></div>
                <?php endif; ?>

                <form method="post" enctype="multipart/form-data">
                    <div class="row g-4">
                        <div class="col-lg-7">
                            <div class="mb-3">
                                <label class="mk-label">Título del producto *</label>
                                <input class="form-control" type="text" name="titulo"
                                       value="<?= htmlspecialchars($titulo, ENT_QUOTES, 'UTF-8') ?>" required>
                            </div>

                            <div class="mb-3">
                                <label class="mk-label">Descripción</label>
                                <textarea class="form-control" name="descripcion" rows="5"><?= htmlspecialchars($descripcion, ENT_QUOTES, 'UTF-8') ?></textarea>
                            </div>

                            <div class="row g-3 mb-3">
                                <div class="col-md-6">
                                    <label class="mk-label d-block mb-1">Precio</label>
                                    <div class="mk-radio-chip mb-2">
                                        <input type="radio" class="btn-check" name="modo_precio" id="mp1" value="precio" <?= $modo_precio==='precio'?'checked':''; ?>>
                                        <label for="mp1">Mostrar precio</label>

                                        <input type="radio" class="btn-check" name="modo_precio" id="mp2" value="consultar" <?= $modo_precio!=='precio'?'checked':''; ?>>
                                        <label for="mp2">Consultar precio</label>
                                    </div>
                                    <input class="form-control" type="text" name="precio"
                                           value="<?= htmlspecialchars($precio, ENT_QUOTES, 'UTF-8') ?>"
                                           placeholder="Ej: 150000">
                                    <div class="mk-help mt-1">Si marcás “Consultar precio”, este valor no se mostrará.</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="mk-label">Ubicación</label>
                                    <input class="form-control" type="text" name="ubicacion"
                                           value="<?= htmlspecialchars($ubicacion, ENT_QUOTES, 'UTF-8') ?>"
                                           placeholder="Ej: Bahía Blanca, Buenos Aires">
                                </div>
                            </div>

                            <div class="mb-4">
                                <label class="mk-label">Agregar nuevas fotos</label>
                                <div class="mk-dropzone mb-2">
                                    <span class="d-block mk-help">Podés sumar más imágenes. La portada se elige a la derecha.</span>
                                    <input class="form-control mt-2" type="file" name="fotos[]" multiple accept="image/*">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-5">
                            <label class="mk-label d-block mb-2">Galería actual</label>
                            <?php if (!$fotos): ?>
                                <p class="text-muted">Todavía no subiste fotos para este producto.</p>
                            <?php else: ?>
                                <div class="row g-3 mk-thumbs">
                                    <?php foreach ($fotos as $F): ?>
                                        <div class="col-6">
                                            <img src="<?= htmlspecialchars($F['archivo'], ENT_QUOTES, 'UTF-8') ?>" alt="">
                                            <div class="mk-thumb-actions">
                                                <?php if ($F['es_portada']): ?>
                                                    <button type="button" class="btn btn-success btn-sm" disabled>Portada</button>
                                                <?php else: ?>
                                                    <a href="editar_producto_market.php?id=<?= $id ?>&portada=<?= (int)$F['id'] ?>"
                                                       class="btn btn-outline-success btn-sm">Hacer portada</a>
                                                <?php endif; ?>
                                                <a href="editar_producto_market.php?id=<?= $id ?>&del_foto=<?= (int)$F['id'] ?>"
                                                   class="btn btn-outline-danger btn-sm"
                                                   onclick="return confirm('¿Eliminar esta foto?');">Eliminar</a>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="mt-4 d-flex flex-wrap gap-2">
                        <button type="submit" class="btn btn-mk-primary">
                            Guardar cambios
                        </button>
                        <a href="ver_producto_market.php?id=<?= $id ?>" class="btn btn-outline-secondary">
                            Ver publicación
                        </a>
                        <a href="perfil_market.php" class="btn btn-outline-dark">
                            Volver a mi perfil
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>

<?php require __DIR__ . '/_footer.php'; ?>
<?php require __DIR__ . '/_navbar_script.php'; ?>
</body>
</html>
