<?php
// estado_puerto.php
require __DIR__ . '/db.php';
$pdo = pdo();

// asegurar tabla (coincide con admin_estado_puerto.php)
$pdo->exec("CREATE TABLE IF NOT EXISTS estado_puerto (
  id INT AUTO_INCREMENT PRIMARY KEY,
  titulo VARCHAR(190) NOT NULL,
  estado ENUM('NORMAL','DEMORA','PARO','OTRO') NOT NULL DEFAULT 'NORMAL',
  descripcion TEXT,
  fecha DATE DEFAULT NULL,
  visible TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

// traer datos visibles
$stmt = $pdo->query("
  SELECT id, titulo, estado, descripcion, fecha
  FROM estado_puerto
  WHERE visible = 1
  ORDER BY fecha DESC, id DESC
");
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// Fecha en español para la franja (MISMA LÓGICA QUE BENEFICIOS)
setlocale(LC_TIME, 'es_AR.UTF-8', 'es_AR', 'es_ES.UTF-8', 'es_ES', 'es');
date_default_timezone_set('America/Argentina/Buenos_Aires');
$meses = ['enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];
$dias  = ['Domingo','Lunes','Martes','Miércoles','Jueves','Viernes','Sábado'];
$txtFecha = $dias[(int)date('w')] . ' ' . date('j') . ' de ' . $meses[((int)date('n'))-1] . ' de ' . date('Y');
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Estado de puerto | Fe.Tr.A</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <?php include '_head_assets.php'; ?>
</head>
<body>

<?php include '_navbar.php'; ?>

<!-- ✅ FRANJA AZUL IGUAL QUE EN BENEFICIOS -->
<div class="datebar">
  <div class="container inner">
    <span><?php echo h($txtFecha); ?></span>
  </div>
</div>

<main>
  <section class="beneficios-hero">
    <div class="container">
      <p style="text-transform:uppercase; font-size:12px; letter-spacing:.18em; color:var(--muted); margin:0 0 6px;">
        Servicios
      </p>
      <h1>Estado de puerto</h1>
      <p>
        Información actualizada sobre el estado operativo de los puertos, demoras, paros y novedades
        relevantes para los transportadores.
      </p>
    </div>
  </section>

  <section>
    <div class="container">
      <?php if (!$items): ?>
        <p class="text-muted">No hay novedades cargadas en este momento. Volvé a consultar más tarde.</p>
      <?php else: ?>
        <div class="beneficios-grid">
          <?php foreach ($items as $it): 
            $estado = $it['estado'] ?? 'NORMAL';

            // color del badge por estado (TODO inline para no depender de CSS global)
            $badgeColor = '#2b8a3e'; // NORMAL
            if ($estado === 'DEMORA') $badgeColor = '#d39e00';
            if ($estado === 'PARO')   $badgeColor = '#c92a2a';
            if ($estado === 'OTRO')   $badgeColor = '#495057';
          ?>
            <article class="beneficio-card">
              <div class="beneficio-body">
                <div style="display:flex; justify-content:space-between; gap:8px; align-items:flex-start;">
                  <h3 style="margin:0 0 4px 0;"><?php echo h($it['titulo']); ?></h3>
                  <span style="
                    display:inline-block;
                    padding:3px 10px;
                    border-radius:999px;
                    font-size:11px;
                    font-weight:600;
                    letter-spacing:.04em;
                    text-transform:uppercase;
                    color:#fff;
                    background:<?php echo $badgeColor; ?>;
                    white-space:nowrap;
                  ">
                    <?php echo h($estado); ?>
                  </span>
                </div>

                <?php if (!empty($it['fecha'])): ?>
                  <p style="margin:0 0 6px 0; font-size:12px; color:var(--muted);">
                    Fecha: <?php echo h(date('d/m/Y', strtotime($it['fecha']))); ?>
                  </p>
                <?php endif; ?>

                <?php if (!empty($it['descripcion'])): ?>
                  <p style="margin:0; font-size:14px; line-height:1.5;">
                    <?php echo nl2br(h($it['descripcion'])); ?>
                  </p>
                <?php endif; ?>
              </div>
            </article>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>
  </section>
</main>

<?php include '_footer.php'; ?>
<?php include '_navbar_script.php'; ?>

</body>
</html>
