<?php
// login_market.php
require __DIR__ . '/market_bootstrap.php';

$errores = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email'] ?? '');
    $password = (string)($_POST['password'] ?? '');

    if ($email === '' || $password === '') {
        $errores[] = 'Completá email y contraseña.';
    } else {
        $pdo = market_pdo();
        $st = $pdo->prepare("SELECT * FROM market_usuarios WHERE email = ? AND activo = 1 LIMIT 1");
        $st->execute([$email]);
        $U = $st->fetch(PDO::FETCH_ASSOC);

        if (!$U || !password_verify($password, $U['password_hash'])) {
            $errores[] = 'Email o contraseña incorrectos.';
        } else {
            $_SESSION['market_user_id'] = (int)$U['id'];
            header('Location: market.php');
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Iniciar sesión - Marketplace</title>
    <?php require __DIR__ . '/_head_assets.php'; ?>
    <style>
        :root {
            --mk-primary: #0077ff;
            --mk-primary-light: #00c0ff;
            --mk-primary-dark: #0059c4;
            --mk-secondary: #6c757d;
            --mk-dark: #212529;
            --mk-light: #f6f7fb;
            --mk-border: #e3e4ec;
            --mk-shadow: 0 20px 45px rgba(0,0,0,0.35);
            --mk-shadow-hover: 0 25px 60px rgba(0,0,0,0.45);
            --mk-radius: 20px;
            --mk-radius-sm: 12px;
        }

        body {
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        .mk-auth-bg {
            min-height: calc(100vh - 80px);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            background: 
                radial-gradient(circle at 20% 80%, rgba(0, 119, 255, 0.15) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(0, 192, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(0, 59, 92, 0.2) 0%, transparent 50%),
                linear-gradient(135deg, #001b2b 0%, #000b14 100%);
            position: relative;
            overflow: hidden;
        }

        .mk-auth-bg::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M11 18c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm48 25c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm-43-7c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm63 31c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM34 90c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm56-76c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM12 86c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm28-65c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm23-11c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-6 60c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm29 22c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zM32 63c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm57-13c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-9-21c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM60 91c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM35 41c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM12 60c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2z' fill='%230077ff' fill-opacity='0.03' fill-rule='evenodd'/%3E%3C/svg%3E");
            opacity: 0.4;
        }

        .mk-card-auth {
            max-width: 440px;
            width: 100%;
            background: #ffffff;
            border-radius: var(--mk-radius);
            box-shadow: var(--mk-shadow);
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            position: relative;
            z-index: 2;
        }

        .mk-card-auth:hover {
            transform: translateY(-5px);
            box-shadow: var(--mk-shadow-hover);
        }

        .mk-card-auth-header {
            padding: 2rem 2.5rem 1.5rem;
            background: linear-gradient(135deg, var(--mk-primary), var(--mk-primary-light));
            color: #fff;
            position: relative;
            overflow: hidden;
            text-align: center;
        }

        .mk-card-auth-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255,255,255,0.15), transparent);
            transform: rotate(45deg);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0% { transform: translateX(-100%) rotate(45deg); }
            100% { transform: translateX(100%) rotate(45deg); }
        }

        .mk-login-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            display: block;
        }

        .mk-card-auth-header h1 {
            font-size: 1.8rem;
            margin: 0 0 0.5rem 0;
            font-weight: 700;
            position: relative;
            z-index: 2;
        }

        .mk-card-auth-header p {
            margin: 0;
            opacity: 0.95;
            font-size: 0.95rem;
            font-weight: 500;
            position: relative;
            z-index: 2;
        }

        .mk-card-auth-body {
            padding: 2rem 2.5rem 1.5rem;
        }

        .mk-card-auth-footer {
            padding: 1.5rem 2.5rem 2rem;
            background: var(--mk-light);
            border-top: 1px solid var(--mk-border);
            font-size: 0.9rem;
        }

        /* ===== FORM CONTROLS ===== */
        .mk-form-group {
            margin-bottom: 1.5rem;
        }

        .mk-label {
            font-weight: 600;
            font-size: 0.9rem;
            color: var(--mk-dark);
            margin-bottom: 0.5rem;
            display: block;
        }

        .mk-form-control {
            border: 1.5px solid #e0e4f0;
            border-radius: var(--mk-radius-sm);
            padding: 0.75rem 1rem;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            background: #fff;
            width: 100%;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        .mk-form-control:focus {
            outline: none;
            border-color: var(--mk-primary);
            box-shadow: 0 0 0 3px rgba(0, 119, 255, 0.1);
            background: #fff;
        }

        .mk-form-control::placeholder {
            color: #9ca3af;
            font-size: 0.9rem;
        }

        /* ===== PASSWORD TOGGLE ===== */
        .mk-password-group {
            position: relative;
        }

        .mk-password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--mk-secondary);
            cursor: pointer;
            padding: 0.25rem;
            border-radius: 4px;
            transition: color 0.3s ease;
            font-size: 0.9rem;
        }

        .mk-password-toggle:hover {
            color: var(--mk-primary);
        }

        /* ===== BOTÓN PRINCIPAL ===== */
        .mk-btn {
            border: none;
            border-radius: var(--mk-radius-sm);
            font-weight: 600;
            padding: 0.8rem 1.8rem;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            width: 100%;
        }

        .mk-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .mk-btn:hover::before {
            left: 100%;
        }

        .mk-btn-primary {
            background: linear-gradient(135deg, var(--mk-primary), var(--mk-primary-light));
            color: #fff;
            box-shadow: 0 4px 15px rgba(0, 119, 255, 0.3);
            text-transform: uppercase;
            letter-spacing: 0.03em;
            font-weight: 700;
        }

        .mk-btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 119, 255, 0.4);
            color: #fff;
        }

        .mk-btn-icon {
            width: 18px;
            height: 18px;
        }

        /* ===== BOTONES SECUNDARIOS ===== */
        .mk-footer-buttons {
            display: flex;
            gap: 0.8rem;
            flex-wrap: wrap;
        }

        .mk-footer-buttons .mk-btn {
            flex: 1 1 140px;
            font-weight: 600;
        }

        .mk-btn-outline {
            background: transparent;
            border: 1.5px solid var(--mk-primary);
            color: var(--mk-primary);
        }

        .mk-btn-outline:hover {
            background: var(--mk-primary);
            color: #fff;
            transform: translateY(-2px);
        }

        .mk-btn-dark {
            background: transparent;
            border: 1.5px solid var(--mk-dark);
            color: var(--mk-dark);
        }

        .mk-btn-dark:hover {
            background: var(--mk-dark);
            color: #fff;
            transform: translateY(-2px);
        }

        /* ===== ALERTS MEJORADOS ===== */
        .mk-alert {
            border-radius: var(--mk-radius-sm);
            padding: 1rem 1.2rem;
            margin-bottom: 1.5rem;
            border: 1px solid transparent;
            font-size: 0.9rem;
        }

        .mk-alert-danger {
            background: linear-gradient(135deg, #f8d7da, #f5c6cb);
            border-color: #f1aeb5;
            color: #721c24;
        }

        .mk-alert ul {
            margin: 0;
            padding-left: 1.2rem;
        }

        .mk-alert li {
            margin-bottom: 0.3rem;
        }

        .mk-alert li:last-child {
            margin-bottom: 0;
        }

        /* ===== ANIMACIONES ===== */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .mk-card-auth {
            animation: fadeInUp 0.6s ease-out;
        }

        /* ===== RESPONSIVE ===== */
        @media (max-width: 767.98px) {
            .mk-auth-bg {
                padding: 1rem 0.5rem;
                min-height: calc(100vh - 60px);
            }
            
            .mk-card-auth-header,
            .mk-card-auth-body,
            .mk-card-auth-footer {
                padding: 1.5rem 1.5rem;
            }
            
            .mk-card-auth-header h1 {
                font-size: 1.5rem;
            }
            
            .mk-login-icon {
                font-size: 2.5rem;
            }
            
            .mk-footer-buttons {
                flex-direction: column;
            }
            
            .mk-footer-buttons .mk-btn {
                flex: 1 1 auto;
            }
        }

        @media (max-width: 575.98px) {
            .mk-card-auth-header,
            .mk-card-auth-body,
            .mk-card-auth-footer {
                padding: 1.2rem 1.2rem;
            }
        }
    </style>
</head>
<body>
<?php require __DIR__ . '/_navbar.php'; ?>
<!-- DATE BAR -->
<div class="datebar">
  <div class="container inner"><span id="fecha-hoy">—</span></div>
</div>
<style>
/* Fecha */
.datebar{background:var(--navy);color:#fff;font-weight:600}
.datebar .inner{height:40px;display:flex;align-items:center}
</style>
<div class="mk-auth-bg">
    <div class="mk-card-auth">
        <!-- Header con icono y título -->
        <div class="mk-card-auth-header">
            <span class="mk-login-icon">🔑</span>
            <h1>Iniciar sesión</h1>
            <p>Entrá a tu cuenta del Marketplace de Fe.Tr.A</p>
        </div>

        <!-- Body del formulario -->
        <div class="mk-card-auth-body">
            <?php if ($errores): ?>
                <div class="mk-alert mk-alert-danger">
                    <ul>
                        <?php foreach ($errores as $e): ?>
                            <li><?= htmlspecialchars($e, ENT_QUOTES, 'UTF-8') ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form method="post" action="login_market.php" autocomplete="off" id="loginForm">
                <!-- Campo Email -->
                <div class="mk-form-group">
                    <label class="mk-label">Email</label>
                    <input class="mk-form-control" type="email" name="email" 
                           placeholder="tu.email@ejemplo.com"
                           required
                           autocomplete="email">
                </div>

                <!-- Campo Contraseña -->
                <div class="mk-form-group">
                    <label class="mk-label">Contraseña</label>
                    <div class="mk-password-group">
                        <input class="mk-form-control" type="password" name="password" 
                               placeholder="Ingresá tu contraseña"
                               required
                               autocomplete="current-password"
                               id="passwordInput">
                        <button type="button" class="mk-password-toggle" id="togglePassword">
                            👁️
                        </button>
                    </div>
                </div>

                <!-- Botón de envío -->
                <button type="submit" class="mk-btn mk-btn-primary">
                    <span class="mk-btn-icon">→</span>
                    Ingresar al Marketplace
                </button>
            </form>
        </div>

        <!-- Footer con acciones -->
        <div class="mk-card-auth-footer">
            <div class="mk-footer-buttons">
                <a href="crear_usuario_market.php" class="mk-btn mk-btn-outline">
                    <span class="mk-btn-icon">👤</span>
                    Crear cuenta
                </a>
                <a href="market.php" class="mk-btn mk-btn-dark">
                    <span class="mk-btn-icon">🏪</span>
                    Ver Marketplace
                </a>
            </div>
        </div>
    </div>
</div>

<?php require __DIR__ . '/_footer.php'; ?>
<?php require __DIR__ . '/_navbar_script.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const passwordInput = document.getElementById('passwordInput');
    const togglePassword = document.getElementById('togglePassword');
    const loginForm = document.getElementById('loginForm');

    // Toggle de visibilidad de contraseña
    if (togglePassword && passwordInput) {
        togglePassword.addEventListener('click', function() {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            togglePassword.textContent = type === 'password' ? '👁️' : '🔒';
        });
    }

    // Validación del formulario
    if (loginForm) {
        loginForm.addEventListener('submit', function(e) {
            const email = loginForm.querySelector('input[name="email"]');
            const password = loginForm.querySelector('input[name="password"]');
            let valid = true;

            // Reset estilos
            [email, password].forEach(field => {
                field.style.borderColor = '';
            });

            // Validar campos vacíos
            if (!email.value.trim()) {
                email.style.borderColor = '#dc3545';
                valid = false;
            }

            if (!password.value.trim()) {
                password.style.borderColor = '#dc3545';
                valid = false;
            }

            if (!valid) {
                e.preventDefault();
                // Enfocar el primer campo con error
                if (!email.value.trim()) {
                    email.focus();
                } else if (!password.value.trim()) {
                    password.focus();
                }
            }
        });

        // Efecto de focus en los campos
        const inputs = loginForm.querySelectorAll('.mk-form-control');
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.style.borderColor = 'var(--mk-primary)';
                this.style.boxShadow = '0 0 0 3px rgba(0, 119, 255, 0.1)';
            });

            input.addEventListener('blur', function() {
                this.style.borderColor = '';
                this.style.boxShadow = '';
            });
        });
    }

    // Auto-focus en el campo de email
    const emailField = document.querySelector('input[name="email"]');
    if (emailField) {
        setTimeout(() => {
            emailField.focus();
        }, 400);
    }
});
</script>
</body>
</html>