<?php
// register_bolsa.php
// Registro para Bolsa de Trabajo usando la MISMA tabla de usuarios del Marketplace.

require __DIR__ . '/bolsa_auth.php';

$pdo = bolsa_pdo();

$errores = [];
$ok      = '';

$nombre    = '';
$apellido  = '';
$email     = '';
$telefono  = '';
$password  = '';
$password2 = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre    = trim($_POST['nombre']    ?? '');
    $apellido  = trim($_POST['apellido']  ?? '');
    $email     = trim($_POST['email']     ?? '');
    $telefono  = trim($_POST['telefono']  ?? '');
    $password  = $_POST['password']       ?? '';
    $password2 = $_POST['password2']      ?? '';

    // Validaciones básicas
    if ($nombre === '' || $apellido === '' || $email === '' || $password === '' || $password2 === '') {
        $errores[] = 'Todos los campos marcados con * son obligatorios.';
    }

    if ($email !== '' && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errores[] = 'El email no es válido.';
    }

    if ($password !== '' && strlen($password) < 6) {
        $errores[] = 'La contraseña debe tener al menos 6 caracteres.';
    }

    if ($password !== $password2) {
        $errores[] = 'Las contraseñas no coinciden.';
    }

    // Verificar si ya existe un usuario con ese email
    if (!$errores && $email !== '') {
        try {
            $stmt = $pdo->prepare("SELECT id FROM market_users WHERE email = ? LIMIT 1");
            $stmt->execute([$email]);
            if ($stmt->fetch(PDO::FETCH_ASSOC)) {
                $errores[] = 'Ya existe un usuario registrado con ese email.';
            }
        } catch (Throwable $e) {
            $errores[] = 'Error al verificar el email en la base de datos.';
        }
    }

    if (!$errores) {
        try {
            $hash = password_hash($password, PASSWORD_DEFAULT);

            // Ajustá los nombres de columnas si en tu tabla son distintos
            $stmt = $pdo->prepare("
                INSERT INTO market_users (nombre, apellido, email, telefono, password_hash, created_at)
                VALUES (:nombre, :apellido, :email, :telefono, :password_hash, NOW())
            ");
            $stmt->execute([
                ':nombre'        => $nombre,
                ':apellido'      => $apellido,
                ':email'         => $email,
                ':telefono'      => $telefono,
                ':password_hash' => $hash,
            ]);

            $nuevo_id = (int)$pdo->lastInsertId();

            // Loguear directamente en la sesión de Bolsa
            $_SESSION['bolsa_user_id'] = $nuevo_id;

            // Redirigir a Bolsa de Trabajo
            header('Location: bolsa_trabajo.php');
            exit;

        } catch (Throwable $e) {
            $errores[] = 'No se pudo crear el usuario en la base de datos.';
        }
    }
}

function m_s($v) {
    return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}

// Franja de fecha
setlocale(LC_TIME, 'es_AR.UTF-8', 'es_AR', 'es_ES.UTF-8', 'es_ES');
$fecha_hoy = strftime('%A %d de %B de %Y');
$fecha_hoy = ucfirst($fecha_hoy);
?>
<?php require __DIR__ . '/_head_assets.php'; ?>
<body class="bg-light">
<?php require __DIR__ . '/_navbar.php'; ?>

<!-- Franja azul con la fecha -->
<div style="background-color:#0b3254; color:#fff; padding:0.4rem 0; font-size:0.9rem;">
    <div class="container d-flex justify-content-between align-items-center flex-wrap">
        <span><?= m_s($fecha_hoy) ?></span>
        <span>Bolsa de Trabajo &mdash; Crear cuenta</span>
    </div>
</div>

<main class="py-4 py-md-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-7 col-lg-6">
                <h1 class="h4 fw-bold mb-3 text-center">Crear cuenta para Bolsa de Trabajo</h1>
                <p class="text-muted small text-center mb-4">
                    Tu usuario se guarda en la misma base de datos del Marketplace Fe.Tr.A.
                </p>

                <?php if ($errores): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach ($errores as $e): ?>
                                <li><?= m_s($e) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="card shadow-sm border-0">
                    <div class="card-body p-4">
                        <form method="post" novalidate>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Nombre *</label>
                                    <input type="text" name="nombre" class="form-control"
                                           value="<?= m_s($nombre) ?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Apellido *</label>
                                    <input type="text" name="apellido" class="form-control"
                                           value="<?= m_s($apellido) ?>" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Email *</label>
                                    <input type="email" name="email" class="form-control"
                                           value="<?= m_s($email) ?>" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Teléfono</label>
                                    <input type="text" name="telefono" class="form-control"
                                           value="<?= m_s($telefono) ?>">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Contraseña *</label>
                                    <input type="password" name="password" class="form-control" required>
                                    <div class="form-text small">Mínimo 6 caracteres.</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Repetir contraseña *</label>
                                    <input type="password" name="password2" class="form-control" required>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary w-100 mt-4">
                                Crear cuenta
                            </button>
                        </form>
                    </div>
                </div>

                <p class="text-center small mt-3">
                    ¿Ya tenés cuenta? <a href="login_bolsa.php">Ingresar a Bolsa de Trabajo</a>
                </p>
            </div>
        </div>
    </div>
</main>

<?php require __DIR__ . '/_footer.php'; ?>
<?php require __DIR__ . '/_navbar_script.php'; ?>
</body>
</html>
