<?php
@session_start();
require __DIR__ . '/db.php';
$pdo = pdo();

/* ==== Modelo ==== */
$years = $pdo->query("SELECT id, anio FROM tarifa_anios ORDER BY anio DESC")->fetchAll(PDO::FETCH_ASSOC);

$anio_param = isset($_GET['anio']) ? (int)$_GET['anio'] : 0;
$anio_row = null; $pdfs = [];
if ($anio_param) {
  $st = $pdo->prepare("SELECT id, anio FROM tarifa_anios WHERE anio = ? LIMIT 1");
  $st->execute([$anio_param]);
  $anio_row = $st->fetch(PDO::FETCH_ASSOC);
  if ($anio_row) {
    $st2 = $pdo->prepare("
      SELECT id, titulo, mes, archivo_path, orden
      FROM tarifa_archivos
      WHERE anio_id = ?
      ORDER BY orden ASC, id ASC
    ");
    $st2->execute([$anio_row['id']]);
    $pdfs = $st2->fetchAll(PDO::FETCH_ASSOC);
  }
}

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Tarifas — Fe.Tr.A</title>
  <?php include __DIR__ . '/_head_assets.php'; ?>
  <style>
    /* ====== página tarifas ====== */
    .tar-years-wrap{max-width:1200px;margin:22px auto 28px;padding:0 20px}
    .tar-years{display:grid;grid-template-columns:repeat(4,1fr);gap:18px}
    .tar-year{display:flex;align-items:center;justify-content:center;padding:28px 10px;background:#193a63;color:#fff;border-radius:10px;font-weight:800;font-size:clamp(22px,2.5vw,32px);border:1px solid rgba(255,255,255,.08)}
    .tar-year:hover{filter:brightness(1.05)}
    @media (max-width:1024px){.tar-years{grid-template-columns:repeat(2,1fr)}}
    @media (max-width:560px){.tar-years{grid-template-columns:1fr}}

    .tar-title-band{background:#3a4148;color:#fff;padding:20px 0;margin-bottom:8px}
    .tar-title{font-weight:800;font-size:clamp(22px,3vw,34px);text-align:center;letter-spacing:.02em}

    .tar-section-title{background:#0f2a44;color:#fff;padding:10px 20px;font-weight:800;font-size:clamp(18px,2vw,22px);margin:24px 0 18px}
    .tar-grid{max-width:1200px;margin:0 auto 44px;padding:0 20px;display:grid;grid-template-columns:1fr 1fr;gap:24px}
    @media (max-width:980px){.tar-grid{grid-template-columns:1fr}}
    .tar-card{background:#f2f4f8;border:1px solid #dfe6ee;border-radius:12px;padding:12px}
    .tar-card h3{margin:6px 8px 4px;font-size:18px;display:flex;gap:8px;align-items:center;flex-wrap:wrap}
    .tar-meta{font-size:13px;color:#6b7580;font-weight:600}
    .tar-iframe{width:100%;height:560px;border:0;border-radius:8px;background:#666}
    .mut{color:#6b7580}
  </style>
</head>
<body>
  <?php include __DIR__ . '/_navbar.php'; ?>

  <!-- Franja azul de fecha -->
  <div class="datebar">
    <div class="container inner"><span id="fecha-hoy">—</span></div>
  </div>

  <main>
    <!-- Título grande -->
    <div class="tar-title-band">
      <div class="container tar-title">
        TARIFAS NACIONALES DE CEREALES Y OLEAGINOSAS
      </div>
    </div>

    <!-- AÑOS -->
    <section class="tar-years-wrap">
      <div class="tar-years">
        <?php foreach($years as $y): ?>
          <a class="tar-year" href="?anio=<?= (int)$y['anio'] ?>"><?= (int)$y['anio'] ?></a>
        <?php endforeach; ?>
        <?php if(!$years): ?>
          <div class="mut">Aún no hay años cargados.</div>
        <?php endif; ?>
      </div>
    </section>

    <!-- PDFs por año -->
    <?php if($anio_row): ?>
      <div class="tar-section-title">Tarifas de <?= (int)$anio_row['anio'] ?></div>

      <section class="tar-grid">
        <?php foreach($pdfs as $p): ?>
          <article class="tar-card">
            <h3>
              <?= h($p['titulo'] ?: 'Documento') ?>
              <?php if(!empty($p['mes'])): ?>
                <span class="tar-meta">— <?= h($p['mes']) ?></span>
              <?php endif; ?>
            </h3>
            <?php if($p['archivo_path'] && file_exists(__DIR__ . '/' . $p['archivo_path'])): ?>
              <iframe class="tar-iframe"
                      src="<?= h($p['archivo_path']) ?>#view=FitH&scrollbar=1&toolbar=1"></iframe>
            <?php else: ?>
              <div class="mut" style="padding:10px">No se encuentra el archivo.</div>
            <?php endif; ?>
          </article>
        <?php endforeach; ?>

        <?php if(!$pdfs): ?>
          <div class="mut">No hay PDFs cargados para <?= (int)$anio_row['anio'] ?>.</div>
        <?php endif; ?>
      </section>
    <?php elseif($anio_param): ?>
      <div class="container" style="padding:10px 20px;color:#a33">El año solicitado no existe.</div>
    <?php endif; ?>
  </main>

  <?php include __DIR__ . '/_footer.php'; ?>
  <?php include __DIR__ . '/_navbar_script.php'; ?>

  <script>
    (function(){
      var el = document.getElementById('fecha-hoy'); if(!el) return;
      try{
        var d = new Date();
        // Formato correcto sin coma rara: "Miércoles, 22 de octubre"
        var fmt = new Intl.DateTimeFormat('es-AR', { weekday:'long', day:'2-digit', month:'long' });
        var s = fmt.format(d);                      // "miércoles, 22 de octubre"
        s = s.charAt(0).toUpperCase() + s.slice(1); // "Miércoles, 22 de octubre"
        el.textContent = s;
      }catch(e){
        el.textContent = 'Hoy';
      }
    })();
  </script>
    <!-- Publicidad: imprime los objetos guardados para la página "servicios" -->
  <script src="admin_publicidad.php?action=embed&page=tarifas"></script>
</body>
</html>
