<?php
// toggle_estado_producto_market.php
require __DIR__ . '/market_bootstrap.php';

if (!market_is_logged()) {
    header('Location: login_market.php');
    exit;
}

$pdo = market_pdo();
$U   = market_current_user();
if (!$U) {
    header('Location: logout_market.php');
    exit;
}

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    header('Location: perfil_market.php');
    exit;
}

// Buscar producto que sea del usuario logueado
$st = $pdo->prepare("
    SELECT id, usuario_id, estado
    FROM market_productos
    WHERE id = ?
    LIMIT 1
");
$st->execute([$id]);
$P = $st->fetch(PDO::FETCH_ASSOC);

if (!$P || (int)$P['usuario_id'] !== (int)$U['id']) {
    // No existe o no es tuyo
    header('Location: perfil_market.php');
    exit;
}

$estadoActual = $P['estado'] ?: 'publicado';
$nuevoEstado  = ($estadoActual === 'pausado') ? 'publicado' : 'pausado';

// Actualizar solo el campo estado
$up = $pdo->prepare("
    UPDATE market_productos
       SET estado = ?
     WHERE id = ?
     LIMIT 1
");
$up->execute([$nuevoEstado, $id]);

header('Location: perfil_market.php');
exit;
