<?php
/* ver_noticia.php — Detalle de nota con misma UI (navbar/footer) que notas.html
   Lee tabla `noticias` creada por admin_noticias_lite.php. */

if (file_exists(__DIR__.'/db.php')) { require __DIR__.'/db.php'; $pdo = pdo();
} else {
  define('DB_HOST','localhost'); define('DB_NAME','tu_base'); define('DB_USER','tu_usuario'); define('DB_PASS','tu_pass');
  try{
    $pdo = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4", DB_USER, DB_PASS, [
      PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC
    ]);
  }catch(Exception $e){ http_response_code(500); echo "Error DB: ".$e->getMessage(); exit; }
}

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT titulo, portada_url, contenido_json, updated_at FROM noticias WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$nota = $stmt->fetch();
if(!$nota){ http_response_code(404); echo "Nota no encontrada"; exit; }

$blocks = json_decode($nota['contenido_json'] ?? '[]', true) ?: [];

function fecha_larga($ts){
  try{
    $d = new DateTime($ts);
    $fmt = new IntlDateFormatter('es_AR', IntlDateFormatter::LONG, IntlDateFormatter::NONE);
    return $fmt->format($d);
  }catch(Exception $e){ return $ts; }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta content="width=device-width, initial-scale=1" name="viewport" />
  <title><?= htmlspecialchars($nota['titulo']) ?> — Fe.Tr.A</title>
  <meta name="description" content="<?= htmlspecialchars($nota['titulo']) ?>" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <style>
    :root{--navy:#15324c;--ink:#0f1a24;--link:#1f72b6;--bg:#ffffff;--muted:#6b7580}
    *{box-sizing:border-box}
    html,body{margin:0;padding:0;background:#f2f5f8;color:var(--ink);font-family:Poppins,system-ui,Segoe UI,Roboto,Arial,sans-serif}
    a{color:inherit;text-decoration:none}

    .container{max-width:1200px;margin:0 auto;padding:0 20px}
    .wrap{max-width:960px;margin:26px auto;background:#fff;border:1px solid rgba(0,0,0,.08);border-radius:12px;overflow:hidden}

    /* NAVBAR (igual a notas.html) */
    .navbar{position:sticky;top:0;z-index:50;background:#fff;border-bottom:1px solid rgba(0,0,0,.06)}
    .navbar .inner{display:flex;align-items:center;justify-content:space-between;height:72px;gap:16px}
    .brand{display:flex;align-items:center;gap:14px;font-weight:800;letter-spacing:.08em}
    .brand .title{line-height:1}
    .brand small{display:block;font-weight:600;opacity:.8;letter-spacing:.2em;margin-top:2px}
    .nav-links{display:flex;align-items:center;gap:22px;font-weight:600}
    .nav-links a{padding:10px 12px;border-radius:8px;transition:background .2s}
    .nav-links a:hover{background:rgba(0,0,0,.05)}
    .nav-links a.active{background:#1f72b6;color:#fff}
    .social{display:flex;align-items:center;gap:14px}
    .social a{opacity:.9}
    .social a:hover{opacity:1}

    /* Fecha */
    .datebar{background:var(--navy);color:#fff;font-weight:600}
    .datebar .inner{height:40px;display:flex;align-items:center}

    /* HERO Portada + título */
    .hero-img{width:100%;height:360px;object-fit:cover;display:block;background:#e8edf3}
    .head{padding:20px 24px;border-bottom:1px solid rgba(0,0,0,.06)}
    .head h1{margin:0;font-size:clamp(26px,3.6vw,38px);font-weight:800;letter-spacing:.02em}
    .meta{margin-top:6px;color:var(--muted)}

    /* Cuerpo en flujo normal */
    .article{padding:26px 24px 32px}
    .article h2{font-size:26px;margin:18px 0 10px}
    .article p{font-size:18px;line-height:1.7;margin:14px 0;color:#29313a}
    .article blockquote{border-left:4px solid #e5ebf2;padding:8px 14px;margin:16px 0;background:#fafcff}
    .article a{color:var(--link);text-decoration:underline}
    .figure{margin:18px 0}
    .figure img{width:100%;height:auto;border-radius:10px;display:block}
    .embed{position:relative;aspect-ratio:16/9;margin:18px 0;border-radius:10px;overflow:hidden;background:#000}
    .embed>div,.embed iframe{position:absolute;inset:0;width:100%;height:100%}

    /* FOOTER (igual a notas.html) */
    footer{background:var(--navy);color:#fff;margin-top:64px}
    .footer-top{padding:34px 0;border-bottom:1px solid rgba(255,255,255,.08)}
    .footer-grid{display:grid;grid-template-columns:1fr auto;gap:24px;align-items:center}
    .footer-nav{display:flex;flex-wrap:wrap;gap:18px;opacity:.95}
    .footer-nav a{color:#fff;opacity:.9}
    .footer-nav a:hover{opacity:1;text-decoration:underline}
    .footer-brand{font-weight:800;letter-spacing:.12em;opacity:.95}
    .footer-bottom{padding:22px 0;display:flex;justify-content:space-between;align-items:center;gap:20px}
    .footer-social{display:flex;gap:16px}
    .footer-social a{color:#fff;opacity:.9}
    .footer-social a:hover{opacity:1}

    /* Responsive */
    .burger{display:none;font-size:28px;border:none;background:transparent}
    @media (max-width:980px){
      .nav-links{display:none;position:absolute;top:72px;left:0;right:0;background:#fff;border-bottom:1px solid rgba(0,0,0,.06);padding:10px 20px;flex-wrap:wrap}
      .nav-links.open{display:flex}
      .burger{display:block}
      .social{display:none}
      .wrap{margin:12px auto}
      .hero-img{height:240px}
    }
  </style>
</head>
<body>

  <!-- NAVBAR -->
  <header class="navbar">
    <div class="container inner">
      <div class="brand">
        <div class="title">
          <div>FEDERACIÓN DE</div>
          <small>TRANSPORTADORES ARGENTINOS</small>
        </div>
      </div>

      <button class="burger" id="burger" aria-label="Abrir menú"><i class="bi bi-list"></i></button>

      <nav class="nav-links" id="nav">
        <a href="index.php">INICIO</a>
        <a href="notas.php" class="active">NOTAS</a>
        <a href="index.php#servicios">SERVICIOS</a>
        <a href="index.php#delegaciones">DELEGACIONES</a>
        <a href="index.php#tarifas">TARIFAS</a>
        <a href="index.php#contacto">CONTACTO</a>
      </nav>

      <div class="social">
        <a href="https://www.facebook.com/share/19aQ41jjxB/" target="_blank" rel="noopener noreferrer" aria-label="Facebook"><i class="bi bi-facebook"></i></a>
        <a href="https://x.com/afetra05?t=ZdX3j9XIGd2PvFizJYMcdg&s=09" target="_blank" rel="noopener noreferrer" aria-label="X"><i class="bi bi-twitter-x"></i></a>
        <a href="https://www.instagram.com/fe_tr.a?igsh=ZHpqeHB2OW1iNmRq" target="_blank" rel="noopener noreferrer" aria-label="Instagram"><i class="bi bi-instagram"></i></a>
        <a href="https://www.linkedin.com/in/federaci%C3%B3n-de-transportadores-argentinos-arg-8a33a1327?utm_source=share&utm_campaign=share_via&utm_content=profile&utm_medium=android_app" target="_blank" rel="noopener noreferrer" aria-label="LinkedIn"><i class="bi bi-linkedin"></i></a>
      </div>
    </div>
  </header>

  <!-- DATE BAR -->
  <div class="datebar"><div class="container inner"><span id="fecha-hoy">—</span></div></div>

  <div class="wrap">
    <?php if(!empty($nota['portada_url'])): ?>
      <img class="hero-img" src="<?= htmlspecialchars($nota['portada_url']) ?>" alt="Portada">
    <?php endif; ?>
    <div class="head">
      <h1><?= htmlspecialchars($nota['titulo']) ?></h1>
      <div class="meta"><?= htmlspecialchars(fecha_larga($nota['updated_at'])) ?> • Fe.Tr.A</div>
    </div>

    <article class="article">
      <?php
      foreach($blocks as $b){
        $type = $b['type'] ?? '';
        if($type === 'img' && !empty($b['src'])){
          echo '<figure class="figure"><img src="'.htmlspecialchars($b['src']).'" alt=""></figure>';
        } elseif($type === 'embed'){
          $html = $b['embedHtml'] ?? '';
          echo '<div class="embed"><div>'.$html.'</div></div>';
        } elseif($type === 'quote'){
          $txt = $b['content'] ?? '';
          echo '<blockquote>'.$txt.'</blockquote>';
        } elseif($type === 'h1'){
          $txt = $b['content'] ?? '';
          if(trim($txt)!=='') echo '<h2>'.$txt.'</h2>';
        } elseif($type === 'link'){
          $txt = $b['content'] ?? 'Enlace';
          $href = !empty($b['href']) ? $b['href'] : '#';
          echo '<p><a href="'.htmlspecialchars($href).'" target="_blank" rel="noopener">'.$txt.'</a></p>';
        } else { // párrafo u otros
          $txt = $b['content'] ?? '';
          if(trim(strip_tags($txt))!==''){
            $style = '';
            if(!empty($b['styles']['fontSize'])) $style .= 'font-size:'.((int)$b['styles']['fontSize']).'px;';
            if(!empty($b['styles']['color'])) $style .= 'color:'.htmlspecialchars($b['styles']['color']).';';
            if(!empty($b['styles']['textAlign'])) $style .= 'text-align:'.htmlspecialchars($b['styles']['textAlign']).';';
            echo '<p style="'.$style.'">'.$txt.'</p>';
          }
        }
      }
      ?>
    </article>
  </div>

  <!-- FOOTER -->
  <footer>
    <div class="footer-top">
      <div class="container footer-grid">
        <div class="footer-brand">FEDERACIÓN DE TRANSPORTADORES ARGENTINOS</div>
        <nav class="footer-nav" aria-label="Footer">
          <a href="index.php#inicio">Inicio</a>
          <a href="notas.php">Notas</a>
          <a href="index.php#servicios">Servicios</a>
          <a href="index.php#delegaciones">Delegaciones</a>
          <a href="index.php#tarifas">Tarifas</a>
          <a href="index.php#contacto">Contacto</a>
        </nav>
      </div>
    </div>
    <div class="container footer-bottom">
      <div>© <?= date('Y') ?> Fe.Tr.A — Todos los derechos reservados</div>
      <div class="footer-social">
        <a href="https://www.facebook.com/share/19aQ41jjxB/" target="_blank" rel="noopener noreferrer" aria-label="Facebook"><i class="bi bi-facebook"></i></a>
        <a href="https://x.com/afetra05?t=ZdX3j9XIGd2PvFizJYMcdg&s=09" target="_blank" rel="noopener noreferrer" aria-label="X"><i class="bi bi-twitter-x"></i></a>
        <a href="https://www.instagram.com/fe_tr.a?igsh=ZHpqeHB2OW1iNmRq" target="_blank" rel="noopener noreferrer" aria-label="Instagram"><i class="bi bi-instagram"></i></a>
        <a href="https://www.linkedin.com/in/federaci%C3%B3n-de-transportadores-argentinos-arg-8a33a1327?utm_source=share&utm_campaign=share_via&utm_content=profile&utm_medium=android_app" target="_blank" rel="noopener noreferrer" aria-label="LinkedIn"><i class="bi bi-linkedin"></i></a>
      </div>
    </div>
  </footer>

  <script>
    // Fecha barra superior
    (function(){
      const el = document.getElementById('fecha-hoy');
      try{
        const d=new Date(), f=new Intl.DateTimeFormat('es-AR',{weekday:'long',day:'2-digit',month:'long',year:'numeric'});
        const t=f.format(d).split(' ');
        el.textContent=`${t[0][0].toUpperCase()+t[0].slice(1)} ${t[1]} ${t[2].charAt(0).toUpperCase()+t[2].slice(1)}, ${t[3]}`;
      }catch(e){el.textContent='Hoy';}
    })();
    // Burger menu
    const burger=document.getElementById('burger'),nav=document.getElementById('nav');
    burger?.addEventListener('click',()=>nav.classList.toggle('open'));
  </script>
</body>
</html>
