<?php
// ver_producto_market.php
require __DIR__ . '/market_bootstrap.php';

if (!market_is_logged()) {
    header('Location: login_market.php');
    exit;
}

$pdo = market_pdo();
$id  = (int)($_GET['id'] ?? 0);
if ($id <= 0) { header('Location: market.php'); exit; }

$st = $pdo->prepare("
    SELECT p.*,
           u.nombre   AS u_nombre,
           u.apellido AS u_apellido,
           u.telefono AS u_telefono,
           u.email    AS u_email,
           u.avatar   AS u_avatar
      FROM market_productos p
      JOIN market_usuarios u ON u.id = p.usuario_id
     WHERE p.id=? AND p.estado='activo'
     LIMIT 1
");
$st->execute([$id]);
$P = $st->fetch(PDO::FETCH_ASSOC);
if (!$P) { header('Location: market.php'); exit; }

$stF = $pdo->prepare("
    SELECT archivo
    FROM market_productos_fotos
    WHERE producto_id=?
    ORDER BY es_portada DESC, id ASC
");
$stF->execute([$id]);
$fotos = $stF->fetchAll(PDO::FETCH_COLUMN) ?: [];

$fotoPrincipal = $fotos[0] ?? 'https://via.placeholder.com/800x500?text=Sin+imagen';
$U = market_current_user();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($P['titulo'], ENT_QUOTES, 'UTF-8') ?> - Marketplace</title>
    <?php require __DIR__ . '/_head_assets.php'; ?>
    <style>
        :root {
            --mk-primary: #0055a5;
            --mk-primary-light: #00a2ff;
            --mk-success: #198754;
            --mk-warning: #ffc107;
            --mk-light: #f8f9fc;
            --mk-dark: #212529;
            --mk-border: #e0e4f0;
            --mk-shadow: 0 12px 30px rgba(0,0,0,0.08);
            --mk-shadow-hover: 0 18px 40px rgba(0,0,0,0.12);
            --mk-radius: 16px;
            --mk-radius-sm: 12px;
        }

        .mk-main {
            padding: 2rem 0 3rem;
            background: linear-gradient(135deg, #f4f6fb 0%, #f0f4ff 100%);
            min-height: 100vh;
        }

        .mk-card {
            background: #fff;
            border-radius: var(--mk-radius);
            box-shadow: var(--mk-shadow);
            overflow: hidden;
            max-width: 1000px;
            margin: 0 auto;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid rgba(255,255,255,0.2);
        }

        .mk-card:hover {
            transform: translateY(-3px);
            box-shadow: var(--mk-shadow-hover);
        }

        .mk-card-header {
            padding: 1.5rem 2rem;
            background: linear-gradient(135deg, var(--mk-primary), var(--mk-primary-light));
            color: #fff;
            position: relative;
            overflow: hidden;
        }

        .mk-card-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255,255,255,0.1), transparent);
            transform: rotate(45deg);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0% { transform: translateX(-100%) rotate(45deg); }
            100% { transform: translateX(100%) rotate(45deg); }
        }

        .mk-card-header h1 {
            font-size: 1.5rem;
            margin: 0;
            font-weight: 700;
            line-height: 1.3;
            position: relative;
            z-index: 2;
        }

        .mk-card-header p {
            margin: 0.3rem 0 0;
            font-size: 0.9rem;
            opacity: 0.95;
            font-weight: 500;
            position: relative;
            z-index: 2;
        }

        .mk-card-body {
            padding: 2rem;
        }

        /* ===== GALERÍA MEJORADA ===== */
        .mk-gallery-container {
            position: relative;
        }

        .mk-gallery-main {
            position: relative;
            background: linear-gradient(135deg, #f8f9ff 0%, #f0f4ff 100%);
            border-radius: var(--mk-radius-sm);
            padding: 0.8rem;
            height: 320px;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            border: 1px solid rgba(255,255,255,0.8);
            box-shadow: inset 0 2px 8px rgba(0,0,0,0.04);
        }

        .mk-gallery-main img {
            max-width: 100%;
            max-height: 100%;
            width: auto;
            height: auto;
            object-fit: contain;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s ease;
            filter: drop-shadow(0 6px 15px rgba(0,0,0,0.1));
        }

        .mk-gallery-main img:hover {
            transform: scale(1.02);
            filter: drop-shadow(0 8px 20px rgba(0,0,0,0.15));
        }

        .mk-gallery-nav {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 40px;
            height: 40px;
            border-radius: 50%;
            border: none;
            background: rgba(255,255,255,0.95);
            box-shadow: 0 6px 20px rgba(0,0,0,0.12);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            padding: 0;
            transition: all 0.3s ease;
            z-index: 10;
            backdrop-filter: blur(8px);
        }

        .mk-gallery-nav span {
            font-size: 1.2rem;
            line-height: 1;
            font-weight: bold;
            color: var(--mk-primary);
        }

        .mk-gallery-nav:hover {
            background: #fff;
            transform: translateY(-50%) scale(1.08);
            box-shadow: 0 8px 25px rgba(0,0,0,0.18);
        }

        #mkPrev { left: 15px; }
        #mkNext { right: 15px; }

        .mk-gallery-nav.disabled {
            opacity: 0;
            pointer-events: none;
        }

        .mk-gallery-thumbnails {
            display: flex;
            gap: 0.6rem;
            margin-top: 1rem;
            padding: 0.5rem;
            overflow-x: auto;
        }

        .mk-thumbnail {
            width: 70px;
            height: 50px;
            border-radius: 8px;
            overflow: hidden;
            cursor: pointer;
            opacity: 0.6;
            transition: all 0.3s ease;
            border: 2px solid transparent;
            flex-shrink: 0;
        }

        .mk-thumbnail:hover {
            opacity: 1;
            transform: translateY(-1px);
        }

        .mk-thumbnail.active {
            opacity: 1;
            border-color: var(--mk-primary);
            transform: scale(1.05);
        }

        .mk-thumbnail img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /* ===== INFORMACIÓN DEL PRODUCTO ===== */
        .mk-product-info {
            padding-left: 0.5rem;
        }

        .mk-price-section {
            background: linear-gradient(135deg, #f8fff9, #f0f8ff);
            border-radius: var(--mk-radius-sm);
            padding: 1.2rem;
            margin-bottom: 1.5rem;
            border: 1px solid rgba(25, 135, 84, 0.08);
            position: relative;
            overflow: hidden;
        }

        .mk-price-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: linear-gradient(to bottom, var(--mk-success), var(--mk-primary-light));
        }

        .mk-label {
            font-weight: 600;
            font-size: 0.8rem;
            color: #495057;
            text-transform: uppercase;
            letter-spacing: 0.3px;
            margin-bottom: 0.4rem;
            display: block;
        }

        .mk-price {
            font-size: 1.8rem;
            font-weight: 800;
            color: var(--mk-success);
            line-height: 1;
            margin: 0.3rem 0;
            text-shadow: 0 1px 2px rgba(0,0,0,0.05);
        }

        .mk-price-consultar {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--mk-warning);
            background: linear-gradient(135deg, #fff9e6, #fff3cd);
            padding: 0.8rem 1.2rem;
            border-radius: var(--mk-radius-sm);
            border: 1px dashed var(--mk-warning);
            text-align: center;
        }

        .mk-info-card {
            background: var(--mk-light);
            border-radius: var(--mk-radius-sm);
            padding: 1.2rem;
            margin-bottom: 1.2rem;
            border: 1px solid var(--mk-border);
            transition: transform 0.2s ease;
        }

        .mk-info-card:hover {
            transform: translateX(3px);
        }

        .mk-descripcion {
            line-height: 1.6;
            color: #555;
            font-size: 0.95rem;
        }

        /* ===== VENDEDOR ===== */
        .mk-seller-box {
            border-radius: var(--mk-radius-sm);
            background: linear-gradient(135deg, #f8f9fc, #ffffff);
            padding: 1.2rem;
            display: flex;
            gap: 1rem;
            align-items: center;
            border: 1px solid var(--mk-border);
            box-shadow: 0 3px 12px rgba(0,0,0,0.04);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .mk-seller-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 2px;
            background: linear-gradient(90deg, var(--mk-primary), var(--mk-primary-light));
        }

        .mk-seller-box:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.08);
        }

        .mk-seller-avatar {
            width: 55px;
            height: 55px;
            border-radius: 50%;
            background: linear-gradient(135deg, #e9ecef, #dee2e6);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.3rem;
            color: #777;
            overflow: hidden;
            flex-shrink: 0;
            border: 2px solid #fff;
            box-shadow: 0 3px 12px rgba(0,0,0,0.08);
        }

        .mk-seller-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .mk-seller-info {
            flex: 1;
        }

        .mk-seller-name {
            font-weight: 700;
            font-size: 1rem;
            color: var(--mk-dark);
            margin-bottom: 0.2rem;
        }

        .mk-seller-contact-line {
            font-size: 0.85rem;
            color: #666;
            margin-bottom: 0.1rem;
            display: flex;
            align-items: center;
            gap: 0.4rem;
        }

        .mk-icon {
            width: 16px;
            height: 16px;
            opacity: 0.7;
        }

        /* ===== BOTONES MEJORADOS ===== */
        .mk-actions {
            display: flex;
            flex-wrap: wrap;
            gap: 0.8rem;
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--mk-border);
        }

        .mk-main .btn {
            border-radius: 8px;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            padding: 0.7rem 1.5rem;
            font-size: 0.9rem;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            border: none;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .btn:hover::before {
            left: 100%;
        }

        .btn-mk-wa {
            background: linear-gradient(135deg, #25d366, #128C7E);
            color: #fff;
        }

        .btn-mk-wa:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(37, 211, 102, 0.3);
            color: #fff;
        }

        .btn-mk-outline {
            background: transparent;
            border: 1.5px solid var(--mk-primary);
            color: var(--mk-primary);
        }

        .btn-mk-outline:hover {
            background: var(--mk-primary);
            color: #fff;
            transform: translateY(-2px);
        }

        .btn-mk-edit {
            background: linear-gradient(135deg, #6c757d, #495057);
            color: #fff;
        }

        .btn-mk-edit:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(108, 117, 125, 0.3);
            color: #fff;
        }

        /* ===== LIGHTBOX MEJORADO ===== */
        .mk-lightbox {
            position: fixed;
            inset: 0;
            background: rgba(0,0,0,0.95);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 9999;
            backdrop-filter: blur(8px);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .mk-lightbox.open {
            display: flex;
            opacity: 1;
        }

        .mk-lightbox-inner {
            max-width: 90vw;
            max-height: 90vh;
            position: relative;
            transform: scale(0.9);
            transition: transform 0.3s ease;
        }

        .mk-lightbox.open .mk-lightbox-inner {
            transform: scale(1);
        }

        .mk-lightbox-inner img {
            max-width: 100%;
            max-height: 100%;
            display: block;
            border-radius: 12px;
            box-shadow: 0 15px 40px rgba(0,0,0,0.4);
        }

        .mk-lightbox-close {
            position: absolute;
            top: -15px;
            right: -15px;
            background: #fff;
            border-radius: 50%;
            width: 35px;
            height: 35px;
            border: none;
            cursor: pointer;
            box-shadow: 0 6px 20px rgba(0,0,0,0.25);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            line-height: 1;
            transition: all 0.3s ease;
            z-index: 10;
        }

        .mk-lightbox-close:hover {
            transform: scale(1.1);
            background: #ff6b6b;
            color: #fff;
        }

        .mk-lightbox-nav {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 45px;
            height: 45px;
            background: rgba(255,255,255,0.9);
            border: none;
            border-radius: 50%;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            transition: all 0.3s ease;
            z-index: 5;
        }

        .mk-lightbox-nav:hover {
            background: #fff;
            transform: translateY(-50%) scale(1.1);
        }

        .mk-lightbox-prev { left: 20px; }
        .mk-lightbox-next { right: 20px; }

        /* ===== BADGES Y ETIQUETAS ===== */
        .mk-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.4rem;
            padding: 0.4rem 0.8rem;
            border-radius: 6px;
            font-weight: 600;
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.3px;
        }

        .mk-badge-warning {
            background: linear-gradient(135deg, #fff3cd, #ffeaa7);
            color: #856404;
            border: 1px solid #ffeaa7;
        }

        .mk-date-badge {
            background: linear-gradient(135deg, #e9ecef, #dee2e6);
            color: #495057;
            padding: 0.3rem 0.8rem;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
        }

        /* ===== ICONOS ===== */
        .icon-wrapper {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 16px;
            height: 16px;
        }

        .icon-small {
            width: 14px;
            height: 14px;
            opacity: 0.8;
        }

        /* ===== RESPONSIVE ===== */
        @media (max-width: 991.98px) {
            .mk-product-info {
                padding-left: 0;
                margin-top: 1.5rem;
            }
            
            .mk-card-body {
                padding: 1.5rem;
            }
            
            .mk-gallery-main {
                height: 280px;
            }
        }

        @media (max-width: 767.98px) {
            .mk-main {
                padding: 1.5rem 0 2rem;
            }
            
            .mk-card-body {
                padding: 1.2rem;
            }
            
            .mk-card-header {
                padding: 1.2rem 1.5rem;
            }
            
            .mk-card-header h1 {
                font-size: 1.3rem;
            }
            
            .mk-gallery-main {
                height: 240px;
                padding: 0.6rem;
            }
            
            .mk-gallery-nav {
                width: 35px;
                height: 35px;
            }
            
            .mk-price {
                font-size: 1.5rem;
            }
            
            .mk-actions {
                flex-direction: column;
                gap: 0.7rem;
            }
            
            .mk-actions .btn {
                width: 100%;
                justify-content: center;
            }
        }

        @media (max-width: 575.98px) {
            .mk-gallery-main {
                height: 200px;
            }
            
            .mk-seller-box {
                flex-direction: column;
                text-align: center;
                gap: 0.8rem;
            }
            
            .mk-seller-contact-line {
                justify-content: center;
            }
        }

        /* ===== ANIMACIONES ===== */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .mk-card {
            animation: fadeInUp 0.5s ease-out;
        }

        /* ===== SCROLLBAR PERSONALIZADO ===== */
        .mk-gallery-thumbnails::-webkit-scrollbar {
            height: 4px;
        }

        .mk-gallery-thumbnails::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 8px;
        }

        .mk-gallery-thumbnails::-webkit-scrollbar-thumb {
            background: var(--mk-primary);
            border-radius: 8px;
        }

        .mk-gallery-thumbnails::-webkit-scrollbar-thumb:hover {
            background: var(--mk-primary-light);
        }
    </style>
</head>
<body>
<?php require __DIR__ . '/_navbar.php'; ?>

<main class="mk-main">
    <div class="container">
        <div class="mk-card">
            <div class="mk-card-header">
                <h1><?= htmlspecialchars($P['titulo'], ENT_QUOTES, 'UTF-8') ?></h1>
                <p>Publicación del Marketplace de Fe.Tr.A</p>
            </div>
            
            <div class="mk-card-body">
                <div class="row g-4">
                    <!-- GALERÍA MEJORADA -->
                    <div class="col-lg-6">
                        <div class="mk-gallery-container">
                            <div class="mk-gallery-main">
                                <button id="mkPrev" class="mk-gallery-nav<?= count($fotos) <= 1 ? ' disabled' : '' ?>">
                                    <span>‹</span>
                                </button>
                                
                                <img id="mkMainImg"
                                     src="<?= htmlspecialchars($fotoPrincipal, ENT_QUOTES, 'UTF-8') ?>"
                                     alt="<?= htmlspecialchars($P['titulo'], ENT_QUOTES, 'UTF-8') ?>">
                                
                                <button id="mkNext" class="mk-gallery-nav<?= count($fotos) <= 1 ? ' disabled' : '' ?>">
                                    <span>›</span>
                                </button>
                            </div>

                            <?php if (count($fotos) > 1): ?>
                                <div class="mk-gallery-thumbnails" id="mkThumbnails">
                                    <?php foreach ($fotos as $index => $foto): ?>
                                        <div class="mk-thumbnail <?= $index === 0 ? 'active' : '' ?>" 
                                             data-index="<?= $index ?>">
                                            <img src="<?= htmlspecialchars($foto, ENT_QUOTES, 'UTF-8') ?>" 
                                                 alt="Miniatura <?= $index + 1 ?>">
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <div class="text-center mt-2">
                                    <small class="text-muted">Click en la imagen para ampliar • Usá las flechas para navegar</small>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- INFORMACIÓN DEL PRODUCTO MEJORADA -->
                    <div class="col-lg-6">
                        <div class="mk-product-info">
                            <!-- PRECIO -->
                            <div class="mk-price-section">
                                <?php if ($P['modo_precio'] === 'consultar'): ?>
                                    <span class="mk-label">Valor</span>
                                    <div class="mk-price-consultar">
                                        <div class="icon-wrapper">💬</div>
                                        Consultar precio
                                    </div>
                                <?php elseif ($P['precio'] !== null && $P['precio'] !== ''): ?>
                                    <span class="mk-label">Precio</span>
                                    <div class="mk-price">
                                        $ <?= number_format((float)$P['precio'], 0, ',', '.') ?>
                                    </div>
                                    <small class="text-muted">Hace click en el botón de WhatsApp para contactarte con el vendedor </small>
                                <?php endif; ?>
                            </div>

                            <!-- UBICACIÓN -->
                            <?php if (!empty($P['ubicacion'])): ?>
                                <div class="mk-info-card">
                                    <span class="mk-label">
                                        <div class="icon-wrapper">📍</div>
                                        Ubicación
                                    </span>
                                    <div class="fw-semibold"><?= htmlspecialchars($P['ubicacion'], ENT_QUOTES, 'UTF-8') ?></div>
                                </div>
                            <?php endif; ?>

                            <!-- DESCRIPCIÓN -->
                            <?php if (trim((string)$P['descripcion']) !== ''): ?>
                                <div class="mk-info-card">
                                    <span class="mk-label">
                                        <div class="icon-wrapper">📄</div>
                                        Descripción
                                    </span>
                                    <div class="mk-descripcion"><?= nl2br(htmlspecialchars($P['descripcion'], ENT_QUOTES, 'UTF-8')) ?></div>
                                </div>
                            <?php endif; ?>

                            <!-- FECHA DE PUBLICACIÓN -->
                            <div class="mk-info-card">
                                <span class="mk-label">
                                    <div class="icon-wrapper">📅</div>
                                    Publicado
                                </span>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="mk-date-badge">
                                        <?= date('d/m/Y H:i', strtotime($P['created_at'] ?? 'now')) ?>
                                    </span>
                                    <small class="text-muted">• Marketplace de Fe.Tr.A</small>
                                </div>
                            </div>

                            <!-- INFORMACIÓN DEL VENDEDOR MEJORADA -->
                            <div class="mk-info-card">
                                <span class="mk-label">
                                    <div class="icon-wrapper">👤</div>
                                    Vendedor
                                </span>
                                <div class="mk-seller-box">
                                    <div class="mk-seller-avatar">
                                        <?php if (!empty($P['u_avatar'])): ?>
                                            <img src="<?= htmlspecialchars($P['u_avatar'], ENT_QUOTES, 'UTF-8') ?>" 
                                                 alt="Avatar de <?= htmlspecialchars($P['u_nombre'], ENT_QUOTES, 'UTF-8') ?>">
                                        <?php else: ?>
                                            <div class="icon-wrapper">👤</div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="mk-seller-info">
                                        <div class="mk-seller-name">
                                            <?= htmlspecialchars($P['u_nombre'].' '.$P['u_apellido'], ENT_QUOTES, 'UTF-8') ?>
                                        </div>
                                        <?php if (!empty($P['u_telefono'])): ?>
                                            <div class="mk-seller-contact-line">
                                                <div class="icon-wrapper">📱</div>
                                                <?= htmlspecialchars($P['u_telefono'], ENT_QUOTES, 'UTF-8') ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="mk-seller-contact-line">
                                            <div class="icon-wrapper">✉️</div>
                                            <?= htmlspecialchars($P['u_email'], ENT_QUOTES, 'UTF-8') ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- ACCIONES MEJORADAS -->
                            <div class="mk-actions">
                                <?php if (!empty($P['u_telefono'])): ?>
                                    <a href="https://wa.me/<?= preg_replace('/\D+/', '', $P['u_telefono']) ?>?text=Hola,%20vi%20tu%20publicación%20en%20el%20Marketplace%20de%20Fe.Tr.A:%20<?= urlencode($P['titulo']) ?>"
                                       target="_blank"
                                       class="btn btn-mk-wa">
                                        <div class="icon-wrapper">💬</div>
                                        Contactar por WhatsApp
                                    </a>
                                <?php endif; ?>

                                <a href="market.php" class="btn btn-mk-outline">
                                    <div class="icon-wrapper">←</div>
                                    Volver al Marketplace
                                </a>

                                <?php if ($U && $P['usuario_id'] == $U['id']): ?>
                                    <a href="editar_producto_market.php?id=<?= $id ?>"
                                       class="btn btn-mk-edit">
                                        <div class="icon-wrapper">✏️</div>
                                        Editar publicación
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php require __DIR__ . '/_footer.php'; ?>
<?php require __DIR__ . '/_navbar_script.php'; ?>

<!-- LIGHTBOX MEJORADO -->
<div id="mkLightbox" class="mk-lightbox">
    <button type="button" class="mk-lightbox-close">&times;</button>
    
    <button type="button" class="mk-lightbox-nav mk-lightbox-prev" id="mkLightboxPrev">
        ‹
    </button>
    
    <div class="mk-lightbox-inner">
        <img id="mkLightboxImg" src="" alt="">
    </div>
    
    <button type="button" class="mk-lightbox-nav mk-lightbox-next" id="mkLightboxNext">
        ›
    </button>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const fotos = <?php echo json_encode($fotos, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?>;
    const mainImg = document.getElementById('mkMainImg');
    const prevBtn = document.getElementById('mkPrev');
    const nextBtn = document.getElementById('mkNext');
    const lightbox = document.getElementById('mkLightbox');
    const lightImg = document.getElementById('mkLightboxImg');
    const closeBtn = document.querySelector('.mk-lightbox-close');
    const lightboxPrev = document.getElementById('mkLightboxPrev');
    const lightboxNext = document.getElementById('mkLightboxNext');
    const thumbnails = document.querySelectorAll('.mk-thumbnail');

    let idx = 0;

    function updateImg() {
        if (!fotos.length || !mainImg) return;
        mainImg.src = fotos[idx];
        lightImg.src = fotos[idx];
        
        // Actualizar thumbnails activos
        thumbnails.forEach((thumb, index) => {
            thumb.classList.toggle('active', index === idx);
        });
    }

    function navigate(direction) {
        idx = (idx + direction + fotos.length) % fotos.length;
        updateImg();
    }

    if (fotos.length > 1) {
        prevBtn.addEventListener('click', () => navigate(-1));
        nextBtn.addEventListener('click', () => navigate(1));
        lightboxPrev.addEventListener('click', () => navigate(-1));
        lightboxNext.addEventListener('click', () => navigate(1));
        
        // Navegación con teclado
        document.addEventListener('keydown', function (e) {
            if (lightbox.classList.contains('open')) {
                if (e.key === 'ArrowLeft') navigate(-1);
                if (e.key === 'ArrowRight') navigate(1);
            }
        });

        // Thumbnails click
        thumbnails.forEach(thumb => {
            thumb.addEventListener('click', function () {
                idx = parseInt(this.getAttribute('data-index'));
                updateImg();
            });
        });
    }

    function openLightbox() {
        if (!lightbox || !lightImg || !mainImg) return;
        lightImg.src = mainImg.src;
        lightbox.classList.add('open');
        document.body.style.overflow = 'hidden';
    }

    function closeLightbox() {
        if (!lightbox) return;
        lightbox.classList.remove('open');
        document.body.style.overflow = '';
    }

    if (mainImg) {
        mainImg.addEventListener('click', openLightbox);
    }
    if (closeBtn) {
        closeBtn.addEventListener('click', closeLightbox);
    }
    if (lightbox) {
        lightbox.addEventListener('click', function (e) {
            if (e.target === lightbox) closeLightbox();
        });
    }
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape') closeLightbox();
    });

    // Efectos de hover mejorados
    const cards = document.querySelectorAll('.mk-info-card, .mk-seller-box');
    cards.forEach(card => {
        card.addEventListener('mouseenter', function () {
            this.style.transform = 'translateY(-1px)';
        });
        card.addEventListener('mouseleave', function () {
            this.style.transform = 'translateY(0)';
        });
    });
});
</script>
</body>
</html>