<?php
session_start();

/* Base del sitio según dónde esté alojado este archivo.
   Ej.: /generadoresargentina.com.ar  */
$base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])), '/');
if ($base === '/') $base = ''; // normaliza

// Action del form dentro de la misma carpeta
$action = $base . '/procesar_login.php';

// Destino por defecto: /generadoresargentina.com.ar/tienda/dashboard.php
$next = isset($_GET['next']) ? $_GET['next'] : ($base . '/tienda/dashboard.php');
$err  = isset($_GET['err']) ? (int)$_GET['err'] : 0;
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ingresar — Generadores Argentina</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="icon" href="img/logo.png" type="image/png">

  <style>
    :root {
      --primary-color: #000000;
      --secondary-color: #ffb50a;
      --accent-color: #ffcc33;
    }
    
    body { 
      min-height: 100vh; 
      display: flex; 
      align-items: center; 
      justify-content: center; 
      background: linear-gradient(135deg, #ffb50a 0%, #ffcc33 100%);
      font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
    }
    
    .card { 
      max-width: 420px; 
      width: 100%; 
      border: none; 
      border-radius: 16px; 
      box-shadow: 0 20px 40px rgba(0,0,0,.15); 
      overflow: hidden;
      transition: transform 0.3s ease;
    }
    
    .card:hover {
      transform: translateY(-5px);
    }
    
    .card-header { 
      background: linear-gradient(90deg, var(--primary-color), #1a1a1a); 
      color: #fff; 
      border: 0; 
      border-radius: 16px 16px 0 0;
      padding: 2rem 1.5rem;
      text-align: center;
    }
    
    .brand {
      font-weight: 700;
      font-size: 1.5rem;
      background: linear-gradient(to right, var(--secondary-color), #ffcc33);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      margin-bottom: 0.5rem;
    }
    
    .card-header .small {
      color: rgba(255, 255, 255, 0.8);
      font-size: 0.9rem;
    }
    
    .card-body {
      padding: 2.5rem 1.5rem;
      background: white;
    }
    
    .form-label {
      font-weight: 600;
      color: #333;
      margin-bottom: 0.5rem;
    }
    
    .form-control {
      border-radius: 10px;
      padding: 0.75rem 1rem;
      border: 2px solid #e9ecef;
      transition: all 0.3s ease;
    }
    
    .form-control:focus {
      border-color: var(--accent-color);
      box-shadow: 0 0 0 0.25rem rgba(255, 181, 10, 0.25);
    }
    
    .btn-primary {
      background: linear-gradient(90deg, var(--primary-color), #333333);
      border: none;
      border-radius: 10px;
      padding: 0.75rem 1.5rem;
      font-weight: 600;
      transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
      background: linear-gradient(90deg, #333333, var(--primary-color));
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
    }
    
    .alert {
      border-radius: 10px;
      border: none;
      padding: 1rem 1.25rem;
    }
    
    .alert-danger {
      background: linear-gradient(90deg, #dc3545, #c82333);
      color: white;
    }
    
    .alert-warning {
      background: linear-gradient(90deg, #ffc107, #e0a800);
      color: #212529;
    }
    
    .text-muted {
      color: #6c757d !important;
    }
    
    a.text-muted:hover {
      color: var(--primary-color) !important;
    }
    
    .login-icon {
      font-size: 2rem;
      margin-bottom: 1rem;
      color: var(--secondary-color);
    }
  </style>
</head>
<body>
  <div class="card">
    <div class="card-header py-4">
      <div class="login-icon">
        <i class="fas fa-lock"></i>
      </div>
      <div class="brand">Generadores Argentina</div>
      <div class="small">Acceso al panel de administración</div>
    </div>
    <div class="card-body p-4">
      <?php if ($err === 1): ?>
        <div class="alert alert-danger">
          <i class="fas fa-exclamation-triangle me-2"></i>Usuario o contraseña incorrectos.
        </div>
      <?php elseif ($err === 2): ?>
        <div class="alert alert-warning">
          <i class="fas fa-clock me-2"></i>Tu sesión expiró o no estabas logueado.
        </div>
      <?php endif; ?>

      <form action="<?php echo htmlspecialchars($action, ENT_QUOTES, 'UTF-8'); ?>" method="post" autocomplete="off" novalidate>
        <input type="hidden" name="next" value="<?php echo htmlspecialchars($next, ENT_QUOTES, 'UTF-8'); ?>">
        <div class="mb-3">
          <label for="user" class="form-label">
            <i class="fas fa-user me-1"></i>Usuario
          </label>
          <input type="text" class="form-control" id="user" name="user" required autofocus placeholder="Ingresa tu usuario">
        </div>
        <div class="mb-4">
          <label for="pass" class="form-label">
            <i class="fas fa-key me-1"></i>Contraseña
          </label>
          <input type="password" class="form-control" id="pass" name="pass" required placeholder="Ingresa tu contraseña">
        </div>
        <div class="d-grid">
          <button class="btn btn-primary" type="submit">
            <i class="fas fa-sign-in-alt me-2"></i>Ingresar al panel
          </button>
        </div>
      </form>

      <div class="text-center mt-4 pt-3 border-top">
        <a href="<?php echo $base === '' ? '/' : $base . '/'; ?>" class="small text-muted text-decoration-none">
          <i class="fas fa-arrow-left me-1"></i>Volver al sitio principal
        </a>
      </div>
    </div>
  </div>
</body>
</html>