<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Dashboard de Administración</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f8f9fa;
    }
    .card-hover:hover {
      transform: scale(1.02);
      transition: 0.3s;
    }
    .dashboard-icon {
      font-size: 2.5rem;
      color: #0d6efd;
    }
    .navbar-brand {
      font-weight: bold;
    }
  </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Panel administración</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarContent">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarContent">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link active" href="dashboard.php">Dashboard</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="formulario.html">Cargar</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="ver_publicaciones.php">Ver</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="ver_gestion.php">Administrar</a>
        </li>
      </ul>
    </div>
  </div>
</nav>

<div class="container py-5">
  <h1 class="text-center mb-5">Panel de Publicaciones</h1>
  <div class="row g-4 justify-content-center">

    <div class="col-md-4">
      <div class="card card-hover shadow-sm h-100">
        <div class="card-body text-center">
          <div class="dashboard-icon mb-3">📝</div>
          <h5 class="card-title">Cargar nueva publicación</h5>
          <p class="card-text">Subí una nueva publicación con título, contenido e imagen.</p>
          <a href="formulario.html" class="btn btn-primary">Ir a Cargar</a>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card card-hover shadow-sm h-100">
        <div class="card-body text-center">
          <div class="dashboard-icon mb-3">📄</div>
          <h5 class="card-title">Ver publicaciones</h5>
          <p class="card-text">Mirá todas las publicaciones cargadas por fecha.</p>
          <a href="ver_publicaciones.php" class="btn btn-primary">Ver publicaciones</a>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card card-hover shadow-sm h-100">
        <div class="card-body text-center">
          <div class="dashboard-icon mb-3">🛠️</div>
          <h5 class="card-title">Editar / Borrar publicaciones</h5>
          <p class="card-text">Modificá o eliminá publicaciones existentes fácilmente.</p>
          <a href="ver_gestion.php" class="btn btn-primary">Administrar</a>
        </div>
      </div>
    </div>

  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<footer>
    <div class="container text-center">
        <p class="mb-0">© 2025 NETFAN. Todos los derechos reservados.</p>
      <div class="col-md-6 text-center text-md-end">
          
        <small class="text-white-50">Diseño y desarrollo por <a href="https://netfan.host" class="text-white">NETFAN</a></small>
      </div>
             <div class="social-icons">
            <a href="https://netfan.host" class="text-white mx-2"><i class="fas fa-question-circle"></i> Ayuda</a>
            <a href="https://netfan.host" class="text-white mx-2"><i class="fas fa-envelope"></i> Soporte</a>
    </div>
  </div>
</footer>

</body>

</html>
